/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl.operation.steps;

import com.hazelcast.map.impl.operation.steps.GetOpSteps;
import com.hazelcast.map.impl.operation.steps.IMapOpStep;
import com.hazelcast.map.impl.operation.steps.UtilSteps;
import com.hazelcast.map.impl.operation.steps.engine.State;
import com.hazelcast.map.impl.operation.steps.engine.Step;
import com.hazelcast.map.impl.record.Record;
import com.hazelcast.map.impl.recordstore.DefaultRecordStore;
import com.hazelcast.map.impl.recordstore.RecordStore;

public enum ContainsKeyOpSteps implements IMapOpStep
{
    READ{

        @Override
        public void runStep(State state) {
            RecordStore recordStore = state.getRecordStore();
            Object record = recordStore.getRecordOrNull(state.getKey(), false);
            if (record != null) {
                state.setOldValue(record.getValue());
                recordStore.accessRecord(state.getKey(), (Record)record, state.getNow());
            }
        }

        @Override
        public Step nextStep(State state) {
            return state.getOldValue() == null ? LOAD : UtilSteps.FINAL_STEP;
        }
    }
    ,
    LOAD{

        @Override
        public boolean isLoadStep() {
            return true;
        }

        @Override
        public void runStep(State state) {
            GetOpSteps.LOAD.runStep(state);
        }

        @Override
        public Step nextStep(State state) {
            return state.getOldValue() == null ? UtilSteps.FINAL_STEP : ON_LOAD;
        }
    }
    ,
    ON_LOAD{

        @Override
        public void runStep(State state) {
            RecordStore recordStore = state.getRecordStore();
            Record record = ((DefaultRecordStore)recordStore).onLoadRecord(state.getKey(), state.getOldValue(), false, state.getCallerAddress());
            record = recordStore.evictIfExpired(state.getKey(), state.getNow(), false) ? null : record;
            state.setOldValue(record == null ? null : record.getValue());
            if (record != null) {
                recordStore.accessRecord(state.getKey(), record, state.getNow());
            }
        }

        @Override
        public Step nextStep(State state) {
            return UtilSteps.FINAL_STEP;
        }
    };

}

