/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.pipeline;

import com.hazelcast.function.BiConsumerEx;
import com.hazelcast.function.BiFunctionEx;
import com.hazelcast.function.BiPredicateEx;
import com.hazelcast.function.FunctionEx;
import com.hazelcast.function.SupplierEx;
import com.hazelcast.internal.util.MapUtil;
import com.hazelcast.jet.Traverser;
import com.hazelcast.jet.aggregate.AggregateOperation1;
import com.hazelcast.jet.core.Processor;
import com.hazelcast.jet.core.ProcessorMetaSupplier;
import com.hazelcast.jet.core.ProcessorSupplier;
import com.hazelcast.jet.function.TriFunction;
import com.hazelcast.jet.function.TriPredicate;
import com.hazelcast.jet.pipeline.GeneralStageWithKey;
import com.hazelcast.jet.pipeline.ServiceFactory;
import com.hazelcast.jet.pipeline.StageWithKeyAndWindow;
import com.hazelcast.jet.pipeline.StreamStage;
import com.hazelcast.jet.pipeline.WindowDefinition;
import com.hazelcast.map.IMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;

public interface StreamStageWithKey<T, K>
extends GeneralStageWithKey<T, K> {
    @Nonnull
    public StageWithKeyAndWindow<T, K> window(@Nonnull WindowDefinition var1);

    @Nonnull
    public <S, R> StreamStage<R> mapStateful(long var1, @Nonnull SupplierEx<? extends S> var3, @Nonnull TriFunction<? super S, ? super K, ? super T, ? extends R> var4, @Nonnull TriFunction<? super S, ? super K, ? super Long, ? extends R> var5);

    @Override
    @Nonnull
    public <S, R> StreamStage<R> mapStateful(@Nonnull SupplierEx<? extends S> var1, @Nonnull TriFunction<? super S, ? super K, ? super T, ? extends R> var2);

    @Nonnull
    public <S> StreamStage<T> filterStateful(long var1, @Nonnull SupplierEx<? extends S> var3, @Nonnull BiPredicateEx<? super S, ? super T> var4);

    @Override
    @Nonnull
    default public <S> StreamStage<T> filterStateful(@Nonnull SupplierEx<? extends S> createFn, @Nonnull BiPredicateEx<? super S, ? super T> filterFn) {
        return this.filterStateful(0L, createFn, filterFn);
    }

    @Nonnull
    public <S, R> StreamStage<R> flatMapStateful(long var1, @Nonnull SupplierEx<? extends S> var3, @Nonnull TriFunction<? super S, ? super K, ? super T, ? extends Traverser<R>> var4, @Nonnull TriFunction<? super S, ? super K, ? super Long, ? extends Traverser<R>> var5);

    @Override
    @Nonnull
    public <S, R> StreamStage<R> flatMapStateful(@Nonnull SupplierEx<? extends S> var1, @Nonnull TriFunction<? super S, ? super K, ? super T, ? extends Traverser<R>> var2);

    @Override
    @Nonnull
    default public <A, R> StreamStage<Map.Entry<K, R>> rollingAggregate(@Nonnull AggregateOperation1<? super T, A, ? extends R> aggrOp) {
        return (StreamStage)GeneralStageWithKey.super.rollingAggregate(aggrOp);
    }

    @Nonnull
    default public <A, R> StreamStage<Map.Entry<K, R>> rollingAggregate(long ttl, @Nonnull AggregateOperation1<? super T, A, ? extends R> aggrOp) {
        BiConsumerEx accumulateFn = aggrOp.accumulateFn();
        FunctionEx exportFn = aggrOp.exportFn();
        FunctionEx keyFn = this.keyFn();
        return this.mapStateful(ttl, aggrOp.createFn(), (acc, key, item) -> {
            accumulateFn.accept(acc, item);
            return MapUtil.entry(keyFn.apply(item), exportFn.apply(acc));
        }, (state, key, wm) -> null);
    }

    @Override
    @Nonnull
    default public <V, R> StreamStage<R> mapUsingIMap(@Nonnull String mapName, @Nonnull BiFunctionEx<? super T, ? super V, ? extends R> mapFn) {
        return (StreamStage)GeneralStageWithKey.super.mapUsingIMap(mapName, mapFn);
    }

    @Override
    @Nonnull
    default public <V, R> StreamStage<R> mapUsingIMap(@Nonnull IMap<K, V> iMap, @Nonnull BiFunctionEx<? super T, ? super V, ? extends R> mapFn) {
        return (StreamStage)GeneralStageWithKey.super.mapUsingIMap(iMap, mapFn);
    }

    @Override
    @Nonnull
    public <S, R> StreamStage<R> mapUsingService(@Nonnull ServiceFactory<?, S> var1, @Nonnull TriFunction<? super S, ? super K, ? super T, ? extends R> var2);

    @Override
    @Nonnull
    default public <S, R> StreamStage<R> mapUsingServiceAsync(@Nonnull ServiceFactory<?, S> serviceFactory, @Nonnull TriFunction<? super S, ? super K, ? super T, CompletableFuture<R>> mapAsyncFn) {
        return (StreamStage)GeneralStageWithKey.super.mapUsingServiceAsync(serviceFactory, mapAsyncFn);
    }

    @Override
    @Nonnull
    public <S, R> StreamStage<R> mapUsingServiceAsync(@Nonnull ServiceFactory<?, S> var1, int var2, boolean var3, @Nonnull TriFunction<? super S, ? super K, ? super T, CompletableFuture<R>> var4);

    @Override
    @Nonnull
    public <S, R> StreamStage<R> mapUsingServiceAsyncBatched(@Nonnull ServiceFactory<?, S> var1, int var2, @Nonnull BiFunctionEx<? super S, ? super List<T>, ? extends CompletableFuture<List<R>>> var3);

    @Override
    @Nonnull
    public <S, R> StreamStage<R> mapUsingServiceAsyncBatched(@Nonnull ServiceFactory<?, S> var1, int var2, @Nonnull TriFunction<? super S, ? super List<K>, ? super List<T>, ? extends CompletableFuture<List<R>>> var3);

    @Override
    @Nonnull
    public <S> StreamStage<T> filterUsingService(@Nonnull ServiceFactory<?, S> var1, @Nonnull TriPredicate<? super S, ? super K, ? super T> var2);

    @Override
    @Nonnull
    public <S, R> StreamStage<R> flatMapUsingService(@Nonnull ServiceFactory<?, S> var1, @Nonnull TriFunction<? super S, ? super K, ? super T, ? extends Traverser<R>> var2);

    @Override
    @Nonnull
    default public <R> StreamStage<R> customTransform(@Nonnull String stageName, @Nonnull SupplierEx<Processor> procSupplier) {
        return this.customTransform(stageName, ProcessorMetaSupplier.of(procSupplier));
    }

    @Override
    @Nonnull
    default public <R> StreamStage<R> customTransform(@Nonnull String stageName, @Nonnull ProcessorSupplier procSupplier) {
        return this.customTransform(stageName, ProcessorMetaSupplier.of(procSupplier));
    }

    @Override
    @Nonnull
    public <R> StreamStage<R> customTransform(@Nonnull String var1, @Nonnull ProcessorMetaSupplier var2);
}

