/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.impl.deployment;

import com.hazelcast.core.HazelcastException;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedList;
import javax.annotation.Nonnull;

public class ChildFirstClassLoader
extends URLClassLoader {
    private static final ILogger LOG = Logger.getLogger(ChildFirstClassLoader.class);
    private volatile boolean closed;

    public ChildFirstClassLoader(@Nonnull URL[] urls2, @Nonnull ClassLoader parent) {
        super(urls2, parent);
        for (URL url : urls2) {
            try {
                if (new File(url.toURI()).exists()) continue;
                LOG.warning("URL '" + url + "' does not point to an existing local file.");
            }
            catch (URISyntaxException e) {
                throw new HazelcastException("URL has incorrect syntax", e);
            }
        }
        if (urls2.length == 0) {
            throw new IllegalArgumentException("urls must not be null nor empty");
        }
        if (parent == null) {
            throw new IllegalArgumentException("parent must not be null");
        }
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        return super.findClass(name);
    }

    @Override
    protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Class<?> loadedClass = this.findLoadedClass(name);
        if (loadedClass == null) {
            try {
                loadedClass = this.findClass(name);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            if (loadedClass == null) {
                loadedClass = this.getParent().loadClass(name);
            }
            if (loadedClass == null) {
                throw new ClassNotFoundException("Could not find class " + name + " in classloader nor in parent classloader");
            }
        }
        if (resolve) {
            this.resolveClass(loadedClass);
        }
        return loadedClass;
    }

    @Override
    public Enumeration<URL> getResources(String name) throws IOException {
        Enumeration<URL> parentRes;
        final LinkedList<URL> allRes = new LinkedList<URL>();
        Enumeration<URL> thisRes = this.findResources(name);
        if (thisRes != null) {
            while (thisRes.hasMoreElements()) {
                allRes.add(thisRes.nextElement());
            }
        }
        if ((parentRes = super.findResources(name)) != null) {
            while (parentRes.hasMoreElements()) {
                allRes.add(parentRes.nextElement());
            }
        }
        return new Enumeration<URL>(){
            final Iterator<URL> it;
            {
                this.it = allRes.iterator();
            }

            @Override
            public boolean hasMoreElements() {
                return this.it.hasNext();
            }

            @Override
            public URL nextElement() {
                return this.it.next();
            }
        };
    }

    @Override
    public URL getResource(String name) {
        URL res = this.findResource(name);
        if (res == null) {
            res = super.getResource(name);
        }
        return res;
    }

    @Override
    public void close() throws IOException {
        super.close();
        this.closed = true;
    }

    public boolean isClosed() {
        return this.closed;
    }
}

