/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.tpcengine.nio;

import com.hazelcast.internal.tpcengine.iobuffer.IOBuffer;
import com.hazelcast.internal.tpcengine.net.AsyncSocket;
import com.hazelcast.internal.tpcengine.net.AsyncSocketMetrics;
import com.hazelcast.internal.tpcengine.net.AsyncSocketOptions;
import com.hazelcast.internal.tpcengine.net.AsyncSocketReader;
import com.hazelcast.internal.tpcengine.nio.IOVector;
import com.hazelcast.internal.tpcengine.nio.NioAsyncSocketBuilder;
import com.hazelcast.internal.tpcengine.nio.NioAsyncSocketOptions;
import com.hazelcast.internal.tpcengine.nio.NioHandler;
import com.hazelcast.internal.tpcengine.nio.NioReactor;
import com.hazelcast.internal.tpcengine.util.BufferUtil;
import com.hazelcast.internal.tpcengine.util.CircularQueue;
import com.hazelcast.internal.tpcengine.util.CloseUtil;
import com.hazelcast.internal.tpcengine.util.ExceptionUtil;
import com.hazelcast.internal.tpcengine.util.Preconditions;
import com.hazelcast.shaded.org.jctools.queues.MpmcArrayQueue;
import java.io.EOFException;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.SocketAddress;
import java.net.SocketException;
import java.nio.ByteBuffer;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicReference;

public final class NioAsyncSocket
extends AsyncSocket {
    private final NioAsyncSocketOptions options;
    private final AtomicReference<Thread> flushThread = new AtomicReference<Thread>(Thread.currentThread());
    private final MpmcArrayQueue<IOBuffer> writeQueue;
    private final Handler handler;
    private final SocketChannel socketChannel;
    private final NioReactor reactor;
    private final Thread eventloopThread;
    private final SelectionKey key;
    private final IOVector ioVector = new IOVector();
    private final boolean regularSchedule;
    private final boolean writeThrough;
    private final AsyncSocketReader reader;
    private final CircularQueue localTaskQueue;
    private boolean started;
    private boolean connecting;
    private volatile CompletableFuture<Void> connectFuture;

    NioAsyncSocket(NioAsyncSocketBuilder builder) {
        super(builder.clientSide);
        assert (Thread.currentThread() == builder.reactor.eventloopThread());
        try {
            this.reactor = builder.reactor;
            this.localTaskQueue = builder.reactor.eventloop().localTaskQueue;
            this.options = builder.options;
            this.eventloopThread = this.reactor.eventloopThread();
            this.socketChannel = builder.socketChannel;
            if (!this.clientSide) {
                this.localAddress = this.socketChannel.getLocalAddress();
                this.remoteAddress = this.socketChannel.getRemoteAddress();
            }
            this.writeThrough = builder.writeThrough;
            this.regularSchedule = builder.regularSchedule;
            this.writeQueue = new MpmcArrayQueue(builder.writeQueueCapacity);
            this.handler = new Handler(builder);
            this.key = this.socketChannel.register(this.reactor.selector, 0, this.handler);
            this.reader = builder.reader;
            this.reader.init(this);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public AsyncSocketOptions options() {
        return this.options;
    }

    @Override
    public NioReactor reactor() {
        return this.reactor;
    }

    @Override
    public void setReadable(boolean readable) {
        if (Thread.currentThread() == this.eventloopThread) {
            this.setReadable0(readable);
        } else {
            CompletableFuture future = new CompletableFuture();
            this.reactor.execute(() -> {
                try {
                    this.setReadable0(readable);
                    future.complete(null);
                }
                catch (Throwable t2) {
                    future.completeExceptionally(t2);
                    throw ExceptionUtil.sneakyThrow(t2);
                }
            });
            future.join();
        }
    }

    private void setReadable0(boolean readable) {
        if (readable) {
            this.key.interestOps(this.key.interestOps() | 1);
        } else {
            this.key.interestOps(this.key.interestOps() & 0xFFFFFFFE);
        }
    }

    @Override
    public boolean isReadable() {
        if (Thread.currentThread() == this.eventloopThread) {
            return this.isReadable0();
        }
        CompletableFuture future = new CompletableFuture();
        this.reactor.execute(() -> {
            try {
                future.complete(this.isReadable0());
            }
            catch (Throwable t2) {
                future.completeExceptionally(t2);
                throw ExceptionUtil.sneakyThrow(t2);
            }
        });
        return (Boolean)future.join();
    }

    private boolean isReadable0() {
        return (this.key.interestOps() & 1) != 0;
    }

    @Override
    public void start() {
        if (Thread.currentThread() == this.reactor.eventloopThread()) {
            this.start0();
        } else {
            CompletableFuture future = new CompletableFuture();
            this.reactor.execute(() -> {
                try {
                    this.start0();
                    future.complete(null);
                }
                catch (Throwable e) {
                    future.completeExceptionally(e);
                    throw ExceptionUtil.sneakyThrow(e);
                }
            });
            future.join();
        }
    }

    private void start0() {
        if (this.started) {
            throw new IllegalStateException(this + " is already started");
        }
        this.started = true;
        assert (this.flushThread.get() == this.reactor.eventloopThread());
        if (!this.clientSide) {
            this.key.interestOps(this.key.interestOps() | 1);
            this.resetFlushed();
        }
    }

    @Override
    public CompletableFuture<Void> connect(SocketAddress address) {
        Preconditions.checkNotNull(address, "address");
        if (this.logger.isInfoEnabled()) {
            this.logger.info("Connecting to address:" + address);
        }
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        if (Thread.currentThread() == this.eventloopThread) {
            this.connect0(address, future);
        } else {
            this.reactor.execute(() -> this.connect0(address, future));
        }
        return future;
    }

    private void connect0(SocketAddress address, CompletableFuture<Void> future) {
        try {
            if (!this.started) {
                throw new IllegalStateException(this + " can't connect when socket not yet started");
            }
            if (this.connecting) {
                throw new IllegalStateException(this + " is already trying to connect");
            }
            assert (this.flushThread.get() == this.reactor.eventloopThread());
            this.connecting = true;
            this.connectFuture = future;
            this.key.interestOps(this.key.interestOps() | 8);
            if (this.socketChannel.connect(address)) {
                this.onConnectFinished();
            }
        }
        catch (Throwable e) {
            future.completeExceptionally(e);
            throw ExceptionUtil.sneakyThrow(e);
        }
    }

    private void onConnectFinished() throws IOException {
        assert (this.connecting);
        assert (this.flushThread.get() == this.reactor.eventloopThread());
        this.remoteAddress = this.socketChannel.getRemoteAddress();
        this.localAddress = this.socketChannel.getLocalAddress();
        if (this.logger.isInfoEnabled()) {
            this.logger.info("Connection established " + this);
        }
        this.key.interestOps(this.key.interestOps() | 1);
        this.connectFuture.complete(null);
        this.connectFuture = null;
        this.resetFlushed();
    }

    @Override
    public void flush() {
        Thread currentThread = Thread.currentThread();
        if (this.flushThread.compareAndSet(null, currentThread)) {
            if (currentThread == this.eventloopThread) {
                this.localTaskQueue.add(this.handler);
            } else if (this.writeThrough) {
                this.handler.run();
            } else if (this.regularSchedule) {
                this.reactor.offer(this.handler);
            } else {
                this.key.interestOps(this.key.interestOps() | 4);
                this.reactor.wakeup();
            }
        }
    }

    private void resetFlushed() {
        this.flushThread.set(null);
        if (!this.writeQueue.isEmpty() && this.flushThread.compareAndSet(null, Thread.currentThread())) {
            this.reactor.offer(this.handler);
        }
    }

    @Override
    public boolean write(IOBuffer buf) {
        return this.writeQueue.add(buf);
    }

    @Override
    public boolean writeAll(Collection<IOBuffer> bufs) {
        return this.writeQueue.addAll(bufs);
    }

    @Override
    public boolean writeAndFlush(IOBuffer buf) {
        boolean result = this.write(buf);
        this.flush();
        return result;
    }

    @Override
    public boolean unsafeWriteAndFlush(IOBuffer buf) {
        boolean result;
        Thread currentFlushThread = this.flushThread.get();
        Thread currentThread = Thread.currentThread();
        assert (currentThread == this.eventloopThread);
        if (currentFlushThread == null) {
            if (this.flushThread.compareAndSet(null, currentThread)) {
                this.localTaskQueue.add(this.handler);
                result = this.ioVector.offer(buf) ? true : this.writeQueue.offer(buf);
            } else {
                result = this.writeQueue.offer(buf);
            }
        } else if (currentFlushThread == this.eventloopThread) {
            result = this.ioVector.offer(buf) ? true : this.writeQueue.offer(buf);
        } else {
            result = this.writeQueue.offer(buf);
            this.flush();
        }
        return result;
    }

    @Override
    protected void close0() throws IOException {
        CloseUtil.closeQuietly(this.socketChannel);
        this.key.cancel();
        super.close0();
    }

    private final class Handler
    implements NioHandler,
    Runnable {
        private final ByteBuffer rcvBuffer;
        private final AsyncSocketMetrics metrics;

        private Handler(NioAsyncSocketBuilder builder) throws SocketException {
            this.metrics = NioAsyncSocket.this.metrics;
            int receiveBufferSize = builder.socketChannel.socket().getReceiveBufferSize();
            this.rcvBuffer = builder.receiveBufferIsDirect ? ByteBuffer.allocateDirect(receiveBufferSize) : ByteBuffer.allocate(receiveBufferSize);
        }

        @Override
        public void run() {
            try {
                this.handleWrite();
            }
            catch (Throwable e) {
                this.close(null, e);
                throw ExceptionUtil.sneakyThrow(e);
            }
        }

        @Override
        public void close(String reason, Throwable cause) {
            if (cause instanceof EOFException) {
                NioAsyncSocket.this.close(reason != null ? reason : cause.getMessage(), null);
            } else {
                NioAsyncSocket.this.close(reason, cause);
            }
        }

        @Override
        public void handle() throws IOException {
            if (!NioAsyncSocket.this.key.isValid()) {
                throw new CancelledKeyException();
            }
            int readyOps = NioAsyncSocket.this.key.readyOps();
            if ((readyOps & 1) != 0) {
                this.handleRead();
            }
            if ((readyOps & 4) != 0) {
                this.handleWrite();
            }
            if ((readyOps & 8) != 0) {
                this.handleConnect();
            }
        }

        private void handleRead() throws IOException {
            this.metrics.incReadEvents();
            int read = NioAsyncSocket.this.socketChannel.read(this.rcvBuffer);
            if (read == -1) {
                throw new EOFException("Socket closed by peer");
            }
            this.metrics.incBytesRead(read);
            BufferUtil.upcast(this.rcvBuffer).flip();
            NioAsyncSocket.this.reader.onRead(this.rcvBuffer);
            BufferUtil.compactOrClear(this.rcvBuffer);
        }

        private void handleWrite() throws IOException {
            this.metrics.incWriteEvents();
            NioAsyncSocket.this.ioVector.populate(NioAsyncSocket.this.writeQueue);
            ByteBuffer[] srcs = NioAsyncSocket.this.ioVector.array();
            int length = NioAsyncSocket.this.ioVector.length();
            long written = length == 1 ? (long)NioAsyncSocket.this.socketChannel.write(srcs[0]) : NioAsyncSocket.this.socketChannel.write(srcs, 0, length);
            NioAsyncSocket.this.ioVector.compact(written);
            this.metrics.incBytesWritten(written);
            if (NioAsyncSocket.this.ioVector.isEmpty()) {
                int interestOps = NioAsyncSocket.this.key.interestOps();
                if ((interestOps & 4) != 0) {
                    NioAsyncSocket.this.key.interestOps(interestOps & 0xFFFFFFFB);
                }
                NioAsyncSocket.this.resetFlushed();
            } else {
                NioAsyncSocket.this.key.interestOps(NioAsyncSocket.this.key.interestOps() | 4);
            }
        }

        private void handleConnect() {
            try {
                assert (NioAsyncSocket.this.flushThread.get() != null);
                if (!NioAsyncSocket.this.socketChannel.finishConnect()) {
                    throw new IllegalStateException();
                }
                NioAsyncSocket.this.onConnectFinished();
            }
            catch (Throwable e) {
                if (NioAsyncSocket.this.connectFuture != null) {
                    NioAsyncSocket.this.connectFuture.completeExceptionally(e);
                }
                throw ExceptionUtil.sneakyThrow(e);
            }
        }
    }
}

