/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.serialization.impl.portable;

import com.hazelcast.internal.nio.BufferObjectDataInput;
import com.hazelcast.internal.nio.IOUtil;
import com.hazelcast.internal.nio.PortableUtil;
import com.hazelcast.internal.serialization.impl.portable.PortableSerializer;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.serialization.ClassDefinition;
import com.hazelcast.nio.serialization.FieldDefinition;
import com.hazelcast.nio.serialization.FieldType;
import com.hazelcast.nio.serialization.HazelcastSerializationException;
import com.hazelcast.nio.serialization.Portable;
import com.hazelcast.nio.serialization.PortableReader;
import java.io.IOException;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class DefaultPortableReader
implements PortableReader {
    protected final ClassDefinition cd;
    protected final PortableSerializer serializer;
    private final BufferObjectDataInput in;
    private final int finalPosition;
    private final int offset;
    private boolean raw;

    DefaultPortableReader(PortableSerializer serializer, BufferObjectDataInput in, ClassDefinition cd2) {
        int fieldCount;
        this.in = in;
        this.serializer = serializer;
        this.cd = cd2;
        try {
            this.finalPosition = in.readInt();
            fieldCount = in.readInt();
        }
        catch (IOException e) {
            throw new HazelcastSerializationException(e);
        }
        if (fieldCount != cd2.getFieldCount()) {
            throw new IllegalStateException("Field count[" + fieldCount + "] in stream does not match " + cd2);
        }
        this.offset = in.position();
    }

    public ClassDefinition getClassDefinition() {
        return this.cd;
    }

    @Override
    public int getVersion() {
        return this.cd.getVersion();
    }

    @Override
    public boolean hasField(@Nonnull String fieldName) {
        return this.cd.hasField(fieldName);
    }

    @Override
    @Nonnull
    public Set<String> getFieldNames() {
        return this.cd.getFieldNames();
    }

    @Override
    @Nonnull
    public FieldType getFieldType(@Nonnull String fieldName) {
        return this.cd.getFieldType(fieldName);
    }

    @Override
    public int getFieldClassId(@Nonnull String fieldName) {
        return this.cd.getFieldClassId(fieldName);
    }

    @Override
    @Nonnull
    public ObjectDataInput getRawDataInput() throws IOException {
        if (!this.raw) {
            int pos = this.in.readInt(this.offset + this.cd.getFieldCount() * 4);
            this.in.position(pos);
        }
        this.raw = true;
        return this.in;
    }

    final void end() {
        this.in.position(this.finalPosition);
    }

    @Override
    public byte readByte(@Nonnull String fieldName) throws IOException {
        return this.in.readByte(this.readPosition(fieldName, FieldType.BYTE));
    }

    @Override
    public short readShort(@Nonnull String fieldName) throws IOException {
        return this.in.readShort(this.readPosition(fieldName, FieldType.SHORT));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private <T> T readNullableField(@Nonnull String fieldName, FieldType fieldType, Reader<ObjectDataInput, T> reader) throws IOException {
        int currentPos = this.in.position();
        try {
            int pos = this.readPosition(fieldName, fieldType);
            this.in.position(pos);
            boolean isNull = this.in.readBoolean();
            if (isNull) {
                T t2 = null;
                return t2;
            }
            T t3 = reader.read(this.in);
            return t3;
        }
        finally {
            this.in.position(currentPos);
        }
    }

    @Override
    @Nullable
    public BigDecimal readDecimal(@Nonnull String fieldName) throws IOException {
        return this.readNullableField(fieldName, FieldType.DECIMAL, IOUtil::readBigDecimal);
    }

    @Override
    @Nullable
    public LocalTime readTime(@Nonnull String fieldName) throws IOException {
        return this.readNullableField(fieldName, FieldType.TIME, PortableUtil::readLocalTime);
    }

    @Override
    @Nullable
    public LocalDate readDate(@Nonnull String fieldName) throws IOException {
        return this.readNullableField(fieldName, FieldType.DATE, PortableUtil::readLocalDate);
    }

    @Override
    @Nullable
    public LocalDateTime readTimestamp(@Nonnull String fieldName) throws IOException {
        return this.readNullableField(fieldName, FieldType.TIMESTAMP, PortableUtil::readLocalDateTime);
    }

    @Override
    @Nullable
    public OffsetDateTime readTimestampWithTimezone(@Nonnull String fieldName) throws IOException {
        return this.readNullableField(fieldName, FieldType.TIMESTAMP_WITH_TIMEZONE, PortableUtil::readOffsetDateTime);
    }

    @Override
    public int readInt(@Nonnull String fieldName) throws IOException {
        return this.in.readInt(this.readPosition(fieldName, FieldType.INT));
    }

    @Override
    public long readLong(@Nonnull String fieldName) throws IOException {
        return this.in.readLong(this.readPosition(fieldName, FieldType.LONG));
    }

    @Override
    public float readFloat(@Nonnull String fieldName) throws IOException {
        return this.in.readFloat(this.readPosition(fieldName, FieldType.FLOAT));
    }

    @Override
    public double readDouble(@Nonnull String fieldName) throws IOException {
        return this.in.readDouble(this.readPosition(fieldName, FieldType.DOUBLE));
    }

    @Override
    public boolean readBoolean(@Nonnull String fieldName) throws IOException {
        return this.in.readBoolean(this.readPosition(fieldName, FieldType.BOOLEAN));
    }

    @Override
    public char readChar(@Nonnull String fieldName) throws IOException {
        return this.in.readChar(this.readPosition(fieldName, FieldType.CHAR));
    }

    @Override
    @Nullable
    public String readUTF(@Nonnull String fieldName) throws IOException {
        return this.readString(fieldName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public String readString(@Nonnull String fieldName) throws IOException {
        int currentPos = this.in.position();
        try {
            int pos = this.readPosition(fieldName, FieldType.UTF);
            this.in.position(pos);
            String string = this.in.readString();
            return string;
        }
        finally {
            this.in.position(currentPos);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public Portable readPortable(@Nonnull String fieldName) throws IOException {
        int currentPos = this.in.position();
        try {
            FieldDefinition fd = this.cd.getField(fieldName);
            if (fd == null) {
                throw this.throwUnknownFieldException(fieldName);
            }
            if (fd.getType() != FieldType.PORTABLE) {
                throw new HazelcastSerializationException("Not a Portable field: " + fieldName);
            }
            int pos = this.readPosition(fd);
            this.in.position(pos);
            boolean isNull = this.in.readBoolean();
            int factoryId = this.in.readInt();
            int classId = this.in.readInt();
            this.checkFactoryAndClass(fd, factoryId, classId);
            if (!isNull) {
                Portable portable = (Portable)this.serializer.read(this.in, factoryId, classId);
                return portable;
            }
            Portable portable = null;
            return portable;
        }
        finally {
            this.in.position(currentPos);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private <T> T readPrimitiveArrayField(@Nonnull String fieldName, FieldType fieldType, Reader<ObjectDataInput, T> reader) throws IOException {
        int currentPos = this.in.position();
        try {
            int position = this.readPosition(fieldName, fieldType);
            this.in.position(position);
            T t2 = reader.read(this.in);
            return t2;
        }
        finally {
            this.in.position(currentPos);
        }
    }

    @Override
    @Nullable
    public byte[] readByteArray(@Nonnull String fieldName) throws IOException {
        return this.readPrimitiveArrayField(fieldName, FieldType.BYTE_ARRAY, ObjectDataInput::readByteArray);
    }

    @Override
    @Nullable
    public boolean[] readBooleanArray(@Nonnull String fieldName) throws IOException {
        return this.readPrimitiveArrayField(fieldName, FieldType.BOOLEAN_ARRAY, ObjectDataInput::readBooleanArray);
    }

    @Override
    @Nullable
    public char[] readCharArray(@Nonnull String fieldName) throws IOException {
        return this.readPrimitiveArrayField(fieldName, FieldType.CHAR_ARRAY, ObjectDataInput::readCharArray);
    }

    @Override
    @Nullable
    public int[] readIntArray(@Nonnull String fieldName) throws IOException {
        return this.readPrimitiveArrayField(fieldName, FieldType.INT_ARRAY, ObjectDataInput::readIntArray);
    }

    @Override
    @Nullable
    public long[] readLongArray(@Nonnull String fieldName) throws IOException {
        return this.readPrimitiveArrayField(fieldName, FieldType.LONG_ARRAY, ObjectDataInput::readLongArray);
    }

    @Override
    @Nullable
    public double[] readDoubleArray(@Nonnull String fieldName) throws IOException {
        return this.readPrimitiveArrayField(fieldName, FieldType.DOUBLE_ARRAY, ObjectDataInput::readDoubleArray);
    }

    @Override
    @Nullable
    public float[] readFloatArray(@Nonnull String fieldName) throws IOException {
        return this.readPrimitiveArrayField(fieldName, FieldType.FLOAT_ARRAY, ObjectDataInput::readFloatArray);
    }

    @Override
    @Nullable
    public short[] readShortArray(@Nonnull String fieldName) throws IOException {
        return this.readPrimitiveArrayField(fieldName, FieldType.SHORT_ARRAY, ObjectDataInput::readShortArray);
    }

    @Override
    @Nullable
    public String[] readUTFArray(@Nonnull String fieldName) throws IOException {
        return this.readStringArray(fieldName);
    }

    @Override
    @Nullable
    public String[] readStringArray(@Nonnull String fieldName) throws IOException {
        return this.readPrimitiveArrayField(fieldName, FieldType.UTF_ARRAY, ObjectDataInput::readStringArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public Portable[] readPortableArray(@Nonnull String fieldName) throws IOException {
        int currentPos = this.in.position();
        try {
            FieldDefinition fd = this.cd.getField(fieldName);
            if (fd == null) {
                throw this.throwUnknownFieldException(fieldName);
            }
            if (fd.getType() != FieldType.PORTABLE_ARRAY) {
                throw new HazelcastSerializationException("Not a Portable array field: " + fieldName);
            }
            int position = this.readPosition(fd);
            this.in.position(position);
            int len = this.in.readInt();
            int factoryId = this.in.readInt();
            int classId = this.in.readInt();
            if (len == -1) {
                Portable[] portableArray = null;
                return portableArray;
            }
            this.checkFactoryAndClass(fd, factoryId, classId);
            Portable[] portables = new Portable[len];
            if (len > 0) {
                int offset = this.in.position();
                for (int i = 0; i < len; ++i) {
                    int start = this.in.readInt(offset + i * 4);
                    this.in.position(start);
                    portables[i] = (Portable)this.serializer.read(this.in, factoryId, classId);
                }
            }
            Portable[] portableArray = portables;
            return portableArray;
        }
        finally {
            this.in.position(currentPos);
        }
    }

    private void checkFactoryAndClass(FieldDefinition fd, int factoryId, int classId) {
        if (factoryId != fd.getFactoryId()) {
            throw new IllegalArgumentException("Invalid factoryId! Expected: " + fd.getFactoryId() + ", Current: " + factoryId);
        }
        if (classId != fd.getClassId()) {
            throw new IllegalArgumentException("Invalid classId! Expected: " + fd.getClassId() + ", Current: " + classId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private <T> T[] readObjectArrayField(@Nonnull String fieldName, FieldType fieldType, Function<Integer, T[]> constructor, Reader<ObjectDataInput, T> reader) throws IOException {
        int currentPos = this.in.position();
        try {
            int position = this.readPosition(fieldName, fieldType);
            this.in.position(position);
            int len = this.in.readInt();
            if (len == -1) {
                T[] TArray = null;
                return TArray;
            }
            T[] values2 = constructor.apply(len);
            if (len > 0) {
                int offset = this.in.position();
                for (int i = 0; i < len; ++i) {
                    int pos = this.in.readInt(offset + i * 4);
                    this.in.position(pos);
                    values2[i] = reader.read(this.in);
                }
            }
            T[] TArray = values2;
            return TArray;
        }
        finally {
            this.in.position(currentPos);
        }
    }

    @Override
    @Nullable
    public BigDecimal[] readDecimalArray(@Nonnull String fieldName) throws IOException {
        return this.readObjectArrayField(fieldName, FieldType.DECIMAL_ARRAY, BigDecimal[]::new, IOUtil::readBigDecimal);
    }

    @Override
    @Nullable
    public LocalTime[] readTimeArray(@Nonnull String fieldName) throws IOException {
        return this.readObjectArrayField(fieldName, FieldType.TIME_ARRAY, LocalTime[]::new, PortableUtil::readLocalTime);
    }

    @Override
    @Nullable
    public LocalDate[] readDateArray(@Nonnull String fieldName) throws IOException {
        return this.readObjectArrayField(fieldName, FieldType.DATE_ARRAY, LocalDate[]::new, PortableUtil::readLocalDate);
    }

    @Override
    @Nullable
    public LocalDateTime[] readTimestampArray(@Nonnull String fieldName) throws IOException {
        return this.readObjectArrayField(fieldName, FieldType.TIMESTAMP_ARRAY, LocalDateTime[]::new, PortableUtil::readLocalDateTime);
    }

    @Override
    @Nullable
    public OffsetDateTime[] readTimestampWithTimezoneArray(@Nonnull String fieldName) throws IOException {
        return this.readObjectArrayField(fieldName, FieldType.TIMESTAMP_WITH_TIMEZONE_ARRAY, OffsetDateTime[]::new, PortableUtil::readOffsetDateTime);
    }

    private int readPosition(@Nonnull String fieldName, FieldType fieldType) throws IOException {
        if (this.raw) {
            throw new HazelcastSerializationException("Cannot read Portable fields after getRawDataInput() is called!");
        }
        FieldDefinition fd = this.cd.getField(fieldName);
        if (fd == null) {
            throw this.throwUnknownFieldException(fieldName);
        }
        if (fd.getType() != fieldType) {
            throw new HazelcastSerializationException("Not a '" + (Object)((Object)fieldType) + "' field: " + fieldName);
        }
        return this.readPosition(fd);
    }

    private HazelcastSerializationException throwUnknownFieldException(@Nonnull String fieldName) {
        return new HazelcastSerializationException("Unknown field name: '" + fieldName + "' for ClassDefinition {id: " + this.cd.getClassId() + ", version: " + this.cd.getVersion() + "}");
    }

    private int readPosition(FieldDefinition fd) throws IOException {
        int pos = this.in.readInt(this.offset + fd.getIndex() * 4);
        short len = this.in.readShort(pos);
        return pos + 2 + len + 1;
    }

    protected static interface Reader<T, R> {
        public R read(T var1) throws IOException;
    }
}

