/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.partition.operation;

import com.hazelcast.internal.partition.MigrationCycleOperation;
import com.hazelcast.internal.partition.impl.InternalPartitionServiceImpl;
import com.hazelcast.internal.partition.operation.AbstractPartitionOperation;
import com.hazelcast.logging.ILogger;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.impl.Versioned;
import java.io.IOException;

public final class PartitionStateCheckOperation
extends AbstractPartitionOperation
implements MigrationCycleOperation,
Versioned {
    private long stamp;
    private transient boolean stale;

    public PartitionStateCheckOperation() {
    }

    public PartitionStateCheckOperation(long stamp) {
        this.stamp = stamp;
    }

    @Override
    public void run() {
        ILogger logger2 = this.getLogger();
        InternalPartitionServiceImpl partitionService = (InternalPartitionServiceImpl)this.getService();
        long currentStamp = partitionService.getPartitionStateStamp();
        if (currentStamp != this.stamp) {
            this.stale = true;
            if (logger2.isFineEnabled()) {
                logger2.fine("Partition table is stale! Current stamp: " + currentStamp + ", master stamp: " + this.stamp);
            }
        }
    }

    @Override
    public Object getResponse() {
        return !this.stale;
    }

    @Override
    public String getServiceName() {
        return "hz:core:partitionService";
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        this.stamp = in.readLong();
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        out.writeLong(this.stamp);
    }

    @Override
    public int getClassId() {
        return 21;
    }
}

