/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.instance.impl;

import com.hazelcast.cardinality.CardinalityEstimator;
import com.hazelcast.client.ClientService;
import com.hazelcast.cluster.Cluster;
import com.hazelcast.cluster.Endpoint;
import com.hazelcast.collection.IList;
import com.hazelcast.collection.IQueue;
import com.hazelcast.collection.ISet;
import com.hazelcast.config.Config;
import com.hazelcast.core.DistributedObject;
import com.hazelcast.core.DistributedObjectListener;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.ICacheManager;
import com.hazelcast.core.IExecutorService;
import com.hazelcast.core.LifecycleService;
import com.hazelcast.cp.CPSubsystem;
import com.hazelcast.crdt.pncounter.PNCounter;
import com.hazelcast.durableexecutor.DurableExecutorService;
import com.hazelcast.flakeidgen.FlakeIdGenerator;
import com.hazelcast.instance.impl.BootstrappedJetProxy;
import com.hazelcast.instance.impl.executejar.ExecuteJobParameters;
import com.hazelcast.jet.Job;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import com.hazelcast.logging.LoggingService;
import com.hazelcast.map.IMap;
import com.hazelcast.multimap.MultiMap;
import com.hazelcast.partition.PartitionService;
import com.hazelcast.replicatedmap.ReplicatedMap;
import com.hazelcast.ringbuffer.Ringbuffer;
import com.hazelcast.scheduledexecutor.IScheduledExecutorService;
import com.hazelcast.splitbrainprotection.SplitBrainProtectionService;
import com.hazelcast.sql.SqlService;
import com.hazelcast.topic.ITopic;
import com.hazelcast.transaction.HazelcastXAResource;
import com.hazelcast.transaction.TransactionContext;
import com.hazelcast.transaction.TransactionException;
import com.hazelcast.transaction.TransactionOptions;
import com.hazelcast.transaction.TransactionalTask;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ConcurrentMap;
import javax.annotation.Nonnull;

public final class BootstrappedInstanceProxy
implements HazelcastInstance {
    private static final ILogger LOGGER = Logger.getLogger(BootstrappedInstanceProxy.class);
    private final HazelcastInstance instance;
    private final BootstrappedJetProxy jetProxy;
    private boolean shutDownAllowed = true;

    BootstrappedInstanceProxy(HazelcastInstance instance, BootstrappedJetProxy jetProxy) {
        this.instance = instance;
        this.jetProxy = jetProxy;
    }

    public List<Job> getSubmittedJobs() {
        ExecuteJobParameters executeJobParameters = this.jetProxy.getExecuteJobParameters();
        return executeJobParameters.getSubmittedJobs();
    }

    public BootstrappedInstanceProxy setShutDownAllowed(boolean shutDownAllowed) {
        this.shutDownAllowed = shutDownAllowed;
        return this;
    }

    public void setExecuteJobParameters(ExecuteJobParameters executeJobParameters) {
        this.jetProxy.setExecuteJobParameters(executeJobParameters);
    }

    public void removeExecuteJobParameters() {
        this.jetProxy.removeExecuteJobParameters();
    }

    @Override
    @Nonnull
    public String getName() {
        return this.instance.getName();
    }

    @Override
    @Nonnull
    public <K, V> IMap<K, V> getMap(@Nonnull String name) {
        return this.instance.getMap(name);
    }

    @Override
    @Nonnull
    public <E> IQueue<E> getQueue(@Nonnull String name) {
        return this.instance.getQueue(name);
    }

    @Override
    @Nonnull
    public <E> ITopic<E> getTopic(@Nonnull String name) {
        return this.instance.getTopic(name);
    }

    @Override
    @Nonnull
    public <E> ITopic<E> getReliableTopic(@Nonnull String name) {
        return this.instance.getReliableTopic(name);
    }

    @Override
    @Nonnull
    public <E> ISet<E> getSet(@Nonnull String name) {
        return this.instance.getSet(name);
    }

    @Override
    @Nonnull
    public <E> IList<E> getList(@Nonnull String name) {
        return this.instance.getList(name);
    }

    @Override
    @Nonnull
    public <K, V> MultiMap<K, V> getMultiMap(@Nonnull String name) {
        return this.instance.getMultiMap(name);
    }

    @Override
    @Nonnull
    public <E> Ringbuffer<E> getRingbuffer(@Nonnull String name) {
        return this.instance.getRingbuffer(name);
    }

    @Override
    @Nonnull
    public IExecutorService getExecutorService(@Nonnull String name) {
        return this.instance.getExecutorService(name);
    }

    @Override
    @Nonnull
    public DurableExecutorService getDurableExecutorService(@Nonnull String name) {
        return this.instance.getDurableExecutorService(name);
    }

    @Override
    public <T> T executeTransaction(@Nonnull TransactionalTask<T> task) throws TransactionException {
        return this.instance.executeTransaction(task);
    }

    @Override
    public <T> T executeTransaction(@Nonnull TransactionOptions options, @Nonnull TransactionalTask<T> task) throws TransactionException {
        return this.instance.executeTransaction(options, task);
    }

    @Override
    public TransactionContext newTransactionContext() {
        return this.instance.newTransactionContext();
    }

    @Override
    public TransactionContext newTransactionContext(@Nonnull TransactionOptions options) {
        return this.instance.newTransactionContext(options);
    }

    @Override
    @Nonnull
    public FlakeIdGenerator getFlakeIdGenerator(@Nonnull String name) {
        return this.instance.getFlakeIdGenerator(name);
    }

    @Override
    @Nonnull
    public <K, V> ReplicatedMap<K, V> getReplicatedMap(@Nonnull String name) {
        return this.instance.getReplicatedMap(name);
    }

    @Override
    public ICacheManager getCacheManager() {
        return this.instance.getCacheManager();
    }

    @Override
    @Nonnull
    public Cluster getCluster() {
        return this.instance.getCluster();
    }

    @Override
    @Nonnull
    public Endpoint getLocalEndpoint() {
        return this.instance.getLocalEndpoint();
    }

    @Override
    public Collection<DistributedObject> getDistributedObjects() {
        return this.instance.getDistributedObjects();
    }

    @Override
    @Nonnull
    public Config getConfig() {
        return this.instance.getConfig();
    }

    @Override
    @Nonnull
    public PartitionService getPartitionService() {
        return this.instance.getPartitionService();
    }

    @Override
    @Nonnull
    public SplitBrainProtectionService getSplitBrainProtectionService() {
        return this.instance.getSplitBrainProtectionService();
    }

    @Override
    @Nonnull
    public ClientService getClientService() {
        return this.instance.getClientService();
    }

    @Override
    @Nonnull
    public LoggingService getLoggingService() {
        return this.instance.getLoggingService();
    }

    @Override
    @Nonnull
    public LifecycleService getLifecycleService() {
        return this.instance.getLifecycleService();
    }

    @Override
    @Nonnull
    public <T extends DistributedObject> T getDistributedObject(@Nonnull String serviceName, @Nonnull String name) {
        return this.instance.getDistributedObject(serviceName, name);
    }

    @Override
    public UUID addDistributedObjectListener(@Nonnull DistributedObjectListener distributedObjectListener) {
        return this.instance.addDistributedObjectListener(distributedObjectListener);
    }

    @Override
    public boolean removeDistributedObjectListener(@Nonnull UUID registrationId) {
        return this.instance.removeDistributedObjectListener(registrationId);
    }

    @Override
    @Nonnull
    public ConcurrentMap<String, Object> getUserContext() {
        return this.instance.getUserContext();
    }

    @Override
    @Nonnull
    public HazelcastXAResource getXAResource() {
        return this.instance.getXAResource();
    }

    @Override
    @Nonnull
    public CardinalityEstimator getCardinalityEstimator(@Nonnull String name) {
        return this.instance.getCardinalityEstimator(name);
    }

    @Override
    @Nonnull
    public PNCounter getPNCounter(@Nonnull String name) {
        return this.instance.getPNCounter(name);
    }

    @Override
    @Nonnull
    public IScheduledExecutorService getScheduledExecutorService(@Nonnull String name) {
        return this.instance.getScheduledExecutorService(name);
    }

    @Override
    @Nonnull
    public CPSubsystem getCPSubsystem() {
        return this.instance.getCPSubsystem();
    }

    @Override
    @Nonnull
    public SqlService getSql() {
        return this.instance.getSql();
    }

    @Override
    @Nonnull
    public BootstrappedJetProxy getJet() {
        return this.jetProxy;
    }

    @Override
    public void shutdown() {
        if (this.shutDownAllowed) {
            this.getLifecycleService().shutdown();
        } else {
            LOGGER.severe("Shutdown of BootstrappedInstanceProxy is not allowed");
        }
    }
}

