/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.cp.internal.datastructures.atomicref;

import com.hazelcast.cp.CPGroupId;
import com.hazelcast.cp.IAtomicReference;
import com.hazelcast.cp.internal.RaftGroupId;
import com.hazelcast.cp.internal.datastructures.atomicref.AtomicRef;
import com.hazelcast.cp.internal.datastructures.atomicref.AtomicRefSnapshot;
import com.hazelcast.cp.internal.datastructures.atomicref.proxy.AtomicRefProxy;
import com.hazelcast.cp.internal.datastructures.spi.atomic.RaftAtomicValueService;
import com.hazelcast.internal.metrics.DynamicMetricsProvider;
import com.hazelcast.internal.metrics.MetricDescriptor;
import com.hazelcast.internal.metrics.MetricsCollectionContext;
import com.hazelcast.internal.serialization.Data;
import com.hazelcast.spi.impl.NodeEngine;
import com.hazelcast.spi.impl.NodeEngineImpl;
import com.hazelcast.spi.properties.ClusterProperty;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public class AtomicRefService
extends RaftAtomicValueService<Data, AtomicRef, AtomicRefSnapshot>
implements DynamicMetricsProvider {
    public static final String SERVICE_NAME = "hz:raft:atomicRefService";

    public AtomicRefService(NodeEngine nodeEngine) {
        super(nodeEngine);
    }

    @Override
    public void init(NodeEngine nodeEngine, Properties properties) {
        super.init(nodeEngine, properties);
        if (nodeEngine.getProperties().getBoolean(ClusterProperty.METRICS_DATASTRUCTURES)) {
            ((NodeEngineImpl)nodeEngine).getMetricsRegistry().registerDynamicMetricsProvider(this);
        }
    }

    @Override
    protected AtomicRefSnapshot newSnapshot(Map<String, Data> values2, Set<String> destroyed) {
        return new AtomicRefSnapshot(values2, destroyed);
    }

    @Override
    protected AtomicRef newAtomicValue(CPGroupId groupId, String name, Data val) {
        return new AtomicRef(groupId, name, val);
    }

    @Override
    protected IAtomicReference newRaftAtomicProxy(NodeEngineImpl nodeEngine, RaftGroupId groupId, String proxyName, String objectNameForProxy) {
        return new AtomicRefProxy(nodeEngine, groupId, proxyName, objectNameForProxy);
    }

    @Override
    public void provideDynamicMetrics(MetricDescriptor descriptor, MetricsCollectionContext context) {
        MetricDescriptor root = descriptor.withPrefix("cp.atomicref");
        for (AtomicRef value : this.atomicValues.values()) {
            CPGroupId groupId = value.groupId();
            MetricDescriptor desc = root.copy().withDiscriminator("id", value.name() + "@" + groupId.getName()).withTag("name", value.name()).withTag("group", groupId.getName()).withMetric("dummy");
            context.collect(desc, 0L);
        }
    }
}

