/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.config;

import com.hazelcast.internal.util.Preconditions;
import java.util.Objects;

public class SqlConfig {
    public static final int DEFAULT_STATEMENT_TIMEOUT_MILLIS = 0;
    private long statementTimeoutMillis = 0L;
    private boolean catalogPersistenceEnabled;

    public long getStatementTimeoutMillis() {
        return this.statementTimeoutMillis;
    }

    public SqlConfig setStatementTimeoutMillis(long statementTimeoutMillis) {
        Preconditions.checkNotNegative(statementTimeoutMillis, "Timeout cannot be negative");
        this.statementTimeoutMillis = statementTimeoutMillis;
        return this;
    }

    public boolean isCatalogPersistenceEnabled() {
        return this.catalogPersistenceEnabled;
    }

    public SqlConfig setCatalogPersistenceEnabled(boolean catalogPersistenceEnabled) {
        this.catalogPersistenceEnabled = catalogPersistenceEnabled;
        return this;
    }

    public String toString() {
        return "SqlConfig{statementTimeoutMillis=" + this.statementTimeoutMillis + ", catalogPersistenceEnabled=" + this.catalogPersistenceEnabled + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SqlConfig sqlConfig = (SqlConfig)o;
        return this.statementTimeoutMillis == sqlConfig.statementTimeoutMillis && this.catalogPersistenceEnabled == sqlConfig.catalogPersistenceEnabled;
    }

    public int hashCode() {
        return Objects.hash(this.statementTimeoutMillis, this.catalogPersistenceEnabled);
    }
}

