/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.collection.impl.txnqueue;

import com.hazelcast.collection.impl.queue.QueueService;
import com.hazelcast.collection.impl.txnqueue.TransactionalQueueProxySupport;
import com.hazelcast.internal.serialization.Data;
import com.hazelcast.internal.util.Preconditions;
import com.hazelcast.spi.impl.NodeEngine;
import com.hazelcast.transaction.impl.Transaction;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;

public class TransactionalQueueProxy<E>
extends TransactionalQueueProxySupport<E> {
    public TransactionalQueueProxy(NodeEngine nodeEngine, QueueService service, String name, Transaction tx) {
        super(nodeEngine, service, name, tx);
    }

    @Override
    public boolean offer(@Nonnull E e) {
        try {
            return this.offer(e, 0L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException ignored) {
            Thread.currentThread().interrupt();
            return false;
        }
    }

    @Override
    public boolean offer(@Nonnull E e, long timeout2, @Nonnull TimeUnit unit) throws InterruptedException {
        Preconditions.checkNotNull(e, "Offered item should not be null.");
        Preconditions.checkNotNull(unit, "TimeUnit should not be null.");
        this.checkTransactionState();
        Data data = this.getNodeEngine().toData(e);
        return this.offerInternal(data, unit.toMillis(timeout2));
    }

    @Override
    @Nonnull
    public E take() throws InterruptedException {
        return this.poll(-1L, TimeUnit.MILLISECONDS);
    }

    @Override
    public E poll() {
        try {
            return this.poll(0L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException ignored) {
            Thread.currentThread().interrupt();
            return null;
        }
    }

    @Override
    public E poll(long timeout2, @Nonnull TimeUnit unit) throws InterruptedException {
        Preconditions.checkNotNull(unit, "TimeUnit should not be null.");
        this.checkTransactionState();
        Data data = this.pollInternal(unit.toMillis(timeout2));
        return (E)this.toObjectIfNeeded(data);
    }

    @Override
    public E peek() {
        try {
            return this.peek(0L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException ignored) {
            Thread.currentThread().interrupt();
            return null;
        }
    }

    @Override
    public E peek(long timeout2, TimeUnit unit) throws InterruptedException {
        Preconditions.checkNotNull(unit, "TimeUnit should not be null.");
        this.checkTransactionState();
        Data data = this.peekInternal(unit.toMillis(timeout2));
        return (E)this.toObjectIfNeeded(data);
    }

    @Override
    public String toString() {
        return "TransactionalQueue{name=" + this.name + '}';
    }
}

