/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.util;

import com.hazelcast.client.LoadBalancer;
import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.cluster.Cluster;
import com.hazelcast.cluster.InitialMembershipEvent;
import com.hazelcast.cluster.InitialMembershipListener;
import com.hazelcast.cluster.Member;
import com.hazelcast.cluster.MembershipEvent;
import java.util.ArrayList;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;

public abstract class AbstractLoadBalancer
implements LoadBalancer,
InitialMembershipListener {
    private static final Member[] EMPTY_MEMBERS = new Member[0];
    private final AtomicReference<Members> membersRef = new AtomicReference<Members>(new Members(EMPTY_MEMBERS, EMPTY_MEMBERS));
    private volatile Cluster clusterRef;

    @Override
    public final void init(Cluster cluster, ClientConfig config) {
        this.clusterRef = cluster;
        cluster.addMembershipListener(this);
    }

    private void setMembersRef() {
        Set<Member> memberSet = this.clusterRef.getMembers();
        Member[] members = memberSet.toArray(new Member[0]);
        Member[] dataMembers = AbstractLoadBalancer.dataMembers(members);
        this.membersRef.set(new Members(members, dataMembers));
    }

    protected Member[] getMembers() {
        return this.membersRef.get().getMembers();
    }

    protected Member[] getDataMembers() {
        return this.membersRef.get().getDataMembers();
    }

    @Override
    public final void init(InitialMembershipEvent event) {
        this.setMembersRef();
    }

    @Override
    public final void memberAdded(MembershipEvent membershipEvent) {
        this.setMembersRef();
    }

    @Override
    public final void memberRemoved(MembershipEvent membershipEvent) {
        this.setMembersRef();
    }

    private static Member[] dataMembers(Member[] members) {
        ArrayList<Member> dataMembers = new ArrayList<Member>(members.length);
        for (Member member : members) {
            if (member.isLiteMember()) continue;
            dataMembers.add(member);
        }
        if (dataMembers.isEmpty()) {
            return EMPTY_MEMBERS;
        }
        return dataMembers.toArray(new Member[0]);
    }

    private static final class Members {
        private final Member[] members;
        private final Member[] dataMembers;

        private Members(Member[] members, Member[] dataMembers) {
            this.members = members;
            this.dataMembers = dataMembers;
        }

        private Member[] getMembers() {
            return this.members;
        }

        private Member[] getDataMembers() {
            return this.dataMembers;
        }
    }
}

