/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.proxy;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.QueueAddAllCodec;
import com.hazelcast.client.impl.protocol.codec.QueueAddListenerCodec;
import com.hazelcast.client.impl.protocol.codec.QueueClearCodec;
import com.hazelcast.client.impl.protocol.codec.QueueCompareAndRemoveAllCodec;
import com.hazelcast.client.impl.protocol.codec.QueueCompareAndRetainAllCodec;
import com.hazelcast.client.impl.protocol.codec.QueueContainsAllCodec;
import com.hazelcast.client.impl.protocol.codec.QueueContainsCodec;
import com.hazelcast.client.impl.protocol.codec.QueueDrainToCodec;
import com.hazelcast.client.impl.protocol.codec.QueueDrainToMaxSizeCodec;
import com.hazelcast.client.impl.protocol.codec.QueueIsEmptyCodec;
import com.hazelcast.client.impl.protocol.codec.QueueIteratorCodec;
import com.hazelcast.client.impl.protocol.codec.QueueOfferCodec;
import com.hazelcast.client.impl.protocol.codec.QueuePeekCodec;
import com.hazelcast.client.impl.protocol.codec.QueuePollCodec;
import com.hazelcast.client.impl.protocol.codec.QueuePutCodec;
import com.hazelcast.client.impl.protocol.codec.QueueRemainingCapacityCodec;
import com.hazelcast.client.impl.protocol.codec.QueueRemoveCodec;
import com.hazelcast.client.impl.protocol.codec.QueueRemoveListenerCodec;
import com.hazelcast.client.impl.protocol.codec.QueueSizeCodec;
import com.hazelcast.client.impl.protocol.codec.QueueTakeCodec;
import com.hazelcast.client.impl.proxy.PartitionSpecificClientProxy;
import com.hazelcast.client.impl.spi.ClientContext;
import com.hazelcast.client.impl.spi.EventHandler;
import com.hazelcast.client.impl.spi.impl.ListenerMessageCodec;
import com.hazelcast.cluster.Member;
import com.hazelcast.collection.IQueue;
import com.hazelcast.collection.ItemListener;
import com.hazelcast.collection.LocalQueueStats;
import com.hazelcast.collection.impl.common.DataAwareItemEvent;
import com.hazelcast.collection.impl.queue.QueueIterator;
import com.hazelcast.core.ItemEventType;
import com.hazelcast.internal.serialization.Data;
import com.hazelcast.internal.util.CollectionUtil;
import com.hazelcast.internal.util.Preconditions;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;

public final class ClientQueueProxy<E>
extends PartitionSpecificClientProxy
implements IQueue<E> {
    public ClientQueueProxy(String serviceName, String name, ClientContext context) {
        super(serviceName, name, context);
    }

    @Override
    @Nonnull
    public UUID addItemListener(@Nonnull ItemListener<E> listener, boolean includeValue) {
        Preconditions.checkNotNull(listener, "Null listener is not allowed!");
        ItemEventHandler eventHandler = new ItemEventHandler(includeValue, listener);
        return this.registerListener(this.createItemListenerCodec(includeValue), eventHandler);
    }

    private ListenerMessageCodec createItemListenerCodec(final boolean includeValue) {
        return new ListenerMessageCodec(){

            @Override
            public ClientMessage encodeAddRequest(boolean localOnly) {
                return QueueAddListenerCodec.encodeRequest(ClientQueueProxy.this.name, includeValue, localOnly);
            }

            @Override
            public UUID decodeAddResponse(ClientMessage clientMessage) {
                return QueueAddListenerCodec.decodeResponse(clientMessage);
            }

            @Override
            public ClientMessage encodeRemoveRequest(UUID realRegistrationId) {
                return QueueRemoveListenerCodec.encodeRequest(ClientQueueProxy.this.name, realRegistrationId);
            }

            @Override
            public boolean decodeRemoveResponse(ClientMessage clientMessage) {
                return QueueRemoveListenerCodec.decodeResponse(clientMessage);
            }
        };
    }

    @Override
    public boolean removeItemListener(@Nonnull UUID registrationId) {
        Preconditions.checkNotNull(registrationId, "Null registrationId is not allowed!");
        return this.deregisterListener(registrationId);
    }

    @Override
    public LocalQueueStats getLocalQueueStats() {
        throw new UnsupportedOperationException("Locality is ambiguous for client!");
    }

    @Override
    public boolean add(@Nonnull E e) {
        if (this.offer(e)) {
            return true;
        }
        throw new IllegalStateException("Queue is full!");
    }

    @Override
    public boolean offer(@Nonnull E e) {
        try {
            return this.offer(e, 0L, TimeUnit.SECONDS);
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
            return false;
        }
    }

    @Override
    public void put(@Nonnull E e) throws InterruptedException {
        Preconditions.checkNotNull(e, "Null item is not allowed!");
        Data data = this.toData(e);
        ClientMessage request = QueuePutCodec.encodeRequest(this.name, data);
        this.invokeOnPartitionInterruptibly(request);
    }

    @Override
    public boolean offer(@Nonnull E e, long timeout2, @Nonnull TimeUnit unit) throws InterruptedException {
        Preconditions.checkNotNull(e, "Null item is not allowed!");
        Preconditions.checkNotNull(unit, "Null timeUnit is not allowed!");
        Data data = this.toData(e);
        ClientMessage request = QueueOfferCodec.encodeRequest(this.name, data, unit.toMillis(timeout2));
        ClientMessage response = (ClientMessage)this.invokeOnPartitionInterruptibly(request);
        return QueueOfferCodec.decodeResponse(response);
    }

    @Override
    @Nonnull
    public E take() throws InterruptedException {
        ClientMessage request = QueueTakeCodec.encodeRequest(this.name);
        ClientMessage response = (ClientMessage)this.invokeOnPartitionInterruptibly(request);
        return (E)this.toObject(QueueTakeCodec.decodeResponse(response));
    }

    @Override
    public E poll(long timeout2, @Nonnull TimeUnit unit) throws InterruptedException {
        Preconditions.checkNotNull(unit, "Null timeUnit is not allowed!");
        ClientMessage request = QueuePollCodec.encodeRequest(this.name, unit.toMillis(timeout2));
        ClientMessage response = (ClientMessage)this.invokeOnPartitionInterruptibly(request);
        return (E)this.toObject(QueuePollCodec.decodeResponse(response));
    }

    @Override
    public int remainingCapacity() {
        ClientMessage request = QueueRemainingCapacityCodec.encodeRequest(this.name);
        ClientMessage response = this.invokeOnPartition(request);
        return QueueRemainingCapacityCodec.decodeResponse(response);
    }

    @Override
    public boolean remove(@Nonnull Object o) {
        Preconditions.checkNotNull(o, "Null item is not allowed!");
        Data data = this.toData(o);
        ClientMessage request = QueueRemoveCodec.encodeRequest(this.name, data);
        ClientMessage response = this.invokeOnPartition(request);
        return QueueRemoveCodec.decodeResponse(response);
    }

    @Override
    public boolean contains(@Nonnull Object o) {
        Preconditions.checkNotNull(o, "Null item is not allowed!");
        Data data = this.toData(o);
        ClientMessage request = QueueContainsCodec.encodeRequest(this.name, data);
        ClientMessage response = this.invokeOnPartition(request);
        return QueueContainsCodec.decodeResponse(response);
    }

    @Override
    public int drainTo(@Nonnull Collection<? super E> objects) {
        Preconditions.checkNotNull(objects, "Null objects parameter is not allowed!");
        ClientMessage request = QueueDrainToCodec.encodeRequest(this.name);
        ClientMessage response = this.invokeOnPartition(request);
        List<Data> resultCollection = QueueDrainToCodec.decodeResponse(response);
        for (Data data : resultCollection) {
            Object e = this.toObject(data);
            objects.add(e);
        }
        return resultCollection.size();
    }

    @Override
    public int drainTo(@Nonnull Collection<? super E> c, int maxElements) {
        Preconditions.checkNotNull(c, "Null collection parameter is not allowed!");
        ClientMessage request = QueueDrainToMaxSizeCodec.encodeRequest(this.name, maxElements);
        ClientMessage response = this.invokeOnPartition(request);
        List<Data> resultCollection = QueueDrainToMaxSizeCodec.decodeResponse(response);
        for (Data data : resultCollection) {
            Object e = this.toObject(data);
            c.add(e);
        }
        return resultCollection.size();
    }

    @Override
    public E remove() {
        E res = this.poll();
        if (res == null) {
            throw new NoSuchElementException("Queue is empty!");
        }
        return res;
    }

    @Override
    public E poll() {
        try {
            return this.poll(0L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return null;
        }
    }

    @Override
    public E element() {
        E res = this.peek();
        if (res == null) {
            throw new NoSuchElementException("Queue is empty!");
        }
        return res;
    }

    @Override
    public E peek() {
        ClientMessage request = QueuePeekCodec.encodeRequest(this.name);
        ClientMessage response = this.invokeOnPartition(request);
        return (E)this.toObject(QueuePeekCodec.decodeResponse(response));
    }

    @Override
    public int size() {
        ClientMessage request = QueueSizeCodec.encodeRequest(this.name);
        ClientMessage response = this.invokeOnPartition(request);
        return QueueSizeCodec.decodeResponse(response);
    }

    @Override
    public boolean isEmpty() {
        ClientMessage request = QueueIsEmptyCodec.encodeRequest(this.name);
        ClientMessage response = this.invokeOnPartition(request);
        return QueueIsEmptyCodec.decodeResponse(response);
    }

    @Override
    public Iterator<E> iterator() {
        ClientMessage request = QueueIteratorCodec.encodeRequest(this.name);
        ClientMessage response = this.invokeOnPartition(request);
        List<Data> resultCollection = QueueIteratorCodec.decodeResponse(response);
        return new QueueIterator(resultCollection.iterator(), this.getSerializationService(), false);
    }

    @Override
    public Object[] toArray() {
        ClientMessage request = QueueIteratorCodec.encodeRequest(this.name);
        ClientMessage response = this.invokeOnPartition(request);
        List<Data> resultCollection = QueueIteratorCodec.decodeResponse(response);
        int i = 0;
        Object[] array = new Object[resultCollection.size()];
        for (Data data : resultCollection) {
            array[i++] = this.toObject(data);
        }
        return array;
    }

    @Override
    @Nonnull
    public <T> T[] toArray(@Nonnull T[] ts) {
        Preconditions.checkNotNull(ts, "Null array parameter is not allowed!");
        ClientMessage request = QueueIteratorCodec.encodeRequest(this.name);
        ClientMessage response = this.invokeOnPartition(request);
        List<Data> resultCollection = QueueIteratorCodec.decodeResponse(response);
        int size = resultCollection.size();
        if (ts.length < size) {
            ts = (Object[])Array.newInstance(ts.getClass().getComponentType(), size);
        }
        int i = 0;
        for (Data data : resultCollection) {
            ts[i++] = this.toObject(data);
        }
        return ts;
    }

    @Override
    public boolean containsAll(@Nonnull Collection<?> c) {
        Preconditions.checkNotNull(c, "Null collection is not allowed!");
        Collection<Data> dataCollection = CollectionUtil.objectToDataCollection(c, this.getSerializationService());
        ClientMessage request = QueueContainsAllCodec.encodeRequest(this.name, dataCollection);
        ClientMessage response = this.invokeOnPartition(request);
        return QueueContainsAllCodec.decodeResponse(response);
    }

    @Override
    public boolean addAll(@Nonnull Collection<? extends E> c) {
        Preconditions.checkNotNull(c, "Null collection is not allowed!");
        Collection<Data> dataCollection = CollectionUtil.objectToDataCollection(c, this.getSerializationService());
        ClientMessage request = QueueAddAllCodec.encodeRequest(this.name, dataCollection);
        ClientMessage response = this.invokeOnPartition(request);
        return QueueAddAllCodec.decodeResponse(response);
    }

    @Override
    public boolean removeAll(@Nonnull Collection<?> c) {
        Preconditions.checkNotNull(c, "Null collection is not allowed!");
        Collection<Data> dataCollection = CollectionUtil.objectToDataCollection(c, this.getSerializationService());
        ClientMessage request = QueueCompareAndRemoveAllCodec.encodeRequest(this.name, dataCollection);
        ClientMessage response = this.invokeOnPartition(request);
        return QueueCompareAndRemoveAllCodec.decodeResponse(response);
    }

    @Override
    public boolean retainAll(@Nonnull Collection<?> c) {
        Preconditions.checkNotNull(c, "Null collection is not allowed!");
        Collection<Data> dataCollection = CollectionUtil.objectToDataCollection(c, this.getSerializationService());
        ClientMessage request = QueueCompareAndRetainAllCodec.encodeRequest(this.name, dataCollection);
        ClientMessage response = this.invokeOnPartition(request);
        return QueueCompareAndRetainAllCodec.decodeResponse(response);
    }

    @Override
    public void clear() {
        ClientMessage request = QueueClearCodec.encodeRequest(this.name);
        this.invokeOnPartition(request);
    }

    public String toString() {
        return "IQueue{name='" + this.name + '\'' + '}';
    }

    private class ItemEventHandler
    extends QueueAddListenerCodec.AbstractEventHandler
    implements EventHandler<ClientMessage> {
        private final boolean includeValue;
        private final ItemListener<E> listener;

        ItemEventHandler(boolean includeValue, ItemListener<E> listener) {
            this.includeValue = includeValue;
            this.listener = listener;
        }

        @Override
        public void handleItemEvent(Data dataItem, UUID uuid, int eventType) {
            Member member = ClientQueueProxy.this.getContext().getClusterService().getMember(uuid);
            DataAwareItemEvent itemEvent = new DataAwareItemEvent(ClientQueueProxy.this.name, ItemEventType.getByType(eventType), dataItem, member, ClientQueueProxy.this.getSerializationService());
            if (eventType == ItemEventType.ADDED.getType()) {
                this.listener.itemAdded(itemEvent);
            } else {
                this.listener.itemRemoved(itemEvent);
            }
        }
    }
}

