/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.protocol.codec.custom;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.builtin.CodecUtil;
import com.hazelcast.client.impl.protocol.codec.builtin.FixedSizeTypesCodec;
import com.hazelcast.sql.impl.QueryId;

public final class SqlQueryIdCodec {
    private static final int MEMBER_ID_HIGH_FIELD_OFFSET = 0;
    private static final int MEMBER_ID_LOW_FIELD_OFFSET = 8;
    private static final int LOCAL_ID_HIGH_FIELD_OFFSET = 16;
    private static final int LOCAL_ID_LOW_FIELD_OFFSET = 24;
    private static final int INITIAL_FRAME_SIZE = 32;

    private SqlQueryIdCodec() {
    }

    public static void encode(ClientMessage clientMessage, QueryId sqlQueryId) {
        clientMessage.add(ClientMessage.BEGIN_FRAME.copy());
        ClientMessage.Frame initialFrame = new ClientMessage.Frame(new byte[32]);
        FixedSizeTypesCodec.encodeLong(initialFrame.content, 0, sqlQueryId.getMemberIdHigh());
        FixedSizeTypesCodec.encodeLong(initialFrame.content, 8, sqlQueryId.getMemberIdLow());
        FixedSizeTypesCodec.encodeLong(initialFrame.content, 16, sqlQueryId.getLocalIdHigh());
        FixedSizeTypesCodec.encodeLong(initialFrame.content, 24, sqlQueryId.getLocalIdLow());
        clientMessage.add(initialFrame);
        clientMessage.add(ClientMessage.END_FRAME.copy());
    }

    public static QueryId decode(ClientMessage.ForwardFrameIterator iterator2) {
        iterator2.next();
        ClientMessage.Frame initialFrame = iterator2.next();
        long memberIdHigh = FixedSizeTypesCodec.decodeLong(initialFrame.content, 0);
        long memberIdLow = FixedSizeTypesCodec.decodeLong(initialFrame.content, 8);
        long localIdHigh = FixedSizeTypesCodec.decodeLong(initialFrame.content, 16);
        long localIdLow = FixedSizeTypesCodec.decodeLong(initialFrame.content, 24);
        CodecUtil.fastForwardToEndFrame(iterator2);
        return new QueryId(memberIdHigh, memberIdLow, localIdHigh, localIdLow);
    }
}

