/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.protocol.codec.builtin;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.builtin.FixedSizeTypesCodec;

public final class LongArrayCodec {
    private LongArrayCodec() {
    }

    public static void encode(ClientMessage clientMessage, long[] array) {
        int itemCount = array.length;
        ClientMessage.Frame frame = new ClientMessage.Frame(new byte[itemCount * 8]);
        for (int i = 0; i < itemCount; ++i) {
            FixedSizeTypesCodec.encodeLong(frame.content, i * 8, array[i]);
        }
        clientMessage.add(frame);
    }

    public static long[] decode(ClientMessage.Frame frame) {
        int itemCount = frame.content.length / 8;
        long[] result = new long[itemCount];
        for (int i = 0; i < itemCount; ++i) {
            result[i] = FixedSizeTypesCodec.decodeLong(frame.content, i * 8);
        }
        return result;
    }

    public static long[] decode(ClientMessage.ForwardFrameIterator iterator2) {
        return LongArrayCodec.decode(iterator2.next());
    }
}

