/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.protocol.codec.builtin;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.builtin.FixedSizeTypesCodec;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;

public final class ListUUIDCodec {
    private ListUUIDCodec() {
    }

    public static void encode(ClientMessage clientMessage, Collection<UUID> collection) {
        int itemCount = collection.size();
        ClientMessage.Frame frame = new ClientMessage.Frame(new byte[itemCount * 17]);
        Iterator<UUID> iterator2 = collection.iterator();
        for (int i = 0; i < itemCount; ++i) {
            FixedSizeTypesCodec.encodeUUID(frame.content, i * 17, iterator2.next());
        }
        clientMessage.add(frame);
    }

    public static List<UUID> decode(ClientMessage.ForwardFrameIterator iterator2) {
        return ListUUIDCodec.decode(iterator2.next());
    }

    public static List<UUID> decode(ClientMessage.Frame frame) {
        int itemCount = frame.content.length / 17;
        ArrayList<UUID> result = new ArrayList<UUID>(itemCount);
        for (int i = 0; i < itemCount; ++i) {
            result.add(FixedSizeTypesCodec.decodeUUID(frame.content, i * 17));
        }
        return result;
    }
}

