/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.protocol.codec.builtin;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.builtin.CodecUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Function;

public final class ListMultiFrameCodec {
    private ListMultiFrameCodec() {
    }

    public static <T> void encode(ClientMessage clientMessage, Iterable<T> collection, BiConsumer<ClientMessage, T> encodeFunction) {
        clientMessage.add(ClientMessage.BEGIN_FRAME.copy());
        for (T item : collection) {
            encodeFunction.accept(clientMessage, (ClientMessage)item);
        }
        clientMessage.add(ClientMessage.END_FRAME.copy());
    }

    public static <T> void encodeContainsNullable(ClientMessage clientMessage, Iterable<T> collection, BiConsumer<ClientMessage, T> encodeFunction) {
        clientMessage.add(ClientMessage.BEGIN_FRAME.copy());
        for (T item : collection) {
            if (item == null) {
                clientMessage.add(ClientMessage.NULL_FRAME.copy());
                continue;
            }
            encodeFunction.accept(clientMessage, (ClientMessage)item);
        }
        clientMessage.add(ClientMessage.END_FRAME.copy());
    }

    public static <T> void encodeNullable(ClientMessage clientMessage, Collection<T> collection, BiConsumer<ClientMessage, T> encodeFunction) {
        if (collection == null) {
            clientMessage.add(ClientMessage.NULL_FRAME.copy());
        } else {
            ListMultiFrameCodec.encode(clientMessage, collection, encodeFunction);
        }
    }

    public static <T> List<T> decode(ClientMessage.ForwardFrameIterator iterator2, Function<ClientMessage.ForwardFrameIterator, T> decodeFunction) {
        ArrayList<T> result = new ArrayList<T>();
        iterator2.next();
        while (!CodecUtil.nextFrameIsDataStructureEndFrame(iterator2)) {
            result.add(decodeFunction.apply(iterator2));
        }
        iterator2.next();
        return result;
    }

    public static <T> List<T> decodeContainsNullable(ClientMessage.ForwardFrameIterator iterator2, Function<ClientMessage.ForwardFrameIterator, T> decodeFunction) {
        ArrayList<Object> result = new ArrayList<Object>();
        iterator2.next();
        while (!CodecUtil.nextFrameIsDataStructureEndFrame(iterator2)) {
            result.add(CodecUtil.nextFrameIsNullEndFrame(iterator2) ? null : (Object)decodeFunction.apply(iterator2));
        }
        iterator2.next();
        return result;
    }

    public static <T> List<T> decodeNullable(ClientMessage.ForwardFrameIterator iterator2, Function<ClientMessage.ForwardFrameIterator, T> decodeFunction) {
        return CodecUtil.nextFrameIsNullEndFrame(iterator2) ? null : ListMultiFrameCodec.decode(iterator2, decodeFunction);
    }
}

