/*
 * Decompiled with CFR 0.152.
 */
package org.xnio.nio;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.FileChannel;
import java.nio.channels.Pipe;
import java.nio.channels.SelectionKey;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import org.xnio.Xnio;
import org.xnio.XnioIoThread;
import org.xnio.XnioWorker;
import org.xnio.channels.StreamSourceChannel;
import org.xnio.channels.WriteTimeoutException;
import org.xnio.conduits.Conduits;
import org.xnio.conduits.StreamSinkConduit;
import org.xnio.conduits.WriteReadyHandler;
import org.xnio.nio.Log;
import org.xnio.nio.NioHandle;
import org.xnio.nio.NioPipeStreamConnection;
import org.xnio.nio.NioXnio;
import org.xnio.nio.SelectorUtils;
import org.xnio.nio.WorkerThread;

final class NioPipeSinkConduit
extends NioHandle
implements StreamSinkConduit {
    private final Pipe.SinkChannel sinkChannel;
    private final NioPipeStreamConnection connection;
    private WriteReadyHandler writeReadyHandler;
    private volatile int writeTimeout;
    private long lastWrite;
    private static final AtomicIntegerFieldUpdater<NioPipeSinkConduit> writeTimeoutUpdater = AtomicIntegerFieldUpdater.newUpdater(NioPipeSinkConduit.class, "writeTimeout");

    NioPipeSinkConduit(WorkerThread workerThread, SelectionKey selectionKey, NioPipeStreamConnection connection) {
        super(workerThread, selectionKey);
        this.connection = connection;
        this.sinkChannel = (Pipe.SinkChannel)selectionKey.channel();
    }

    @Override
    void handleReady(int ops) {
        try {
            this.writeReadyHandler.writeReady();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    public XnioWorker getWorker() {
        return this.getWorkerThread().getWorker();
    }

    @Override
    void forceTermination() {
        WriteReadyHandler write = this.writeReadyHandler;
        if (write != null) {
            write.forceTermination();
        }
    }

    @Override
    void terminated() {
        WriteReadyHandler write = this.writeReadyHandler;
        if (write != null) {
            write.terminated();
        }
    }

    int getAndSetWriteTimeout(int newVal) {
        return writeTimeoutUpdater.getAndSet(this, newVal);
    }

    int getWriteTimeout() {
        return this.writeTimeout;
    }

    private void checkWriteTimeout(boolean xfer) throws WriteTimeoutException {
        int timeout2 = this.writeTimeout;
        if (timeout2 > 0) {
            if (xfer) {
                this.lastWrite = System.nanoTime();
            } else {
                long lastWrite = this.lastWrite;
                if (lastWrite > 0L && (System.nanoTime() - lastWrite) / 1000000L > (long)timeout2) {
                    throw Log.log.writeTimeout();
                }
            }
        }
    }

    @Override
    public final long transferFrom(FileChannel src, long position, long count) throws IOException {
        long res = src.transferTo(position, count, this.sinkChannel);
        this.checkWriteTimeout(res > 0L);
        return res;
    }

    @Override
    public long transferFrom(StreamSourceChannel source2, long count, ByteBuffer throughBuffer) throws IOException {
        return Conduits.transfer(source2, count, throughBuffer, this);
    }

    @Override
    public int write(ByteBuffer src) throws IOException {
        int res = this.sinkChannel.write(src);
        this.checkWriteTimeout(res > 0);
        return res;
    }

    @Override
    public long write(ByteBuffer[] srcs, int offset, int length) throws IOException {
        if (length == 1) {
            return this.write(srcs[offset]);
        }
        long res = this.sinkChannel.write(srcs, offset, length);
        this.checkWriteTimeout(res > 0L);
        return res;
    }

    @Override
    public int writeFinal(ByteBuffer src) throws IOException {
        return Conduits.writeFinalBasic(this, src);
    }

    @Override
    public long writeFinal(ByteBuffer[] srcs, int offset, int length) throws IOException {
        return Conduits.writeFinalBasic(this, srcs, offset, length);
    }

    @Override
    public boolean flush() throws IOException {
        return true;
    }

    @Override
    public void terminateWrites() throws IOException {
        if (this.connection.writeClosed()) {
            try {
                this.sinkChannel.close();
            }
            catch (ClosedChannelException closedChannelException) {
            }
            finally {
                this.writeTerminated();
            }
        }
    }

    @Override
    public void truncateWrites() throws IOException {
        this.terminateWrites();
    }

    void writeTerminated() {
        WriteReadyHandler writeReadyHandler = this.writeReadyHandler;
        if (writeReadyHandler != null) {
            try {
                writeReadyHandler.terminated();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    @Override
    public boolean isWriteShutdown() {
        return this.connection.isWriteShutdown();
    }

    @Override
    public void resumeWrites() {
        this.resume(4);
    }

    @Override
    public void suspendWrites() {
        this.suspend(4);
    }

    @Override
    public void wakeupWrites() {
        this.wakeup(4);
    }

    @Override
    public boolean isWriteResumed() {
        return this.isResumed(4);
    }

    @Override
    public void awaitWritable() throws IOException {
        Xnio.checkBlockingAllowed();
        SelectorUtils.await((NioXnio)this.getWorker().getXnio(), this.sinkChannel, 4);
    }

    @Override
    public void awaitWritable(long time, TimeUnit timeUnit) throws IOException {
        Xnio.checkBlockingAllowed();
        SelectorUtils.await((NioXnio)this.getWorker().getXnio(), this.sinkChannel, 4, time, timeUnit);
    }

    @Override
    public XnioIoThread getWriteThread() {
        return this.getWorkerThread();
    }

    @Override
    public void setWriteReadyHandler(WriteReadyHandler handler) {
        this.writeReadyHandler = handler;
    }
}

