/*
 * Decompiled with CFR 0.152.
 */
package org.xnio.channels;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.FileChannel;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import org.xnio.Bits;
import org.xnio.ChannelListener;
import org.xnio.ChannelListeners;
import org.xnio.Option;
import org.xnio.XnioExecutor;
import org.xnio.XnioIoThread;
import org.xnio.XnioWorker;
import org.xnio.channels.Channels;
import org.xnio.channels.CloseListenerSettable;
import org.xnio.channels.ConcurrentStreamChannelAccessException;
import org.xnio.channels.StreamSinkChannel;
import org.xnio.channels.StreamSourceChannel;
import org.xnio.channels.WriteListenerSettable;

public final class NullStreamSinkChannel
implements StreamSinkChannel,
WriteListenerSettable<NullStreamSinkChannel>,
CloseListenerSettable<NullStreamSinkChannel> {
    private final XnioIoThread thread;
    private volatile int state;
    private ChannelListener<? super NullStreamSinkChannel> writeListener;
    private ChannelListener<? super NullStreamSinkChannel> closeListener;
    private static final AtomicIntegerFieldUpdater<NullStreamSinkChannel> stateUpdater = AtomicIntegerFieldUpdater.newUpdater(NullStreamSinkChannel.class, "state");
    private static final int FLAG_ENTERED = 1;
    private static final int FLAG_CLOSED = 2;
    private static final int FLAG_RESUMED = 4;

    public NullStreamSinkChannel(XnioIoThread thread2) {
        this.thread = thread2;
    }

    @Override
    public XnioWorker getWorker() {
        return this.thread.getWorker();
    }

    @Override
    public XnioIoThread getIoThread() {
        return this.thread;
    }

    @Override
    @Deprecated
    public XnioExecutor getWriteThread() {
        return this.thread;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long transferFrom(FileChannel src, long position, long count) throws IOException {
        int val = this.enterWrite();
        try {
            long l = Math.min(src.size() - position, count);
            return l;
        }
        finally {
            this.exitWrite(val);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long transferFrom(StreamSourceChannel source2, long count, ByteBuffer throughBuffer) throws IOException {
        int val = this.enterWrite();
        try {
            long l = Channels.drain(source2, count);
            return l;
        }
        finally {
            throughBuffer.limit(0);
            this.exitWrite(val);
        }
    }

    @Override
    public void setWriteListener(ChannelListener<? super NullStreamSinkChannel> writeListener) {
        this.writeListener = writeListener;
    }

    @Override
    public ChannelListener<? super NullStreamSinkChannel> getWriteListener() {
        return this.writeListener;
    }

    @Override
    public void setCloseListener(ChannelListener<? super NullStreamSinkChannel> closeListener) {
        this.closeListener = closeListener;
    }

    @Override
    public ChannelListener<? super NullStreamSinkChannel> getCloseListener() {
        return this.closeListener;
    }

    public ChannelListener.Setter<NullStreamSinkChannel> getWriteSetter() {
        return new WriteListenerSettable.Setter<NullStreamSinkChannel>(this);
    }

    public ChannelListener.Setter<NullStreamSinkChannel> getCloseSetter() {
        return new CloseListenerSettable.Setter<NullStreamSinkChannel>(this);
    }

    @Override
    public int writeFinal(ByteBuffer src) throws IOException {
        return Channels.writeFinalBasic(this, src);
    }

    @Override
    public long writeFinal(ByteBuffer[] srcs, int offset, int length) throws IOException {
        return Channels.writeFinalBasic(this, srcs, offset, length);
    }

    @Override
    public long writeFinal(ByteBuffer[] srcs) throws IOException {
        return Channels.writeFinalBasic(this, srcs, 0, srcs.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int write(ByteBuffer src) throws IOException {
        int val = this.enterWrite();
        try {
            int n = src.remaining();
            return n;
        }
        finally {
            src.position(src.limit());
            this.exitWrite(val);
        }
    }

    @Override
    public long write(ByteBuffer[] srcs) throws IOException {
        return this.write(srcs, 0, srcs.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long write(ByteBuffer[] srcs, int offset, int length) throws IOException {
        if (length == 0) {
            return 0L;
        }
        int val = this.enterWrite();
        try {
            long t2 = 0L;
            for (int i = 0; i < length; ++i) {
                ByteBuffer src = srcs[i];
                t2 += (long)src.remaining();
                src.position(src.limit());
            }
            long l = t2;
            return l;
        }
        finally {
            this.exitWrite(val);
        }
    }

    @Override
    public void suspendWrites() {
        int newVal;
        int oldVal;
        do {
            if (!Bits.allAreClear(oldVal = this.state, 4) && !Bits.allAreSet(oldVal, 2)) continue;
            return;
        } while (!stateUpdater.compareAndSet(this, oldVal, newVal = oldVal & 0xFFFFFFFB));
    }

    @Override
    public void resumeWrites() {
        int newVal;
        int oldVal;
        do {
            if (!Bits.anyAreSet(oldVal = this.state, 6)) continue;
            return;
        } while (!stateUpdater.compareAndSet(this, oldVal, newVal = oldVal | 4));
        this.thread.execute(ChannelListeners.getChannelListenerTask(this, this.writeListener));
    }

    @Override
    public void wakeupWrites() {
        this.resumeWrites();
    }

    @Override
    public boolean isWriteResumed() {
        int state = this.state;
        return Bits.allAreSet(state, 4) && Bits.allAreClear(state, 2);
    }

    @Override
    public void shutdownWrites() throws IOException {
        int newVal;
        int oldVal;
        do {
            if (!Bits.allAreSet(oldVal = this.state, 2)) continue;
            return;
        } while (!stateUpdater.compareAndSet(this, oldVal, newVal = oldVal | 2));
        this.writeListener = null;
        ChannelListeners.invokeChannelListener(this, this.closeListener);
    }

    @Override
    public void awaitWritable() throws IOException {
    }

    @Override
    public void awaitWritable(long time, TimeUnit timeUnit) throws IOException {
    }

    @Override
    public boolean flush() throws IOException {
        return true;
    }

    @Override
    public boolean isOpen() {
        return Bits.allAreClear(this.state, 2);
    }

    @Override
    public void close() throws IOException {
        this.shutdownWrites();
    }

    @Override
    public boolean supportsOption(Option<?> option) {
        return false;
    }

    @Override
    public <T> T getOption(Option<T> option) throws IOException {
        return null;
    }

    @Override
    public <T> T setOption(Option<T> option, T value) throws IllegalArgumentException, IOException {
        return null;
    }

    private int enterWrite() throws ClosedChannelException {
        int newVal;
        int oldVal;
        do {
            if (Bits.allAreSet(oldVal = this.state, 1)) {
                throw new ConcurrentStreamChannelAccessException();
            }
            if (!Bits.allAreSet(oldVal, 2)) continue;
            throw new ClosedChannelException();
        } while (!stateUpdater.compareAndSet(this, oldVal, newVal = oldVal | 1));
        return newVal;
    }

    private void exitWrite(int oldVal) {
        int newVal = oldVal & 0xFFFFFFFE;
        while (!stateUpdater.compareAndSet(this, oldVal, newVal)) {
            oldVal = this.state;
            newVal = oldVal & 0xFFFFFFFE;
        }
    }
}

