/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.admin.internals;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.OptionalLong;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.kafka.clients.admin.TransactionDescription;
import org.apache.kafka.clients.admin.TransactionState;
import org.apache.kafka.clients.admin.internals.AdminApiFuture;
import org.apache.kafka.clients.admin.internals.AdminApiHandler;
import org.apache.kafka.clients.admin.internals.AdminApiLookupStrategy;
import org.apache.kafka.clients.admin.internals.CoordinatorKey;
import org.apache.kafka.clients.admin.internals.CoordinatorStrategy;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.TransactionalIdAuthorizationException;
import org.apache.kafka.common.errors.TransactionalIdNotFoundException;
import org.apache.kafka.common.message.DescribeTransactionsRequestData;
import org.apache.kafka.common.message.DescribeTransactionsResponseData;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.requests.DescribeTransactionsRequest;
import org.apache.kafka.common.requests.DescribeTransactionsResponse;
import org.apache.kafka.common.requests.FindCoordinatorRequest;
import org.apache.kafka.common.utils.LogContext;
import org.slf4j.Logger;

public class DescribeTransactionsHandler
extends AdminApiHandler.Batched<CoordinatorKey, TransactionDescription> {
    private final Logger log;
    private final AdminApiLookupStrategy<CoordinatorKey> lookupStrategy;

    public DescribeTransactionsHandler(LogContext logContext) {
        this.log = logContext.logger(DescribeTransactionsHandler.class);
        this.lookupStrategy = new CoordinatorStrategy(FindCoordinatorRequest.CoordinatorType.TRANSACTION, logContext);
    }

    public static AdminApiFuture.SimpleAdminApiFuture<CoordinatorKey, TransactionDescription> newFuture(Collection<String> transactionalIds) {
        return AdminApiFuture.forKeys(DescribeTransactionsHandler.buildKeySet(transactionalIds));
    }

    private static Set<CoordinatorKey> buildKeySet(Collection<String> transactionalIds) {
        return transactionalIds.stream().map(CoordinatorKey::byTransactionalId).collect(Collectors.toSet());
    }

    @Override
    public String apiName() {
        return "describeTransactions";
    }

    @Override
    public AdminApiLookupStrategy<CoordinatorKey> lookupStrategy() {
        return this.lookupStrategy;
    }

    public DescribeTransactionsRequest.Builder buildBatchedRequest(int brokerId, Set<CoordinatorKey> keys2) {
        DescribeTransactionsRequestData request = new DescribeTransactionsRequestData();
        List<String> transactionalIds = keys2.stream().map(key -> {
            if (key.type != FindCoordinatorRequest.CoordinatorType.TRANSACTION) {
                throw new IllegalArgumentException("Invalid group coordinator key " + key + " when building `DescribeTransaction` request");
            }
            return key.idValue;
        }).collect(Collectors.toList());
        request.setTransactionalIds(transactionalIds);
        return new DescribeTransactionsRequest.Builder(request);
    }

    @Override
    public AdminApiHandler.ApiResult<CoordinatorKey, TransactionDescription> handleResponse(Node broker, Set<CoordinatorKey> keys2, AbstractResponse abstractResponse) {
        DescribeTransactionsResponse response = (DescribeTransactionsResponse)abstractResponse;
        HashMap<CoordinatorKey, TransactionDescription> completed = new HashMap<CoordinatorKey, TransactionDescription>();
        HashMap<CoordinatorKey, Throwable> failed = new HashMap<CoordinatorKey, Throwable>();
        ArrayList<CoordinatorKey> unmapped = new ArrayList<CoordinatorKey>();
        for (DescribeTransactionsResponseData.TransactionState transactionState : response.data().transactionStates()) {
            CoordinatorKey transactionalIdKey = CoordinatorKey.byTransactionalId(transactionState.transactionalId());
            if (!keys2.contains(transactionalIdKey)) {
                this.log.warn("Response included transactionalId `{}`, which was not requested", (Object)transactionState.transactionalId());
                continue;
            }
            Errors error = Errors.forCode(transactionState.errorCode());
            if (error != Errors.NONE) {
                this.handleError(transactionalIdKey, error, failed, unmapped);
                continue;
            }
            OptionalLong transactionStartTimeMs = transactionState.transactionStartTimeMs() < 0L ? OptionalLong.empty() : OptionalLong.of(transactionState.transactionStartTimeMs());
            completed.put(transactionalIdKey, new TransactionDescription(broker.id(), TransactionState.parse(transactionState.transactionState()), transactionState.producerId(), transactionState.producerEpoch(), transactionState.transactionTimeoutMs(), transactionStartTimeMs, this.collectTopicPartitions(transactionState)));
        }
        return new AdminApiHandler.ApiResult<CoordinatorKey, TransactionDescription>(completed, failed, unmapped);
    }

    private Set<TopicPartition> collectTopicPartitions(DescribeTransactionsResponseData.TransactionState transactionState) {
        HashSet<TopicPartition> res = new HashSet<TopicPartition>();
        for (DescribeTransactionsResponseData.TopicData topicData : transactionState.topics()) {
            String topic = topicData.topic();
            for (Integer partitionId : topicData.partitions()) {
                res.add(new TopicPartition(topic, partitionId));
            }
        }
        return res;
    }

    private void handleError(CoordinatorKey transactionalIdKey, Errors error, Map<CoordinatorKey, Throwable> failed, List<CoordinatorKey> unmapped) {
        switch (error) {
            case TRANSACTIONAL_ID_AUTHORIZATION_FAILED: {
                failed.put(transactionalIdKey, new TransactionalIdAuthorizationException("DescribeTransactions request for transactionalId `" + transactionalIdKey.idValue + "` failed due to authorization failure"));
                break;
            }
            case TRANSACTIONAL_ID_NOT_FOUND: {
                failed.put(transactionalIdKey, new TransactionalIdNotFoundException("DescribeTransactions request for transactionalId `" + transactionalIdKey.idValue + "` failed because the ID could not be found"));
                break;
            }
            case COORDINATOR_LOAD_IN_PROGRESS: {
                this.log.debug("DescribeTransactions request for transactionalId `{}` failed because the coordinator is still in the process of loading state. Will retry", (Object)transactionalIdKey.idValue);
                break;
            }
            case NOT_COORDINATOR: 
            case COORDINATOR_NOT_AVAILABLE: {
                unmapped.add(transactionalIdKey);
                this.log.debug("DescribeTransactions request for transactionalId `{}` returned error {}. Will attempt to find the coordinator again and retry", (Object)transactionalIdKey.idValue, (Object)error);
                break;
            }
            default: {
                failed.put(transactionalIdKey, error.exception("DescribeTransactions request for transactionalId `" + transactionalIdKey.idValue + "` failed due to unexpected error"));
            }
        }
    }
}

