/*
 * Decompiled with CFR 0.152.
 */
package net.logstash.logback.util;

import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;

public class ThreadLocalHolder<T> {
    private final Supplier<T> factory;
    private final ThreadLocal<Holder<T>> threadLocal = ThreadLocal.withInitial(this::initializeThread);
    protected final Map<Long, HolderRef> threadValues = new ConcurrentHashMap<Long, HolderRef>();
    private final ReferenceQueue<Thread> deadThreads = new ReferenceQueue();
    private volatile boolean closed = false;

    public ThreadLocalHolder(Supplier<T> factory2) {
        this.factory = Objects.requireNonNull(factory2);
    }

    public final T acquire() {
        Holder<T> holder = this.threadLocal.get();
        if (((Holder)holder).leased) {
            throw new IllegalStateException("ThreadLocal value is already in use and not yet released.");
        }
        if (((Holder)holder).value == null) {
            ((Holder)holder).value = Objects.requireNonNull(this.createInstance());
        }
        ((Holder)holder).leased = true;
        return (T)((Holder)holder).value;
    }

    public final void release() {
        Holder<T> holder = this.threadLocal.get();
        if (!((Holder)holder).leased) {
            throw new IllegalStateException("Invalid attempt at releasing a value that was not previously acquired.");
        }
        ((Holder)holder).leased = false;
        if (this.closed || !this.safelyRecycleInstance(((Holder)holder).value)) {
            this.disposeHolder(holder);
        }
        this.processDeadThreads();
    }

    public void close() {
        this.closed = true;
        for (HolderRef holderRef : this.threadValues.values()) {
            Holder holder = holderRef.getHolder();
            if (holder.leased) continue;
            this.disposeHolder(holder);
        }
        this.threadValues.clear();
        this.processDeadThreads();
    }

    private Holder<T> initializeThread() {
        Thread currentThread = Thread.currentThread();
        long threadId = currentThread.getId();
        return this.threadValues.computeIfAbsent(threadId, ignore -> new HolderRef(currentThread, new Holder(), this.deadThreads)).holder;
    }

    private void processDeadThreads() {
        HolderRef ref = (HolderRef)this.deadThreads.poll();
        while (ref != null) {
            Holder holder = ref.getHolder();
            this.disposeHolder(holder);
            this.threadValues.remove(ref.getThreadId());
            ref = (HolderRef)this.deadThreads.poll();
        }
    }

    private void disposeHolder(Holder<T> holder) {
        this.safelyDisposeInstance(((Holder)holder).value);
        ((Holder)holder).value = null;
    }

    protected T createInstance() {
        return this.factory.get();
    }

    protected void disposeInstance(T instance) {
        if (instance instanceof Lifecycle) {
            ((Lifecycle)instance).dispose();
        }
    }

    private void safelyDisposeInstance(T instance) {
        try {
            this.disposeInstance(instance);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected boolean recycleInstance(T instance) {
        if (instance instanceof Lifecycle) {
            return ((Lifecycle)instance).recycle();
        }
        return true;
    }

    private boolean safelyRecycleInstance(T instance) {
        try {
            return this.recycleInstance(instance);
        }
        catch (Exception e) {
            return false;
        }
    }

    private static class Holder<T> {
        private T value;
        private boolean leased;

        private Holder() {
        }
    }

    protected class HolderRef
    extends WeakReference<Thread> {
        private final Holder<T> holder;
        private final long threadId;

        HolderRef(Thread owningThread, Holder<T> holder, ReferenceQueue<Thread> referenceQueue) {
            super(owningThread, referenceQueue);
            this.threadId = owningThread.getId();
            this.holder = holder;
        }

        public Holder<T> getHolder() {
            return this.holder;
        }

        public long getThreadId() {
            return this.threadId;
        }
    }

    public static interface Lifecycle {
        default public boolean recycle() {
            return true;
        }

        default public void dispose() {
        }
    }
}

