/*
 * Decompiled with CFR 0.152.
 */
package net.logstash.logback.stacktrace;

import ch.qos.logback.classic.pattern.Abbreviator;
import ch.qos.logback.classic.pattern.ThrowableHandlingConverter;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.classic.spi.IThrowableProxy;
import ch.qos.logback.classic.spi.StackTraceElementProxy;
import ch.qos.logback.classic.spi.ThrowableProxy;
import ch.qos.logback.classic.spi.ThrowableProxyUtil;
import ch.qos.logback.core.CoreConstants;
import ch.qos.logback.core.boolex.EvaluationException;
import ch.qos.logback.core.boolex.EventEvaluator;
import ch.qos.logback.core.joran.spi.DefaultClass;
import ch.qos.logback.core.status.ErrorStatus;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.logstash.logback.abbreviator.DefaultTargetLengthAbbreviator;
import net.logstash.logback.encoder.SeparatorParser;
import net.logstash.logback.stacktrace.StackElementFilter;
import net.logstash.logback.stacktrace.StackHasher;
import net.logstash.logback.util.LogbackUtils;
import net.logstash.logback.util.StringUtils;

public class ShortenedThrowableConverter
extends ThrowableHandlingConverter {
    public static final int FULL_MAX_DEPTH_PER_THROWABLE = Integer.MAX_VALUE;
    public static final int SHORT_MAX_DEPTH_PER_THROWABLE = 3;
    public static final int DEFAULT_MAX_DEPTH_PER_THROWABLE = Integer.MAX_VALUE;
    public static final int FULL_MAX_LENGTH = Integer.MAX_VALUE;
    public static final int SHORT_MAX_LENGTH = 1024;
    public static final int DEFAULT_MAX_LENGTH = Integer.MAX_VALUE;
    public static final int FULL_CLASS_NAME_LENGTH = -1;
    public static final int SHORT_CLASS_NAME_LENGTH = 10;
    public static final int DEFAULT_CLASS_NAME_LENGTH = -1;
    private static final String ELLIPSIS = "...";
    private static final int BUFFER_INITIAL_CAPACITY = 4096;
    private static final String OPTION_VALUE_FULL = "full";
    private static final String OPTION_VALUE_SHORT = "short";
    private static final String OPTION_VALUE_ROOT_FIRST = "rootFirst";
    private static final String OPTION_VALUE_INLINE_HASH = "inlineHash";
    private static final String OPTION_VALUE_OMITCOMMONFRAMES = "omitCommonFrames";
    private static final String OPTION_VALUE_KEEPCOMMONFRAMES = "keepCommonFrames";
    private static final String OPTION_VALUE_INLINE_STACK = "inline";
    private static final int OPTION_INDEX_MAX_DEPTH = 0;
    private static final int OPTION_INDEX_SHORTENED_CLASS_NAME = 1;
    private static final int OPTION_INDEX_MAX_LENGTH = 2;
    public static final String DEFAULT_INLINE_SEPARATOR = "\\n";
    private AtomicInteger errorCount = new AtomicInteger();
    private int maxDepthPerThrowable = Integer.MAX_VALUE;
    private int maxLength = Integer.MAX_VALUE;
    private Abbreviator abbreviator = new DefaultTargetLengthAbbreviator();
    private List<Pattern> excludes = new ArrayList<Pattern>();
    private List<Pattern> truncateAfterPatterns = new ArrayList<Pattern>();
    private boolean rootCauseFirst;
    private boolean inlineHash;
    private boolean omitCommonFrames = true;
    private String lineSeparator = CoreConstants.LINE_SEPARATOR;
    private StackElementFilter stackElementFilter;
    private StackHasher stackHasher;
    private StackElementFilter truncateAfterFilter;
    private List<EventEvaluator<ILoggingEvent>> evaluators = new ArrayList<EventEvaluator<ILoggingEvent>>();

    @Override
    public void start() {
        this.parseOptions();
        if (this.excludes == null || this.excludes.isEmpty()) {
            if (this.inlineHash) {
                this.addInfo("[inlineHash] is active with no exclusion pattern: use non null source info filter to exclude generated classnames (see doc)");
                this.stackElementFilter = StackElementFilter.withSourceInfo();
            } else {
                this.stackElementFilter = StackElementFilter.any();
            }
        } else {
            this.stackElementFilter = StackElementFilter.byPattern(this.excludes);
        }
        if (this.inlineHash) {
            this.stackHasher = new StackHasher(this.stackElementFilter);
        }
        this.truncateAfterFilter = StackElementFilter.byPattern(this.truncateAfterPatterns);
        LogbackUtils.start(this.getContext(), this.abbreviator);
        super.start();
    }

    @Override
    public void stop() {
        super.stop();
        LogbackUtils.stop(this.abbreviator);
    }

    private void parseOptions() {
        List<String> optionList = this.getOptionList();
        if (optionList == null) {
            return;
        }
        int optionListSize = optionList.size();
        block19: for (int i = 0; i < optionListSize; ++i) {
            String option = optionList.get(i);
            switch (i) {
                case 0: {
                    this.setMaxDepthPerThrowable(this.parseIntegerOptionValue(option, Integer.MAX_VALUE, 3, Integer.MAX_VALUE));
                    continue block19;
                }
                case 1: {
                    this.setShortenedClassNameLength(this.parseIntegerOptionValue(option, -1, 10, -1));
                    continue block19;
                }
                case 2: {
                    this.setMaxLength(this.parseIntegerOptionValue(option, Integer.MAX_VALUE, 1024, Integer.MAX_VALUE));
                    continue block19;
                }
                default: {
                    EventEvaluator evaluator;
                    switch (option) {
                        case "rootFirst": {
                            this.setRootCauseFirst(true);
                            continue block19;
                        }
                        case "inlineHash": {
                            this.setInlineHash(true);
                            continue block19;
                        }
                        case "inline": {
                            this.setLineSeparator(DEFAULT_INLINE_SEPARATOR);
                            continue block19;
                        }
                        case "omitCommonFrames": {
                            this.setOmitCommonFrames(true);
                            continue block19;
                        }
                        case "keepCommonFrames": {
                            this.setOmitCommonFrames(false);
                            continue block19;
                        }
                    }
                    Map evaluatorMap = (Map)this.getContext().getObject("EVALUATOR_MAP");
                    EventEvaluator eventEvaluator = evaluator = evaluatorMap != null ? (EventEvaluator)evaluatorMap.get(option) : null;
                    if (evaluator != null) {
                        this.addEvaluator(evaluator);
                        continue block19;
                    }
                    this.addExclude(option);
                }
            }
        }
    }

    private int parseIntegerOptionValue(String option, int valueIfFull, int valueIfShort, int valueIfNonParsable) {
        if (OPTION_VALUE_FULL.equals(option)) {
            return valueIfFull;
        }
        if (OPTION_VALUE_SHORT.equals(option)) {
            return valueIfShort;
        }
        try {
            return Integer.parseInt(option);
        }
        catch (NumberFormatException nfe) {
            this.addError("Could not parse [" + option + "] as an integer, default to " + valueIfNonParsable);
            return valueIfNonParsable;
        }
    }

    @Override
    public String convert(ILoggingEvent event) {
        if (!this.isStarted()) {
            throw new IllegalStateException("Converter is not started");
        }
        IThrowableProxy throwableProxy = event.getThrowableProxy();
        if (throwableProxy == null || this.isExcludedByEvaluator(event)) {
            return "";
        }
        Deque<String> stackHashes = null;
        if (this.inlineHash && throwableProxy instanceof ThrowableProxy) {
            stackHashes = this.stackHasher.hexHashes(((ThrowableProxy)throwableProxy).getThrowable());
        }
        StringBuilder builder = new StringBuilder(Math.min(4096, this.maxLength + 100 > 0 ? this.maxLength + 100 : this.maxLength));
        if (this.rootCauseFirst) {
            this.appendRootCauseFirst(builder, null, 1, throwableProxy, stackHashes);
        } else {
            this.appendRootCauseLast(builder, null, 1, throwableProxy, stackHashes);
        }
        if (builder.length() > this.maxLength) {
            builder.setLength(this.maxLength - ELLIPSIS.length() - this.getLineSeparator().length());
            builder.append(ELLIPSIS).append(this.getLineSeparator());
        }
        return builder.toString();
    }

    public void setLineSeparator(String lineSeparator) {
        this.lineSeparator = SeparatorParser.parseSeparator(lineSeparator);
    }

    public String getLineSeparator() {
        return this.lineSeparator;
    }

    private boolean isExcludedByEvaluator(ILoggingEvent event) {
        for (int i = 0; i < this.evaluators.size(); ++i) {
            EventEvaluator<ILoggingEvent> evaluator = this.evaluators.get(i);
            try {
                if (!evaluator.evaluate(event)) continue;
                return true;
            }
            catch (EvaluationException eex) {
                int errors = this.errorCount.incrementAndGet();
                if (errors < 4) {
                    this.addError(String.format("Exception thrown for evaluator named [%s]", evaluator.getName()), eex);
                    continue;
                }
                if (errors != 4) continue;
                ErrorStatus errorStatus = new ErrorStatus(String.format("Exception thrown for evaluator named [%s]", evaluator.getName()), this, eex);
                errorStatus.add(new ErrorStatus("This was the last warning about this evaluator's errors. We don't want the StatusManager to get flooded.", this));
                this.addStatus(errorStatus);
            }
        }
        return false;
    }

    private void appendRootCauseLast(StringBuilder builder, String prefix, int indent, IThrowableProxy throwableProxy, Deque<String> stackHashes) {
        if (throwableProxy == null || builder.length() > this.maxLength) {
            return;
        }
        String hash = stackHashes == null || stackHashes.isEmpty() ? null : stackHashes.removeFirst();
        this.appendFirstLine(builder, prefix, indent, throwableProxy, hash);
        this.appendStackTraceElements(builder, indent, throwableProxy);
        IThrowableProxy[] suppressedThrowableProxies = throwableProxy.getSuppressed();
        if (suppressedThrowableProxies != null) {
            for (IThrowableProxy suppressedThrowableProxy : suppressedThrowableProxies) {
                this.appendRootCauseLast(builder, "Suppressed: ", indent + 1, suppressedThrowableProxy, null);
            }
        }
        this.appendRootCauseLast(builder, "Caused by: ", indent, throwableProxy.getCause(), stackHashes);
    }

    private void appendRootCauseFirst(StringBuilder builder, String prefix, int indent, IThrowableProxy throwableProxy, Deque<String> stackHashes) {
        if (throwableProxy == null || builder.length() > this.maxLength) {
            return;
        }
        if (throwableProxy.getCause() != null) {
            this.appendRootCauseFirst(builder, prefix, indent, throwableProxy.getCause(), stackHashes);
            prefix = "Wrapped by: ";
        }
        String hash = stackHashes == null || stackHashes.isEmpty() ? null : stackHashes.removeLast();
        this.appendFirstLine(builder, prefix, indent, throwableProxy, hash);
        this.appendStackTraceElements(builder, indent, throwableProxy);
        IThrowableProxy[] suppressedThrowableProxies = throwableProxy.getSuppressed();
        if (suppressedThrowableProxies != null) {
            for (IThrowableProxy suppressedThrowableProxy : suppressedThrowableProxies) {
                this.appendRootCauseFirst(builder, "Suppressed: ", indent + 1, suppressedThrowableProxy, null);
            }
        }
    }

    private void appendStackTraceElements(StringBuilder builder, int indent, IThrowableProxy throwableProxy) {
        int i;
        if (builder.length() > this.maxLength) {
            return;
        }
        StackTraceElementProxy[] stackTraceElements = throwableProxy.getStackTraceElementProxyArray();
        int commonFrames = this.isOmitCommonFrames() ? throwableProxy.getCommonFrames() : 0;
        boolean appendingExcluded = false;
        int consecutiveExcluded = 0;
        int appended = 0;
        StackTraceElementProxy previousWrittenStackTraceElement = null;
        for (i = 0; i < stackTraceElements.length - commonFrames && (this.maxDepthPerThrowable <= 0 || appended < this.maxDepthPerThrowable); ++i) {
            StackTraceElementProxy stackTraceElement = stackTraceElements[i];
            if (i < 1 || this.isIncluded(stackTraceElement)) {
                if (consecutiveExcluded >= 2) {
                    this.appendPlaceHolder(builder, indent, consecutiveExcluded, "frames excluded");
                    consecutiveExcluded = 0;
                } else if (consecutiveExcluded == 1) {
                    appendingExcluded = true;
                    consecutiveExcluded = 0;
                    i -= 2;
                    continue;
                }
                this.appendStackTraceElement(builder, indent, stackTraceElement, previousWrittenStackTraceElement);
                previousWrittenStackTraceElement = stackTraceElement;
                appendingExcluded = false;
                ++appended;
            } else if (appendingExcluded) {
                this.appendStackTraceElement(builder, indent, stackTraceElement, previousWrittenStackTraceElement);
                previousWrittenStackTraceElement = stackTraceElement;
                ++appended;
            } else {
                ++consecutiveExcluded;
            }
            if (this.shouldTruncateAfter(stackTraceElement)) break;
        }
        if (i + commonFrames < stackTraceElements.length) {
            if (consecutiveExcluded > 0) {
                this.appendPlaceHolder(builder, indent, --consecutiveExcluded, "frames excluded");
                this.appendStackTraceElement(builder, indent, stackTraceElements[i], previousWrittenStackTraceElement);
                ++appended;
            }
            if (commonFrames > 0) {
                this.appendPlaceHolder(builder, indent, stackTraceElements.length - appended - consecutiveExcluded, "frames truncated (including " + commonFrames + " common frames)");
            } else {
                this.appendPlaceHolder(builder, indent, stackTraceElements.length - appended - consecutiveExcluded, "frames truncated");
            }
        } else {
            if (consecutiveExcluded > 0) {
                this.appendPlaceHolder(builder, indent, consecutiveExcluded, "frames excluded");
            }
            if (commonFrames > 0) {
                this.appendPlaceHolder(builder, indent, commonFrames, "common frames omitted");
            }
        }
    }

    private void appendPlaceHolder(StringBuilder builder, int indent, int consecutiveExcluded, String message) {
        this.indent(builder, indent);
        builder.append(ELLIPSIS).append(" ").append(consecutiveExcluded).append(" ").append(message).append(this.getLineSeparator());
    }

    private boolean isIncluded(StackTraceElementProxy step) {
        return this.stackElementFilter.accept(step.getStackTraceElement());
    }

    private boolean shouldTruncateAfter(StackTraceElementProxy step) {
        return !this.truncateAfterFilter.accept(step.getStackTraceElement());
    }

    private void appendStackTraceElement(StringBuilder builder, int indent, StackTraceElementProxy step, StackTraceElementProxy previousStep) {
        if (builder.length() > this.maxLength) {
            return;
        }
        this.indent(builder, indent);
        StackTraceElement stackTraceElement = step.getStackTraceElement();
        String fileName = stackTraceElement.getFileName();
        int lineNumber = stackTraceElement.getLineNumber();
        builder.append("at ").append(this.abbreviator.abbreviate(stackTraceElement.getClassName())).append(".").append(stackTraceElement.getMethodName()).append("(").append(fileName == null ? "Unknown Source" : fileName);
        if (lineNumber >= 0) {
            builder.append(":").append(lineNumber);
        }
        builder.append(")");
        if (this.shouldAppendPackagingData(step, previousStep)) {
            this.appendPackagingData(builder, step);
        }
        builder.append(this.getLineSeparator());
    }

    private boolean shouldAppendPackagingData(StackTraceElementProxy step, StackTraceElementProxy previousStep) {
        if (step.getClassPackagingData() == null) {
            return false;
        }
        if (previousStep == null || previousStep.getClassPackagingData() == null) {
            return true;
        }
        return !step.getClassPackagingData().equals(previousStep.getClassPackagingData());
    }

    private void appendPackagingData(StringBuilder builder, StackTraceElementProxy step) {
        ThrowableProxyUtil.subjoinPackagingData(builder, step);
    }

    private void appendFirstLine(StringBuilder builder, String prefix, int indent, IThrowableProxy throwableProxy, String hash) {
        if (builder.length() > this.maxLength) {
            return;
        }
        this.indent(builder, indent - 1);
        if (prefix != null) {
            builder.append(prefix);
        }
        if (hash != null) {
            builder.append("<#" + hash + "> ");
        }
        builder.append(this.abbreviator.abbreviate(throwableProxy.getClassName())).append(": ").append(throwableProxy.getMessage()).append(this.getLineSeparator());
    }

    private void indent(StringBuilder builder, int indent) {
        ThrowableProxyUtil.indent(builder, indent);
    }

    public void setShortenedClassNameLength(int length) {
        if (!(this.abbreviator instanceof DefaultTargetLengthAbbreviator)) {
            throw new IllegalStateException("Cannot set shortenedClassNameLength on non default Abbreviator");
        }
        ((DefaultTargetLengthAbbreviator)this.abbreviator).setTargetLength(length);
    }

    public int getShortenedClassNameLength() {
        if (this.abbreviator instanceof DefaultTargetLengthAbbreviator) {
            return ((DefaultTargetLengthAbbreviator)this.abbreviator).getTargetLength();
        }
        throw new IllegalStateException("Cannot invoke getShortenedClassNameLength on non default abbreviator");
    }

    @DefaultClass(value=DefaultTargetLengthAbbreviator.class)
    public void setClassNameAbbreviator(Abbreviator abbreviator) {
        this.abbreviator = Objects.requireNonNull(abbreviator);
    }

    public Abbreviator getClassNameAbbreviator() {
        return this.abbreviator;
    }

    public void setMaxDepthPerThrowable(int maxDepthPerThrowable) {
        if (maxDepthPerThrowable <= 0 && maxDepthPerThrowable != -1) {
            throw new IllegalArgumentException("maxDepthPerThrowable must be > 0, or -1 to disable the feature");
        }
        if (maxDepthPerThrowable == -1) {
            maxDepthPerThrowable = Integer.MAX_VALUE;
        }
        this.maxDepthPerThrowable = maxDepthPerThrowable;
    }

    public int getMaxDepthPerThrowable() {
        return this.maxDepthPerThrowable;
    }

    public void setMaxLength(int maxLength) {
        if (maxLength <= 0 && maxLength != -1) {
            throw new IllegalArgumentException("maxLength must be > 0, or -1 to disable the feature");
        }
        if (maxLength == -1) {
            maxLength = Integer.MAX_VALUE;
        }
        this.maxLength = maxLength;
    }

    public int getMaxLength() {
        return this.maxLength;
    }

    public void setOmitCommonFrames(boolean omitCommonFrames) {
        this.omitCommonFrames = omitCommonFrames;
    }

    public boolean isOmitCommonFrames() {
        return this.omitCommonFrames;
    }

    public boolean isRootCauseFirst() {
        return this.rootCauseFirst;
    }

    public void setRootCauseFirst(boolean rootCauseFirst) {
        this.rootCauseFirst = rootCauseFirst;
    }

    public boolean isInlineHash() {
        return this.inlineHash;
    }

    public void setInlineHash(boolean inlineHash) {
        this.inlineHash = inlineHash;
    }

    void setStackHasher(StackHasher stackHasher) {
        this.stackHasher = stackHasher;
    }

    public void addExclude(String exclusionPattern) {
        this.excludes.add(Pattern.compile(exclusionPattern));
    }

    public void addExclusions(String commaSeparatedPatterns) {
        for (String regex : StringUtils.commaDelimitedListToStringArray(commaSeparatedPatterns)) {
            this.addExclude(regex);
        }
    }

    public void setExcludes(List<String> patterns) {
        this.excludes = new ArrayList<Pattern>(patterns.size());
        for (String pattern : patterns) {
            this.addExclude(pattern);
        }
    }

    public List<String> getExcludes() {
        return this.excludes.stream().map(Pattern::pattern).collect(Collectors.toList());
    }

    public void addTruncateAfter(String regex) {
        this.truncateAfterPatterns.add(Pattern.compile(regex));
    }

    public List<String> getTruncateAfters() {
        return this.truncateAfterPatterns.stream().map(Pattern::pattern).collect(Collectors.toList());
    }

    public void addTruncateAfters(String commaSeparatedPatterns) {
        for (String regex : StringUtils.commaDelimitedListToStringArray(commaSeparatedPatterns)) {
            this.addTruncateAfter(regex);
        }
    }

    public void setTruncateAfters(List<String> patterns) {
        this.truncateAfterPatterns = new ArrayList<Pattern>(patterns.size());
        for (String pattern : patterns) {
            this.addTruncateAfter(pattern);
        }
    }

    public void addEvaluator(EventEvaluator<ILoggingEvent> evaluator) {
        this.evaluators.add(Objects.requireNonNull(evaluator));
    }

    public void setEvaluators(List<EventEvaluator<ILoggingEvent>> evaluators) {
        this.evaluators = evaluators == null || evaluators.isEmpty() ? new ArrayList<EventEvaluator<ILoggingEvent>>(1) : new ArrayList<EventEvaluator<ILoggingEvent>>(evaluators);
    }

    public List<EventEvaluator<ILoggingEvent>> getEvaluators() {
        return new ArrayList<EventEvaluator<ILoggingEvent>>(this.evaluators);
    }
}

