/*
 * Decompiled with CFR 0.152.
 */
package net.logstash.logback.composite;

import ch.qos.logback.core.spi.DeferredProcessingAware;
import com.fasterxml.jackson.core.JsonGenerator;
import java.io.IOException;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Function;
import net.logstash.logback.composite.AbstractFieldJsonProvider;
import net.logstash.logback.composite.JsonWritingUtils;
import net.logstash.logback.util.LogbackUtils;

public abstract class AbstractSequenceJsonProvider<Event extends DeferredProcessingAware>
extends AbstractFieldJsonProvider<Event> {
    public static final String FIELD_SEQUENCE = "sequence";
    private Function<Event, Long> sequenceProvider;

    public AbstractSequenceJsonProvider() {
        this.setFieldName(FIELD_SEQUENCE);
    }

    @Override
    public void start() {
        if (this.getContext() == null) {
            throw new IllegalStateException("No context given to " + this.getClass().getName());
        }
        if (this.sequenceProvider == null) {
            this.sequenceProvider = this.createSequenceProvider();
        }
        super.start();
    }

    @Override
    public void writeTo(JsonGenerator generator, Event event) throws IOException {
        if (!this.isStarted()) {
            throw new IllegalStateException("Provider " + this.getClass().getName() + " is  not started");
        }
        JsonWritingUtils.writeNumberField(generator, this.getFieldName(), this.sequenceProvider.apply(event));
    }

    public void setSequenceProvider(Function<Event, Long> sequenceProvider) {
        this.sequenceProvider = Objects.requireNonNull(sequenceProvider);
    }

    public Function<Event, Long> getSequenceProvider() {
        return this.sequenceProvider;
    }

    protected Function<Event, Long> createSequenceProvider() {
        if (LogbackUtils.isVersion13()) {
            if (this.getContext() == null || this.getContext().getSequenceNumberGenerator() == null) {
                this.addWarn("No <sequenceNumberGenerator> defined in Logback configuration - revert to using a local incrementing sequence number.");
            } else {
                return this.createNativeSequenceNumberFieldAccessor();
            }
        }
        return new Function<Event, Long>(){
            private final AtomicLong sequence = new AtomicLong(0L);

            @Override
            public Long apply(Event t2) {
                return this.sequence.incrementAndGet();
            }
        };
    }

    protected abstract Function<Event, Long> createNativeSequenceNumberFieldAccessor();
}

