/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.predicate;

import io.undertow.attribute.ExchangeAttribute;
import io.undertow.attribute.ExchangeAttributes;
import io.undertow.predicate.AndPredicate;
import io.undertow.predicate.AuthenticationRequiredPredicate;
import io.undertow.predicate.ContainsPredicate;
import io.undertow.predicate.EqualsPredicate;
import io.undertow.predicate.ExistsPredicate;
import io.undertow.predicate.FalsePredicate;
import io.undertow.predicate.MaxContentSizePredicate;
import io.undertow.predicate.MinContentSizePredicate;
import io.undertow.predicate.NotPredicate;
import io.undertow.predicate.OrPredicate;
import io.undertow.predicate.PathMatchPredicate;
import io.undertow.predicate.PathPrefixPredicate;
import io.undertow.predicate.PathSuffixPredicate;
import io.undertow.predicate.Predicate;
import io.undertow.predicate.PredicateParser;
import io.undertow.predicate.RegularExpressionPredicate;
import io.undertow.predicate.RequestLargerThanPredicate;
import io.undertow.predicate.RequestSmallerThanPredicate;
import io.undertow.predicate.SecurePredicate;
import io.undertow.predicate.TruePredicate;

public class Predicates {
    public static Predicate equals(ExchangeAttribute[] attributes) {
        return new EqualsPredicate(attributes);
    }

    public static Predicate and(Predicate ... predicates) {
        return new AndPredicate(predicates);
    }

    public static Predicate or(Predicate ... predicates) {
        return new OrPredicate(predicates);
    }

    public static Predicate not(Predicate predicate) {
        return new NotPredicate(predicate);
    }

    public static Predicate path(String path) {
        return new PathMatchPredicate(path);
    }

    public static Predicate paths(String ... paths) {
        Predicate[] predicates = new PathMatchPredicate[paths.length];
        for (int i = 0; i < paths.length; ++i) {
            predicates[i] = new PathMatchPredicate(paths[i]);
        }
        return Predicates.or(predicates);
    }

    public static Predicate suffix(String path) {
        return new PathSuffixPredicate(path);
    }

    public static Predicate suffixes(String ... paths) {
        if (paths.length == 1) {
            return Predicates.suffix(paths[0]);
        }
        Predicate[] predicates = new PathSuffixPredicate[paths.length];
        for (int i = 0; i < paths.length; ++i) {
            predicates[i] = new PathSuffixPredicate(paths[i]);
        }
        return Predicates.or(predicates);
    }

    public static Predicate prefix(String path) {
        return new PathPrefixPredicate(path);
    }

    public static Predicate prefixes(String ... paths) {
        return new PathPrefixPredicate(paths);
    }

    @Deprecated
    public static Predicate maxContentSize(long size) {
        return new MaxContentSizePredicate(size);
    }

    @Deprecated
    public static Predicate minContentSize(long size) {
        return new MinContentSizePredicate(size);
    }

    public static Predicate requestSmallerThan(long size) {
        return new RequestSmallerThanPredicate(size);
    }

    public static Predicate requestLargerThan(long size) {
        return new RequestLargerThanPredicate(size);
    }

    public static Predicate truePredicate() {
        return TruePredicate.instance();
    }

    public static Predicate falsePredicate() {
        return FalsePredicate.instance();
    }

    public static Predicate exists(ExchangeAttribute attribute) {
        return new ExistsPredicate(attribute);
    }

    public static Predicate contains(ExchangeAttribute attribute, String ... values2) {
        return new ContainsPredicate(attribute, values2);
    }

    public static Predicate regex(ExchangeAttribute attribute, String pattern) {
        return new RegularExpressionPredicate(pattern, attribute);
    }

    public static Predicate regex(ExchangeAttribute attribute, String pattern, boolean requireFullMatch) {
        return new RegularExpressionPredicate(pattern, attribute, requireFullMatch);
    }

    public static Predicate regex(String attribute, String pattern, ClassLoader classLoader, boolean requireFullMatch) {
        return new RegularExpressionPredicate(pattern, ExchangeAttributes.parser(classLoader).parse(attribute), requireFullMatch);
    }

    public static Predicate authRequired() {
        return AuthenticationRequiredPredicate.INSTANCE;
    }

    public static Predicate parse(String predicate) {
        return PredicateParser.parse(predicate, Thread.currentThread().getContextClassLoader());
    }

    public static Predicate parse(String predicate, ClassLoader classLoader) {
        return PredicateParser.parse(predicate, classLoader);
    }

    public static Predicate secure() {
        return SecurePredicate.INSTANCE;
    }

    private Predicates() {
    }
}

