/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.metrics;

import io.dropwizard.metrics.Gauge;
import io.dropwizard.metrics.Metric;
import io.dropwizard.metrics.MetricName;
import io.dropwizard.metrics.MetricSet;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public class JvmAttributeGaugeSet
implements MetricSet {
    private final RuntimeMXBean runtime;

    public JvmAttributeGaugeSet() {
        this(ManagementFactory.getRuntimeMXBean());
    }

    public JvmAttributeGaugeSet(RuntimeMXBean runtime) {
        this.runtime = runtime;
    }

    @Override
    public Map<MetricName, Metric> getMetrics() {
        HashMap<MetricName, Gauge<Object>> gauges = new HashMap<MetricName, Gauge<Object>>();
        gauges.put(MetricName.build("name"), this.runtime::getName);
        gauges.put(MetricName.build("vendor"), () -> String.format(Locale.US, "%s %s %s (%s)", this.runtime.getVmVendor(), this.runtime.getVmName(), this.runtime.getVmVersion(), this.runtime.getSpecVersion()));
        gauges.put(MetricName.build("uptime"), this.runtime::getUptime);
        return Collections.unmodifiableMap(gauges);
    }
}

