/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.server;

import com.networknt.server.Server;
import com.networknt.server.ServerConfig;
import java.util.Map;

public enum ServerOption {
    IO_THREADS("ioThreads"),
    WORKER_THREADS("workerThreads"),
    BUFFER_SIZE("bufferSize"),
    BACKLOG("backlog"),
    SERVER_STRING("serverString"),
    ALWAYS_SET_DATE("alwaysSetDate"),
    MAX_TRANSFER_FILE_SIZE("maxTransferFileSize"),
    ALLOW_UNESCAPED_CHARACTERS_IN_URL("allowUnescapedCharactersInUrl"),
    SHUTDOWN_TIMEOUT("shutdownTimeout");

    private final String value;

    private ServerOption(String serverOption) {
        this.value = serverOption;
    }

    public String value() {
        return this.value;
    }

    protected static void serverOptionInit(Map<String, Object> mapConfig, ServerConfig serverConfig) {
        for (ServerOption serverOption : ServerOption.values()) {
            if (mapConfig.containsKey(serverOption.value())) {
                if (ServerOption.setServerOption(serverOption, mapConfig.get(serverOption.value), serverConfig)) continue;
                Server.logger.warn("Server option: " + serverOption.value() + " set in server.yml is invalid, has been reset to default value.");
                continue;
            }
            ServerOption.setToDefaultServerOption(serverOption, serverConfig);
        }
    }

    private static boolean setServerOption(ServerOption serverOption, Object value, ServerConfig serverConfig) {
        switch (serverOption) {
            case BACKLOG: {
                if (value == null || (Integer)value <= 0) {
                    serverConfig.setBacklog(10000);
                    return false;
                }
                return true;
            }
            case IO_THREADS: {
                if (value == null || (Integer)value <= 0) {
                    serverConfig.setIoThreads(Runtime.getRuntime().availableProcessors() * 2);
                    return false;
                }
                return true;
            }
            case WORKER_THREADS: {
                if (value == null || (Integer)value <= 0) {
                    serverConfig.setWorkerThreads(200);
                    return false;
                }
                return true;
            }
            case BUFFER_SIZE: {
                if (value == null || (Integer)value <= 0) {
                    serverConfig.setBufferSize(16384);
                    return false;
                }
                return true;
            }
            case SERVER_STRING: {
                if (value == null || value.equals("")) {
                    serverConfig.setServerString("L");
                    return false;
                }
                return true;
            }
            case ALWAYS_SET_DATE: {
                if (value == null) {
                    serverConfig.setAlwaysSetDate(true);
                }
                return true;
            }
            case MAX_TRANSFER_FILE_SIZE: {
                if (value == null || Long.parseLong(value.toString()) <= 0L) {
                    serverConfig.setMaxTransferFileSize(1000000L);
                    return false;
                }
                return true;
            }
            case ALLOW_UNESCAPED_CHARACTERS_IN_URL: {
                if (value == null) {
                    serverConfig.setAllowUnescapedCharactersInUrl(false);
                }
                return true;
            }
            case SHUTDOWN_TIMEOUT: {
                if (value == null || (Integer)value <= 0) {
                    serverConfig.setShutdownTimeout(10);
                    return false;
                }
                return true;
            }
        }
        return true;
    }

    private static void setToDefaultServerOption(ServerOption serverOption, ServerConfig serverConfig) {
        ServerOption.setServerOption(serverOption, null, serverConfig);
    }
}

