/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.openapi;

import com.networknt.config.Config;
import com.networknt.config.ConfigException;
import com.networknt.config.JsonMapper;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenApiHandlerConfig {
    private static final Logger logger = LoggerFactory.getLogger(OpenApiHandlerConfig.class);
    public static final String CONFIG_NAME = "openapi-handler";
    private static final String MULTIPLE_SPEC = "multipleSpec";
    private static final String IGNORE_INVALID_PATH = "ignoreInvalidPath";
    private static final String PATH_SPEC_MAPPING = "pathSpecMapping";
    boolean multipleSpec;
    boolean ignoreInvalidPath;
    Map<String, Object> pathSpecMapping;
    private Config config = Config.getInstance();
    private Map<String, Object> mappedConfig;

    private OpenApiHandlerConfig() {
        this(CONFIG_NAME);
    }

    private OpenApiHandlerConfig(String configName) {
        this.mappedConfig = this.config.getJsonMapConfigNoCache(configName);
        this.setConfigData();
        this.setConfigMap();
    }

    public static OpenApiHandlerConfig load() {
        return new OpenApiHandlerConfig();
    }

    public static OpenApiHandlerConfig load(String configName) {
        return new OpenApiHandlerConfig(configName);
    }

    void reload() {
        this.mappedConfig = this.config.getJsonMapConfigNoCache(CONFIG_NAME);
        this.setConfigData();
        this.setConfigMap();
    }

    public Map<String, Object> getMappedConfig() {
        return this.mappedConfig;
    }

    public boolean isMultipleSpec() {
        return this.multipleSpec;
    }

    public boolean isIgnoreInvalidPath() {
        return this.ignoreInvalidPath;
    }

    private void setConfigData() {
        Object object = this.mappedConfig.get(MULTIPLE_SPEC);
        if (object != null && ((Boolean)object).booleanValue()) {
            this.multipleSpec = (Boolean)object;
        }
        if ((object = this.mappedConfig.get(IGNORE_INVALID_PATH)) != null && ((Boolean)object).booleanValue()) {
            this.ignoreInvalidPath = (Boolean)object;
        }
    }

    public Map<String, Object> getPathSpecMapping() {
        return this.pathSpecMapping;
    }

    public void setPathSpecMapping(Map<String, Object> pathSpecMapping) {
        this.pathSpecMapping = pathSpecMapping;
    }

    private void setConfigMap() {
        if (this.mappedConfig.get(PATH_SPEC_MAPPING) != null) {
            Object object = this.mappedConfig.get(PATH_SPEC_MAPPING);
            this.pathSpecMapping = new HashMap<String, Object>();
            if (object instanceof String) {
                String s2 = (String)object;
                s2 = s2.trim();
                if (logger.isTraceEnabled()) {
                    logger.trace("s = " + s2);
                }
                if (s2.startsWith("{")) {
                    try {
                        this.pathSpecMapping = JsonMapper.string2Map(s2);
                    }
                    catch (Exception e) {
                        throw new ConfigException("could not parse the pathSpecMapping json with a map of strings.");
                    }
                } else {
                    String[] pairs = s2.split(",");
                    for (int i = 0; i < pairs.length; ++i) {
                        String pair = pairs[i];
                        String[] keyValue = pair.split(":");
                        this.pathSpecMapping.put(keyValue[0], keyValue[1]);
                    }
                }
            } else if (object instanceof Map) {
                this.pathSpecMapping = (Map)object;
            } else {
                throw new ConfigException("pathSpecMapping must be a string or a list of strings.");
            }
        }
    }
}

