/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.oauth.cache;

import com.networknt.client.oauth.ClientCredentialsRequest;
import com.networknt.client.oauth.OauthHelper;
import com.networknt.client.oauth.TokenResponse;
import com.networknt.config.Config;
import com.networknt.exception.ApiException;
import com.networknt.monad.Result;
import com.networknt.oauth.cache.OAuthConfig;
import java.util.HashMap;
import java.util.Map;
import net.lightapi.portal.HybridCommandClient;
import net.lightapi.portal.HybridQueryClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientUtil {
    private static final Logger logger = LoggerFactory.getLogger(ClientUtil.class);
    private static OAuthConfig config = (OAuthConfig)Config.getInstance().getJsonObjectConfig("oauth", OAuthConfig.class);

    private static String getClientCredentialsToken() throws ApiException {
        if (config.getBootstrapToken() != null) {
            return config.getBootstrapToken();
        }
        ClientCredentialsRequest tokenRequest = new ClientCredentialsRequest();
        Result<TokenResponse> resultJwt = OauthHelper.getTokenResult(tokenRequest);
        if (resultJwt.isFailure()) {
            logger.error("failed to get the access token: " + resultJwt.getError());
            throw new ApiException(resultJwt.getError());
        }
        return resultJwt.getResult().getAccessToken();
    }

    public static Result<String> getClientById(String clientId) throws ApiException {
        return HybridQueryClient.getClientById(ClientUtil.getClientCredentialsToken(), clientId);
    }

    public static Result<String> createAuthCode(Map<String, Object> codeMap) throws ApiException {
        return HybridCommandClient.createAuthCode(codeMap, ClientUtil.getClientCredentialsToken());
    }

    public static Result<String> deleteAuthCode(String host, String authCode) throws ApiException {
        return HybridCommandClient.deleteAuthCode(host, authCode, ClientUtil.getClientCredentialsToken());
    }

    public static Result<String> getAuthCodeDetail(String authCode) throws ApiException {
        String query = String.format("{\"host\":\"lightapi.net\",\"service\":\"market\",\"action\":\"getAuthCodeDetail\",\"version\":\"0.1.0\",\"data\":{\"authCode\":\"%s\"}}", authCode);
        return HybridQueryClient.callQueryWithToken(query, ClientUtil.getClientCredentialsToken());
    }

    public static Result<String> createRefToken(String host, String refToken, String jwt, String clientId) throws ApiException {
        HashMap<String, Object> refTokenMap = new HashMap<String, Object>();
        refTokenMap.put("host", host);
        refTokenMap.put("refToken", refToken);
        refTokenMap.put("jwt", jwt);
        if (clientId != null) {
            refTokenMap.put("clientId", clientId);
        }
        return HybridCommandClient.createRefToken(refTokenMap, ClientUtil.getClientCredentialsToken());
    }

    public static Result<String> deleteRefToken(String host, String refToken) throws ApiException {
        String command = String.format("{\"host\":\"lightapi.net\",\"service\":\"market\",\"action\":\"deleteRefToken\",\"version\":\"0.1.0\",\"data\":{\"host\":\"%s\",\"refToken\":\"%s\"}}", host, refToken);
        return HybridCommandClient.callCommandWithToken(command, ClientUtil.getClientCredentialsToken());
    }

    public static Result<String> getRefTokenDetail(String refToken) throws ApiException {
        String query = String.format("{\"host\":\"lightapi.net\",\"service\":\"market\",\"action\":\"getRefTokenDetail\",\"version\":\"0.1.0\",\"data\":{\"refToken\":\"%s\"}}", refToken);
        return HybridQueryClient.callQueryWithToken(query, ClientUtil.getClientCredentialsToken());
    }

    public static Result<String> createRefreshToken(Map<String, Object> tokenMap) throws ApiException {
        return HybridCommandClient.createRefreshToken(tokenMap, ClientUtil.getClientCredentialsToken());
    }

    public static Result<String> deleteRefreshToken(String host, String refreshToken) throws ApiException {
        String command = String.format("{\"host\":\"lightapi.net\",\"service\":\"market\",\"action\":\"deleteRefreshToken\",\"version\":\"0.1.0\",\"data\":{\"host\":\"%s\",\"refreshToken\":\"%s\"}}", host, refreshToken);
        return HybridCommandClient.callCommandWithToken(command, ClientUtil.getClientCredentialsToken());
    }

    public static Result<String> getRefreshTokenDetail(String refreshToken) throws ApiException {
        String query = String.format("{\"host\":\"lightapi.net\",\"service\":\"market\",\"action\":\"getRefreshTokenDetail\",\"version\":\"0.1.0\",\"data\":{\"refreshToken\":\"%s\"}}", refreshToken);
        return HybridQueryClient.callQueryWithToken(query, ClientUtil.getClientCredentialsToken());
    }

    public static Result<String> getProviderDetail(String providerId) throws ApiException {
        String query = String.format("{\"host\":\"lightapi.net\",\"service\":\"market\",\"action\":\"getProviderDetail\",\"version\":\"0.1.0\",\"data\":{\"providerId\":\"%s\"}}", providerId);
        return HybridQueryClient.callQueryWithToken(query, ClientUtil.getClientCredentialsToken());
    }
}

