/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.oas.validator.impl;

import com.networknt.jsonoverlay.MapOverlay;
import com.networknt.jsonoverlay.Overlay;
import com.networknt.oas.model.OpenApi3;
import com.networknt.oas.model.SecurityParameter;
import com.networknt.oas.model.SecurityRequirement;
import com.networknt.oas.validator.ObjectValidatorBase;
import com.networknt.oas.validator.impl.OpenApi3Messages;
import com.networknt.oas.validator.impl.SecurityParameterValidator;
import com.networknt.oas.validator.msg.Messages;
import java.util.Map;
import java.util.Set;

public class SecurityRequirementValidator
extends ObjectValidatorBase<SecurityRequirement> {
    @Override
    public void runObjectValidations() {
        Overlay<Map<String, SecurityParameter>> requirements = this.validateMapField("requirements", false, false, SecurityParameter.class, new SecurityParameterValidator());
        this.checkAllSchemesDefined(requirements);
    }

    public void checkAllSchemesDefined(Overlay<Map<String, SecurityParameter>> requirements) {
        OpenApi3 model = (OpenApi3)this.value.getModel();
        Set<String> definedSchemes = model.getSecuritySchemes().keySet();
        MapOverlay mapOverlay = Overlay.getMapOverlay(requirements);
        for (String name : mapOverlay.keySet()) {
            if (definedSchemes.contains(name)) continue;
            this.results.addError(Messages.msg(OpenApi3Messages.UnkSecScheme, name), Overlay.of(mapOverlay, name));
        }
    }
}

