/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.metrics;

import com.networknt.config.Config;
import com.networknt.handler.Handler;
import com.networknt.handler.MiddlewareHandler;
import com.networknt.httpstring.AttachmentConstants;
import com.networknt.metrics.AbstractMetricsHandler;
import com.networknt.metrics.MetricsConfig;
import com.networknt.server.Server;
import com.networknt.utility.ModuleRegistry;
import com.networknt.utility.Util;
import io.dropwizard.metrics.Clock;
import io.dropwizard.metrics.MetricFilter;
import io.dropwizard.metrics.MetricName;
import io.dropwizard.metrics.MetricRegistry;
import io.dropwizard.metrics.influxdb.InfluxDbHttpSender;
import io.dropwizard.metrics.influxdb.InfluxDbReporter;
import io.undertow.Handlers;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import java.net.InetAddress;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetricsHandler
extends AbstractMetricsHandler {
    static final Logger logger = LoggerFactory.getLogger(MetricsHandler.class);
    private boolean firstTime = true;
    static String MASK_KEY_SERVER_PASS = "serverPass";
    private volatile HttpHandler next;

    public MetricsHandler() {
        config = MetricsConfig.load();
        if (config.getIssuerRegex() != null) {
            pattern = Pattern.compile(config.getIssuerRegex());
        }
        ModuleRegistry.registerModule(MetricsHandler.class.getName(), config.getMappedConfig(), List.of(MASK_KEY_SERVER_PASS));
        if (logger.isDebugEnabled()) {
            logger.debug("MetricsHandler is constructed!");
        }
    }

    @Override
    public void handleRequest(HttpServerExchange exchange) throws Exception {
        if (logger.isDebugEnabled()) {
            logger.debug("MetricsHandler.handleRequest starts.");
        }
        if (this.firstTime) {
            this.commonTags.put("api", Server.getServerConfig().getServiceId());
            this.commonTags.put("env", Server.getServerConfig().getEnvironment());
            this.commonTags.put("addr", Server.currentAddress);
            this.commonTags.put("port", "" + (Server.getServerConfig().isEnableHttps() ? Server.currentHttpsPort : Server.currentHttpPort));
            InetAddress inetAddress = Util.getInetAddress();
            this.commonTags.put("host", inetAddress == null ? "unknown" : inetAddress.getHostName());
            if (logger.isDebugEnabled()) {
                logger.debug(this.commonTags.toString());
            }
            try {
                InfluxDbHttpSender influxDb = new InfluxDbHttpSender(config.getServerProtocol(), config.getServerHost(), config.getServerPort(), config.getServerName(), config.getServerUser(), config.getServerPass());
                InfluxDbReporter reporter = InfluxDbReporter.forRegistry(registry).convertRatesTo(TimeUnit.SECONDS).convertDurationsTo(TimeUnit.MILLISECONDS).filter(MetricFilter.ALL).build(influxDb);
                reporter.start(config.getReportInMinutes(), TimeUnit.MINUTES);
                if (MetricsHandler.config.enableJVMMonitor) {
                    this.createJVMMetricsReporter(influxDb);
                }
                logger.info("metrics is enabled and reporter is started");
            }
            catch (Exception e) {
                logger.error("metrics is failed to connect to the influxdb", e);
            }
            this.firstTime = false;
        }
        long startTime = Clock.defaultClock().getTick();
        exchange.addExchangeCompleteListener((exchange1, nextListener) -> {
            try {
                Map auditInfo = exchange1.getAttachment(AttachmentConstants.AUDIT_INFO);
                if (auditInfo != null) {
                    HashMap<String, String> tags = new HashMap<String, String>();
                    tags.put("endpoint", (String)auditInfo.get("endpoint"));
                    tags.put("clientId", auditInfo.get("client_id") != null ? (String)auditInfo.get("client_id") : "unknown");
                    tags.put("scopeClientId", auditInfo.get("scope_client_id") != null ? (String)auditInfo.get("scope_client_id") : "unknown");
                    tags.put("callerId", auditInfo.get("caller_id") != null ? (String)auditInfo.get("caller_id") : "unknown");
                    long time = Clock.defaultClock().getTick() - startTime;
                    MetricName metricName = new MetricName("response_time");
                    metricName = metricName.tagged(this.commonTags);
                    metricName = metricName.tagged(tags);
                    registry.getOrAdd(metricName, MetricRegistry.MetricBuilder.TIMERS).update(time, TimeUnit.NANOSECONDS);
                    this.incCounterForStatusCode(exchange1.getStatusCode(), this.commonTags, tags);
                }
            }
            catch (Throwable e) {
                logger.error("ExchangeListener throwable", e);
            }
            finally {
                nextListener.proceed();
            }
        });
        if (logger.isDebugEnabled()) {
            logger.debug("MetricsHandler.handleRequest ends.");
        }
        Handler.next(exchange, this.next);
    }

    @Override
    public void register() {
        ModuleRegistry.registerModule(MetricsHandler.class.getName(), Config.getInstance().getJsonMapConfigNoCache("handler"), List.of(MASK_KEY_SERVER_PASS));
    }

    @Override
    public void reload() {
        config.reload();
        ModuleRegistry.registerModule(MetricsHandler.class.getName(), Config.getInstance().getJsonMapConfigNoCache("handler"), List.of(MASK_KEY_SERVER_PASS));
        if (logger.isTraceEnabled()) {
            logger.trace("MetricsHandler is reloaded.");
        }
    }

    @Override
    public HttpHandler getNext() {
        return this.next;
    }

    @Override
    public MiddlewareHandler setNext(HttpHandler next) {
        Handlers.handlerNotNull(next);
        this.next = next;
        return this;
    }
}

