/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.metrics;

import com.networknt.handler.MiddlewareHandler;
import com.networknt.httpstring.AttachmentConstants;
import com.networknt.metrics.JVMMetricsDbReporter;
import com.networknt.metrics.MetricsConfig;
import com.networknt.metrics.TimeSeriesDbSender;
import io.dropwizard.metrics.MetricFilter;
import io.dropwizard.metrics.MetricName;
import io.dropwizard.metrics.MetricRegistry;
import io.undertow.server.HttpServerExchange;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractMetricsHandler
implements MiddlewareHandler {
    static final Logger logger = LoggerFactory.getLogger(AbstractMetricsHandler.class);
    public static MetricsConfig config;
    static Pattern pattern;
    public static final MetricRegistry registry;
    public Map<String, String> commonTags = new HashMap<String, String>();

    @Override
    public boolean isEnabled() {
        return config.isEnabled();
    }

    public void createJVMMetricsReporter(TimeSeriesDbSender sender) {
        JVMMetricsDbReporter jvmReporter = new JVMMetricsDbReporter(new MetricRegistry(), sender, "jvm-reporter", MetricFilter.ALL, TimeUnit.SECONDS, TimeUnit.MILLISECONDS, this.commonTags);
        jvmReporter.start(config.getReportInMinutes(), TimeUnit.MINUTES);
    }

    public void incCounterForStatusCode(int statusCode, Map<String, String> commonTags, Map<String, String> tags) {
        MetricName metricName = new MetricName("request").tagged(commonTags).tagged(tags);
        registry.getOrAdd(metricName, MetricRegistry.MetricBuilder.COUNTERS).inc();
        if (statusCode >= 200 && statusCode < 400) {
            metricName = new MetricName("success").tagged(commonTags).tagged(tags);
            registry.getOrAdd(metricName, MetricRegistry.MetricBuilder.COUNTERS).inc();
        } else if (statusCode == 401 || statusCode == 403) {
            metricName = new MetricName("auth_error").tagged(commonTags).tagged(tags);
            registry.getOrAdd(metricName, MetricRegistry.MetricBuilder.COUNTERS).inc();
        } else if (statusCode >= 400 && statusCode < 500) {
            metricName = new MetricName("request_error").tagged(commonTags).tagged(tags);
            registry.getOrAdd(metricName, MetricRegistry.MetricBuilder.COUNTERS).inc();
        } else if (statusCode >= 500) {
            metricName = new MetricName("server_error").tagged(commonTags).tagged(tags);
            registry.getOrAdd(metricName, MetricRegistry.MetricBuilder.COUNTERS).inc();
        }
    }

    public void injectMetrics(HttpServerExchange httpServerExchange, long startTime, String metricsName) {
        Map auditInfo = httpServerExchange.getAttachment(AttachmentConstants.AUDIT_INFO);
        if (auditInfo != null) {
            String issuer;
            String clientId;
            HashMap<String, String> tags = new HashMap<String, String>();
            tags.put("endpoint", (String)auditInfo.get("endpoint"));
            String string = clientId = auditInfo.get("client_id") != null ? (String)auditInfo.get("client_id") : "unknown";
            if (logger.isTraceEnabled()) {
                logger.trace("clientId = " + clientId);
            }
            tags.put("clientId", clientId);
            if (config.isSendScopeClientId()) {
                tags.put("scopeClientId", auditInfo.get("scope_client_id") != null ? (String)auditInfo.get("scope_client_id") : "unknown");
            }
            if (config.isSendCallerId()) {
                tags.put("callerId", auditInfo.get("caller_id") != null ? (String)auditInfo.get("caller_id") : "unknown");
            }
            if (config.isSendIssuer() && (issuer = (String)auditInfo.get("issuer_claims")) != null) {
                if (config.getIssuerRegex() != null) {
                    Matcher matcher = pattern.matcher(issuer);
                    if (matcher.find()) {
                        String iss = matcher.group(1);
                        if (logger.isTraceEnabled()) {
                            logger.trace("Extracted issuer {} from Original issuer {] is sent.", (Object)iss, (Object)issuer);
                        }
                        tags.put("issuer", iss != null ? iss : "unknown");
                    }
                } else {
                    if (logger.isTraceEnabled()) {
                        logger.trace("Original issuer {} is sent.", (Object)issuer);
                    }
                    tags.put("issuer", issuer);
                }
            }
            MetricName metricName = new MetricName(metricsName);
            metricName = metricName.tagged(this.commonTags);
            metricName = metricName.tagged(tags);
            long time = System.nanoTime() - startTime;
            registry.getOrAdd(metricName, MetricRegistry.MetricBuilder.TIMERS).update(time, TimeUnit.NANOSECONDS);
            this.incCounterForStatusCode(httpServerExchange.getStatusCode(), this.commonTags, tags);
        }
    }

    static {
        registry = new MetricRegistry();
    }
}

