/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.client.simplepool;

import com.networknt.client.simplepool.SimpleConnection;
import com.networknt.client.simplepool.SimpleConnectionMaker;
import io.undertow.connector.ByteBufferPool;
import java.net.InetSocketAddress;
import java.net.URI;
import java.util.ArrayList;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnio.OptionMap;
import org.xnio.XnioWorker;
import org.xnio.ssl.XnioSsl;

public final class SimpleConnectionHolder {
    private static final Logger logger = LoggerFactory.getLogger(SimpleConnectionHolder.class);
    private final long EXPIRE_TIME;
    private final int MAX_BORROWS;
    private final long startTime;
    private final URI uri;
    private volatile boolean closed = false;
    private final SimpleConnectionMaker connectionMaker;
    private final SimpleConnection connection;
    private final Set<ConnectionToken> borrowedTokens = ConcurrentHashMap.newKeySet();
    private volatile boolean firstUse = true;

    public SimpleConnectionHolder(long expireTime, long connectionCreateTimeout, URI uri, InetSocketAddress bindAddress, XnioWorker worker, ByteBufferPool bufferPool, XnioSsl ssl, OptionMap options, Set<SimpleConnection> allCreatedConnections, SimpleConnectionMaker connectionMaker) {
        this.connectionMaker = connectionMaker;
        this.uri = uri;
        this.EXPIRE_TIME = expireTime;
        long now = System.currentTimeMillis();
        this.connection = connectionMaker.makeConnection(connectionCreateTimeout, bindAddress, uri, worker, ssl, bufferPool, options, allCreatedConnections);
        if (!this.connection.isOpen()) {
            logger.debug("{} closed connection", (Object)this.logLabel(this.connection, now));
            throw new RuntimeException("[" + SimpleConnectionHolder.port(this.connection) + "] Error creating connection to " + uri.toString());
        }
        this.startTime = System.currentTimeMillis();
        this.MAX_BORROWS = this.connection().isMultiplexingSupported() ? Integer.MAX_VALUE : 1;
        logger.debug("{} New connection : {}", (Object)this.logLabel(this.connection, now), (Object)(this.MAX_BORROWS > 1 ? "HTTP/2" : "HTTP/1.1"));
    }

    public synchronized ConnectionToken borrow(long connectionCreateTimeout, long now) throws RuntimeException {
        if (this.borrowable(now)) {
            ConnectionToken connectionToken;
            if (this.firstUse) {
                this.firstUse = false;
                connectionToken = new ConnectionToken(this.connection);
            } else {
                SimpleConnection reusedConnection = this.connectionMaker.reuseConnection(connectionCreateTimeout, this.connection);
                connectionToken = new ConnectionToken(reusedConnection);
            }
            this.borrowedTokens.add(connectionToken);
            logger.debug("{} borrow - connection now has {} borrows", (Object)this.logLabel(this.connection, now), (Object)this.borrowedTokens.size());
            return connectionToken;
        }
        if (this.closed()) {
            throw new RuntimeException("Connection was unexpectedly closed");
        }
        throw new IllegalStateException("Attempt made to borrow connection outside of BORROWABLE state");
    }

    public synchronized void restore(ConnectionToken connectionToken) {
        this.borrowedTokens.remove(connectionToken);
        long now = System.currentTimeMillis();
        logger.debug("{} restore - connection now has {} borrows", (Object)this.logLabel(this.connection, now), (Object)this.borrowedTokens.size());
    }

    public synchronized boolean safeClose(long now) {
        boolean notBorrowedExpired;
        logger.debug("{} close - closing connection with {} borrows...", (Object)this.logLabel(this.connection, now), (Object)this.borrowedTokens.size());
        if (this.closed()) {
            return true;
        }
        boolean bl = notBorrowedExpired = !this.borrowed() && this.expired(now);
        if (!notBorrowedExpired) {
            throw new IllegalStateException();
        }
        this.closed = true;
        this.connection.safeClose();
        return this.closed;
    }

    public synchronized boolean closed() {
        if (this.closed) {
            return this.closed;
        }
        if (!this.connection.isOpen()) {
            this.closed = true;
        }
        return this.closed;
    }

    public synchronized boolean expired(long now) {
        return now - this.startTime >= this.EXPIRE_TIME;
    }

    public synchronized boolean borrowed() {
        return this.borrowedTokens.size() > 0;
    }

    public synchronized boolean maxBorrowed() {
        return this.borrowedTokens.size() >= this.MAX_BORROWS;
    }

    public synchronized boolean borrowable(long now) {
        return this.connection.isOpen() && !this.expired(now) && !this.maxBorrowed();
    }

    public SimpleConnection connection() {
        return this.connection;
    }

    private String logLabel(SimpleConnection connection, long now) {
        return "[" + SimpleConnectionHolder.port(connection) + ": " + this.state(now) + "]";
    }

    private static String port(SimpleConnection connection) {
        if (connection == null) {
            return "NULL";
        }
        String url = connection.getLocalAddress();
        int semiColon = url.lastIndexOf(":");
        if (semiColon == -1) {
            return "PORT?";
        }
        return url.substring(url.lastIndexOf(":") + 1);
    }

    private String state(long now) {
        ArrayList<State> stateList = new ArrayList<State>();
        if (this.closed()) {
            stateList.add(State.CLOSED);
        }
        if (this.borrowed()) {
            stateList.add(State.BORROWED);
        } else {
            stateList.add(State.NOT_BORROWED);
        }
        if (this.borrowable(now)) {
            stateList.add(State.BORROWABLE);
        } else if (!this.expired(now)) {
            stateList.add(State.NOT_BORROWABLE);
        }
        if (this.expired(now)) {
            stateList.add(State.EXPIRED);
        }
        StringBuilder state = new StringBuilder();
        for (int i = 0; i < stateList.size(); ++i) {
            state.append(stateList.get(i));
            if (i + 1 >= stateList.size()) continue;
            state.append(" ");
        }
        return stateList.size() > 0 ? state.toString() : "ILLEGAL_STATE";
    }

    private static enum State {
        CLOSED,
        BORROWABLE,
        NOT_BORROWABLE,
        NOT_BORROWED,
        VALID,
        BORROWED,
        EXPIRED;

    }

    public class ConnectionToken {
        private final SimpleConnection connection;
        private final SimpleConnectionHolder holder;
        private final URI uri;

        ConnectionToken(SimpleConnection connection) {
            this.connection = connection;
            this.holder = SimpleConnectionHolder.this;
            this.uri = SimpleConnectionHolder.this.uri;
        }

        SimpleConnectionHolder holder() {
            return this.holder;
        }

        SimpleConnection connection() {
            return this.connection;
        }

        public Object getRawConnection() {
            return this.connection.getRawConnection();
        }

        public URI uri() {
            return this.uri;
        }
    }
}

