/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.audit;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.networknt.audit.AuditConfig;
import com.networknt.config.Config;
import com.networknt.handler.Handler;
import com.networknt.handler.MiddlewareHandler;
import com.networknt.httpstring.AttachmentConstants;
import com.networknt.mask.Mask;
import com.networknt.status.Status;
import com.networknt.utility.ModuleRegistry;
import com.networknt.utility.StringUtils;
import io.undertow.Handlers;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.Cookie;
import io.undertow.util.Headers;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Deque;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuditHandler
implements MiddlewareHandler {
    static final Logger logger = LoggerFactory.getLogger(AuditHandler.class);
    static final String STATUS_CODE = "statusCode";
    static final String RESPONSE_TIME = "responseTime";
    static final String TIMESTAMP = "timestamp";
    static final String MASK_KEY = "audit";
    static final String REQUEST_BODY_KEY = "requestBody";
    static final String RESPONSE_BODY_KEY = "responseBody";
    static final String QUERY_PARAMETERS_KEY = "queryParameters";
    static final String PATH_PARAMETERS_KEY = "pathParameters";
    static final String REQUEST_COOKIES_KEY = "requestCookies";
    static final String SERVER_CONFIG = "server";
    static final String SERVICE_ID_KEY = "serviceId";
    static final String INVALID_CONFIG_VALUE_CODE = "ERR10060";
    private AuditConfig config;
    private volatile HttpHandler next;
    private String serviceId;
    private DateTimeFormatter DATE_TIME_FORMATTER;

    public AuditHandler() {
        String timestampFormat;
        if (logger.isInfoEnabled()) {
            logger.info("AuditHandler is loaded.");
        }
        this.config = AuditConfig.load();
        Map<String, Object> serverConfig = Config.getInstance().getJsonMapConfigNoCache(SERVER_CONFIG);
        if (serverConfig != null) {
            this.serviceId = (String)serverConfig.get(SERVICE_ID_KEY);
        }
        if (!StringUtils.isBlank(timestampFormat = this.config.getTimestampFormat())) {
            try {
                this.DATE_TIME_FORMATTER = DateTimeFormatter.ofPattern(timestampFormat).withZone(ZoneId.systemDefault());
            }
            catch (IllegalArgumentException e) {
                logger.error(new Status(INVALID_CONFIG_VALUE_CODE, timestampFormat, "timestampFormat", "audit.yml").toString());
            }
        }
    }

    @Override
    public void handleRequest(HttpServerExchange exchange) throws Exception {
        boolean needAuditData;
        if (logger.isDebugEnabled()) {
            logger.debug("AuditHandler.handleRequest starts.");
        }
        Map auditInfo = exchange.getAttachment(AttachmentConstants.AUDIT_INFO);
        LinkedHashMap<String, Object> auditMap = new LinkedHashMap<String, Object>();
        long start = System.currentTimeMillis();
        auditMap.put(TIMESTAMP, this.DATE_TIME_FORMATTER == null ? Long.valueOf(System.currentTimeMillis()) : this.DATE_TIME_FORMATTER.format(Instant.now()));
        boolean bl = needAuditData = auditInfo != null && this.config.hasAuditList();
        if (needAuditData) {
            this.auditFields(auditInfo, auditMap);
        }
        this.auditRequest(exchange, auditMap, this.config);
        if (this.config.hasAuditList() && this.config.getAuditList().contains(SERVICE_ID_KEY)) {
            this.auditServiceId(auditMap);
        }
        if (this.config.isStatusCode() || this.config.isResponseTime()) {
            exchange.addExchangeCompleteListener((exchange1, nextListener) -> {
                try {
                    Map auditInfo1;
                    if (this.config.isStatusCode()) {
                        auditMap.put(STATUS_CODE, exchange1.getStatusCode());
                    }
                    if (this.config.isResponseTime()) {
                        auditMap.put(RESPONSE_TIME, System.currentTimeMillis() - start);
                    }
                    if ((auditInfo1 = exchange.getAttachment(AttachmentConstants.AUDIT_INFO)) != null && this.config.getAuditList() != null) {
                        for (String name : this.config.getAuditList()) {
                            Object object = auditInfo1.get(name);
                            if (object == null) continue;
                            auditMap.putIfAbsent(name, object);
                        }
                    }
                    if (this.config.getAuditList() != null && this.config.getAuditList().contains(RESPONSE_BODY_KEY)) {
                        this.auditResponseBody(exchange, auditMap);
                    }
                    try {
                        if (this.config.isAuditOnError()) {
                            if (exchange1.getStatusCode() >= 400) {
                                this.config.getAuditFunc().accept(Config.getInstance().getMapper().writeValueAsString(auditMap));
                            }
                        } else {
                            this.config.getAuditFunc().accept(Config.getInstance().getMapper().writeValueAsString(auditMap));
                        }
                    }
                    catch (JsonProcessingException e) {
                        throw new RuntimeException(e);
                    }
                }
                catch (Throwable e) {
                    logger.error("ExchangeListener Throwable", e);
                }
                finally {
                    nextListener.proceed();
                }
            });
        } else {
            this.config.getAuditFunc().accept(this.config.getConfig().getMapper().writeValueAsString(auditMap));
        }
        if (logger.isDebugEnabled()) {
            logger.debug("AuditHandler.handleRequest ends.");
        }
        this.next(exchange);
    }

    private void auditHeader(HttpServerExchange exchange, Map<String, Object> auditMap) {
        for (String name : this.config.getHeaderList()) {
            String value = exchange.getRequestHeaders().getFirst(name);
            auditMap.put(name, this.config.isMask() ? Mask.maskRegex(value, "requestHeader", name) : value);
        }
    }

    protected void next(HttpServerExchange exchange) throws Exception {
        Handler.next(exchange, this.next);
    }

    private void auditFields(Map<String, Object> auditInfo, Map<String, Object> auditMap) {
        for (String name : this.config.getAuditList()) {
            Object value = auditInfo.get(name);
            boolean needApplyMask = this.config.isMask() && value instanceof String;
            auditMap.put(name, needApplyMask ? Mask.maskRegex((String)value, MASK_KEY, name) : value);
        }
    }

    private void auditRequest(HttpServerExchange exchange, Map<String, Object> auditMap, AuditConfig config) {
        if (config.hasHeaderList()) {
            this.auditHeader(exchange, auditMap);
        }
        if (!config.hasAuditList()) {
            return;
        }
        Iterator<String> iterator2 = config.getAuditList().iterator();
        while (iterator2.hasNext()) {
            String key;
            switch (key = iterator2.next()) {
                case "requestBody": {
                    this.auditRequestBody(exchange, auditMap);
                    break;
                }
                case "requestCookies": {
                    this.auditRequestCookies(exchange, auditMap);
                    break;
                }
                case "queryParameters": {
                    this.auditQueryParameters(exchange, auditMap);
                    break;
                }
                case "pathParameters": {
                    this.auditPathParameters(exchange, auditMap);
                }
            }
        }
    }

    private void auditRequestBody(HttpServerExchange exchange, Map<String, Object> auditMap) {
        String requestBodyString = exchange.getAttachment(AttachmentConstants.REQUEST_BODY_STRING);
        if (requestBodyString == null && exchange.getAttachment(AttachmentConstants.REQUEST_BODY) != null) {
            try {
                requestBodyString = Config.getInstance().getMapper().writeValueAsString(exchange.getAttachment(AttachmentConstants.REQUEST_BODY));
            }
            catch (JsonProcessingException e) {
                requestBodyString = exchange.getAttachment(AttachmentConstants.REQUEST_BODY).toString();
            }
        }
        if (requestBodyString != null && requestBodyString.length() > 0) {
            String contentType = exchange.getRequestHeaders().getFirst(Headers.CONTENT_TYPE);
            if (contentType != null) {
                if (contentType.startsWith("application/json")) {
                    if (this.config.isMask()) {
                        requestBodyString = Mask.maskJson(requestBodyString, REQUEST_BODY_KEY);
                    }
                } else if (contentType.startsWith("text") || contentType.startsWith("application/xml")) {
                    if (this.config.isMask()) {
                        requestBodyString = Mask.maskString(requestBodyString, REQUEST_BODY_KEY);
                    }
                } else {
                    logger.error("Incorrect request content type " + contentType);
                }
            }
            if (requestBodyString.length() > this.config.getRequestBodyMaxSize()) {
                requestBodyString = requestBodyString.substring(0, this.config.getRequestBodyMaxSize());
            }
            auditMap.put(REQUEST_BODY_KEY, requestBodyString);
        }
    }

    private void auditResponseBody(HttpServerExchange exchange, Map<String, Object> auditMap) {
        String responseBodyString = exchange.getAttachment(AttachmentConstants.RESPONSE_BODY_STRING);
        if (responseBodyString == null && exchange.getAttachment(AttachmentConstants.RESPONSE_BODY) != null) {
            try {
                responseBodyString = Config.getInstance().getMapper().writeValueAsString(exchange.getAttachment(AttachmentConstants.RESPONSE_BODY));
            }
            catch (JsonProcessingException e) {
                responseBodyString = exchange.getAttachment(AttachmentConstants.RESPONSE_BODY).toString();
            }
        }
        if (responseBodyString != null && responseBodyString.length() > 0) {
            String contentType = exchange.getResponseHeaders().getFirst(Headers.CONTENT_TYPE);
            if (contentType != null) {
                if (contentType.startsWith("application/json")) {
                    if (this.config.isMask()) {
                        responseBodyString = Mask.maskJson(responseBodyString, RESPONSE_BODY_KEY);
                    }
                } else if (contentType.startsWith("text") || contentType.startsWith("application/xml")) {
                    if (this.config.isMask()) {
                        responseBodyString = Mask.maskString(responseBodyString, RESPONSE_BODY_KEY);
                    }
                } else {
                    logger.error("Incorrect response content type " + contentType);
                }
            }
            if (responseBodyString.length() > this.config.getResponseBodyMaxSize()) {
                responseBodyString = responseBodyString.substring(0, this.config.getResponseBodyMaxSize());
            }
            auditMap.put(RESPONSE_BODY_KEY, responseBodyString);
        }
    }

    private void auditQueryParameters(HttpServerExchange exchange, Map<String, Object> auditMap) {
        HashMap<String, String> res = new HashMap<String, String>();
        Map<String, Deque<String>> queryParameters = exchange.getQueryParameters();
        if (queryParameters != null && queryParameters.size() > 0) {
            for (String query : queryParameters.keySet()) {
                String value = queryParameters.get(query).toString();
                String mask = this.config.isMask() ? Mask.maskRegex(value, QUERY_PARAMETERS_KEY, query) : value;
                res.put(query, mask);
            }
            auditMap.put(QUERY_PARAMETERS_KEY, ((Object)res).toString());
        }
    }

    private void auditPathParameters(HttpServerExchange exchange, Map<String, Object> auditMap) {
        HashMap<String, String> res = new HashMap<String, String>();
        Map<String, Deque<String>> pathParameters = exchange.getPathParameters();
        if (pathParameters != null && pathParameters.size() > 0) {
            for (String name : pathParameters.keySet()) {
                String value = pathParameters.get(name).toString();
                String mask = this.config.isMask() ? Mask.maskRegex(value, PATH_PARAMETERS_KEY, name) : value;
                res.put(name, mask);
            }
            auditMap.put(PATH_PARAMETERS_KEY, ((Object)res).toString());
        }
    }

    private void auditRequestCookies(HttpServerExchange exchange, Map<String, Object> auditMap) {
        HashMap<String, String> res = new HashMap<String, String>();
        Iterable<Cookie> iterable = exchange.requestCookies();
        if (iterable != null) {
            for (Cookie cookie : iterable) {
                String name = cookie.getName();
                String value = cookie.getValue();
                String mask = this.config.isMask() ? Mask.maskRegex(value, REQUEST_COOKIES_KEY, name) : value;
                res.put(name, mask);
            }
            auditMap.put(REQUEST_COOKIES_KEY, ((Object)res).toString());
        }
    }

    private void auditServiceId(Map<String, Object> auditMap) {
        if (!StringUtils.isBlank(this.serviceId)) {
            auditMap.put(SERVICE_ID_KEY, this.serviceId);
        }
    }

    @Override
    public HttpHandler getNext() {
        return this.next;
    }

    @Override
    public MiddlewareHandler setNext(HttpHandler next) {
        Handlers.handlerNotNull(next);
        this.next = next;
        return this;
    }

    @Override
    public boolean isEnabled() {
        return this.config.isEnabled();
    }

    @Override
    public void register() {
        ModuleRegistry.registerModule(AuditHandler.class.getName(), this.config.getMappedConfig(), null);
    }

    @Override
    public void reload() {
        this.config.reload();
    }
}

