/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.apikey;

import com.networknt.apikey.ApiKey;
import com.networknt.apikey.ApiKeyConfig;
import com.networknt.config.Config;
import com.networknt.handler.Handler;
import com.networknt.handler.MiddlewareHandler;
import com.networknt.utility.ModuleRegistry;
import io.undertow.Handlers;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApiKeyHandler
implements MiddlewareHandler {
    static final Logger logger = LoggerFactory.getLogger(ApiKeyHandler.class);
    static final String API_KEY_MISMATCH = "ERR10075";
    ApiKeyConfig config;
    private volatile HttpHandler next;

    public ApiKeyHandler() {
        if (logger.isTraceEnabled()) {
            logger.trace("ApiKeyHandler is loaded.");
        }
        this.config = ApiKeyConfig.load();
    }

    @Deprecated
    public ApiKeyHandler(ApiKeyConfig cfg) {
        this.config = cfg;
        if (logger.isInfoEnabled()) {
            logger.info("ApiKeyHandler is loaded.");
        }
    }

    @Override
    public HttpHandler getNext() {
        return this.next;
    }

    @Override
    public MiddlewareHandler setNext(HttpHandler next) {
        Handlers.handlerNotNull(next);
        this.next = next;
        return this;
    }

    @Override
    public boolean isEnabled() {
        return this.config.isEnabled();
    }

    @Override
    public void register() {
        ArrayList<String> masks = new ArrayList<String>();
        masks.add("apiKey");
        ModuleRegistry.registerModule(ApiKeyHandler.class.getName(), Config.getInstance().getJsonMapConfigNoCache("apikey"), masks);
    }

    @Override
    public void reload() {
        this.config.reload();
        ArrayList<String> masks = new ArrayList<String>();
        masks.add("apiKey");
        ModuleRegistry.registerModule(ApiKeyHandler.class.getName(), Config.getInstance().getJsonMapConfigNoCache("apikey"), masks);
    }

    @Override
    public void handleRequest(HttpServerExchange exchange) throws Exception {
        String requestPath;
        if (logger.isDebugEnabled()) {
            logger.debug("ApiKeyHandler.handleRequest starts.");
        }
        if (this.handleApiKey(exchange, requestPath = exchange.getRequestPath())) {
            if (logger.isDebugEnabled()) {
                logger.debug("ApiKeyHandler.handleRequest ends.");
            }
            Handler.next(exchange, this.next);
        }
    }

    public boolean handleApiKey(HttpServerExchange exchange, String requestPath) {
        if (logger.isTraceEnabled()) {
            logger.trace("requestPath = " + requestPath);
        }
        if (this.config.getPathPrefixAuths() != null) {
            boolean matched = false;
            boolean found = false;
            for (ApiKey apiKey : this.config.getPathPrefixAuths()) {
                if (!requestPath.startsWith(apiKey.getPathPrefix())) continue;
                found = true;
                String k = exchange.getRequestHeaders().getFirst(apiKey.getHeaderName());
                if (!apiKey.getApiKey().equals(k)) continue;
                if (logger.isTraceEnabled()) {
                    logger.trace("Found matched apiKey with prefix = " + apiKey.getPathPrefix() + " headerName = " + apiKey.getHeaderName());
                }
                matched = true;
                break;
            }
            if (!found) {
                return true;
            }
            if (!matched) {
                logger.error("Could not find matched APIKEY for request path " + requestPath);
                this.setExchangeStatus(exchange, API_KEY_MISMATCH, requestPath);
                if (logger.isDebugEnabled()) {
                    logger.debug("ApiKeyHandler.handleRequest ends with an error.");
                }
                exchange.endExchange();
                return false;
            }
        }
        return true;
    }
}

