/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.schema.walk;

import com.networknt.schema.ExecutionContext;
import com.networknt.schema.Schema;
import com.networknt.schema.keyword.KeywordValidator;
import com.networknt.schema.path.NodePath;
import tools.jackson.databind.JsonNode;

public class WalkEvent {
    private ExecutionContext executionContext;
    private Schema schema;
    private String keyword;
    private JsonNode rootNode;
    private JsonNode instanceNode;
    private NodePath instanceLocation;
    private KeywordValidator validator;
    private NodePath evaluationPath;

    public NodePath getEvaluationPath() {
        return this.evaluationPath;
    }

    public ExecutionContext getExecutionContext() {
        return this.executionContext;
    }

    public Schema getSchema() {
        return this.schema;
    }

    public String getKeyword() {
        return this.keyword;
    }

    public JsonNode getRootNode() {
        return this.rootNode;
    }

    public JsonNode getInstanceNode() {
        return this.instanceNode;
    }

    public NodePath getInstanceLocation() {
        return this.instanceLocation;
    }

    public <T extends KeywordValidator> T getValidator() {
        return (T)this.validator;
    }

    public String toString() {
        return "WalkEvent [schemaLocation=" + String.valueOf(this.getSchema().getSchemaLocation()) + ", instanceLocation=" + String.valueOf(this.instanceLocation) + ", evaluationPath=" + String.valueOf(this.evaluationPath) + "]";
    }

    public static WalkEventBuilder builder() {
        return new WalkEventBuilder();
    }

    static class WalkEventBuilder {
        private final WalkEvent walkEvent = new WalkEvent();

        WalkEventBuilder() {
        }

        public WalkEventBuilder executionContext(ExecutionContext executionContext) {
            this.walkEvent.executionContext = executionContext;
            return this;
        }

        public WalkEventBuilder schema(Schema schema) {
            this.walkEvent.schema = schema;
            return this;
        }

        public WalkEventBuilder keyword(String keyword) {
            this.walkEvent.keyword = keyword;
            return this;
        }

        public WalkEventBuilder instanceNode(JsonNode node) {
            this.walkEvent.instanceNode = node;
            return this;
        }

        public WalkEventBuilder rootNode(JsonNode rootNode) {
            this.walkEvent.rootNode = rootNode;
            return this;
        }

        public WalkEventBuilder instanceLocation(NodePath instanceLocation) {
            this.walkEvent.instanceLocation = instanceLocation;
            return this;
        }

        public WalkEventBuilder validator(KeywordValidator validator) {
            this.walkEvent.validator = validator;
            return this;
        }

        public WalkEvent build() {
            if (this.walkEvent.executionContext != null) {
                this.walkEvent.evaluationPath = this.walkEvent.executionContext.getEvaluationPath();
            }
            return this.walkEvent;
        }
    }
}

