/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.schema.keyword;

import com.networknt.schema.ExecutionContext;
import com.networknt.schema.MessageSourceError;
import com.networknt.schema.Schema;
import com.networknt.schema.SchemaContext;
import com.networknt.schema.SchemaLocation;
import com.networknt.schema.annotation.Annotation;
import com.networknt.schema.keyword.BaseKeywordValidator;
import com.networknt.schema.keyword.KeywordType;
import com.networknt.schema.path.NodePath;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import tools.jackson.databind.JsonNode;

public class UnevaluatedPropertiesValidator
extends BaseKeywordValidator {
    private final Schema schema;

    public UnevaluatedPropertiesValidator(SchemaLocation schemaLocation, JsonNode schemaNode, Schema parentSchema, SchemaContext schemaContext) {
        super(KeywordType.UNEVALUATED_PROPERTIES, schemaNode, schemaLocation, parentSchema, schemaContext);
        if (!schemaNode.isObject() && !schemaNode.isBoolean()) {
            throw new IllegalArgumentException("The value of 'unevaluatedProperties' MUST be a valid JSON Schema.");
        }
        this.schema = schemaContext.newSchema(schemaLocation, schemaNode, parentSchema);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void validate(ExecutionContext executionContext, JsonNode node, JsonNode rootNode, NodePath instanceLocation) {
        if (!node.isObject()) {
            return;
        }
        Predicate<Annotation> validEvaluationPathFilter = a -> a.isValid();
        Predicate<Annotation> adjacentEvaluationPathFilter = a -> a.getEvaluationPath().startsWith(executionContext.getEvaluationPath().getParent());
        List instanceLocationAnnotations = executionContext.getAnnotations().asMap().getOrDefault(instanceLocation, Collections.emptyList());
        LinkedHashSet<String> evaluatedProperties = new LinkedHashSet<String>();
        LinkedHashSet existingEvaluatedProperties = new LinkedHashSet();
        List properties = instanceLocationAnnotations.stream().filter(a -> "properties".equals(a.getKeyword())).filter(adjacentEvaluationPathFilter).filter(validEvaluationPathFilter).collect(Collectors.toList());
        for (Object annotation : properties) {
            if (!(((Annotation)annotation).getValue() instanceof Set)) continue;
            Set p = (Set)((Annotation)annotation).getValue();
            existingEvaluatedProperties.addAll(p);
        }
        List patternProperties = instanceLocationAnnotations.stream().filter(a -> "patternProperties".equals(a.getKeyword())).filter(adjacentEvaluationPathFilter).filter(validEvaluationPathFilter).collect(Collectors.toList());
        for (Object annotation : patternProperties) {
            if (!(((Annotation)annotation).getValue() instanceof Set)) continue;
            Set p = (Set)((Annotation)annotation).getValue();
            existingEvaluatedProperties.addAll(p);
        }
        List additionalProperties = instanceLocationAnnotations.stream().filter(a -> "additionalProperties".equals(a.getKeyword())).filter(adjacentEvaluationPathFilter).filter(validEvaluationPathFilter).collect(Collectors.toList());
        for (Object annotation : additionalProperties) {
            if (!(((Annotation)annotation).getValue() instanceof Set)) continue;
            Set p = (Set)((Annotation)annotation).getValue();
            existingEvaluatedProperties.addAll(p);
        }
        List unevaluatedProperties = instanceLocationAnnotations.stream().filter(a -> "unevaluatedProperties".equals(a.getKeyword())).filter(adjacentEvaluationPathFilter).filter(validEvaluationPathFilter).collect(Collectors.toList());
        for (Annotation annotation : unevaluatedProperties) {
            if (!(annotation.getValue() instanceof Set)) continue;
            Set p = (Set)annotation.getValue();
            existingEvaluatedProperties.addAll(p);
        }
        boolean failFast = executionContext.isFailFast();
        try {
            executionContext.setFailFast(false);
            for (String fieldName : node.propertyNames()) {
                if (existingEvaluatedProperties.contains(fieldName)) continue;
                evaluatedProperties.add(fieldName);
                if (this.schemaNode.isBoolean() && !this.schemaNode.booleanValue()) {
                    executionContext.addError(((MessageSourceError.Builder)((MessageSourceError.Builder)((MessageSourceError.Builder)((MessageSourceError.Builder)((MessageSourceError.Builder)((MessageSourceError.Builder)this.error().instanceNode(node)).instanceLocation(instanceLocation)).property(fieldName)).evaluationPath(executionContext.getEvaluationPath())).arguments(fieldName)).locale(executionContext.getExecutionConfig().getLocale())).build());
                    continue;
                }
                this.schema.validate(executionContext, node.get(fieldName), node, instanceLocation.append(fieldName));
            }
        }
        finally {
            executionContext.setFailFast(failFast);
        }
        executionContext.getAnnotations().put(Annotation.builder().instanceLocation(instanceLocation).evaluationPath(executionContext.getEvaluationPath()).schemaLocation(this.schemaLocation).keyword(this.getKeyword()).value(evaluatedProperties).build());
    }
}

