/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.schema.keyword;

import com.networknt.schema.Error;
import com.networknt.schema.ExecutionContext;
import com.networknt.schema.MessageSourceError;
import com.networknt.schema.Schema;
import com.networknt.schema.SchemaContext;
import com.networknt.schema.SchemaLocation;
import com.networknt.schema.keyword.BaseKeywordValidator;
import com.networknt.schema.keyword.KeywordType;
import com.networknt.schema.keyword.KeywordValidator;
import com.networknt.schema.path.NodePath;
import java.util.ArrayList;
import java.util.List;
import tools.jackson.databind.JsonNode;
import tools.jackson.databind.node.StringNode;

public class PropertyNamesValidator
extends BaseKeywordValidator
implements KeywordValidator {
    private final Schema innerSchema;

    public PropertyNamesValidator(SchemaLocation schemaLocation, JsonNode schemaNode, Schema parentSchema, SchemaContext schemaContext) {
        super(KeywordType.PROPERTY_NAMES, schemaNode, schemaLocation, parentSchema, schemaContext);
        this.innerSchema = schemaContext.newSchema(schemaLocation, schemaNode, parentSchema);
    }

    @Override
    public void validate(ExecutionContext executionContext, JsonNode node, JsonNode rootNode, NodePath instanceLocation) {
        List<Error> existingErrors = executionContext.getErrors();
        ArrayList<Error> schemaErrors = new ArrayList<Error>();
        executionContext.setErrors(schemaErrors);
        for (String pname : node.propertyNames()) {
            StringNode pnameText = StringNode.valueOf((String)pname);
            this.innerSchema.validate(executionContext, (JsonNode)pnameText, node, instanceLocation.append(pname));
            for (Error schemaError : schemaErrors) {
                existingErrors.add(((MessageSourceError.Builder)((MessageSourceError.Builder)((MessageSourceError.Builder)((MessageSourceError.Builder)((MessageSourceError.Builder)((MessageSourceError.Builder)this.error().property(pname)).instanceNode(node)).instanceLocation(instanceLocation)).evaluationPath(executionContext.getEvaluationPath())).locale(executionContext.getExecutionConfig().getLocale())).arguments(pname, schemaError.getMessage())).build());
            }
            schemaErrors.clear();
        }
        executionContext.setErrors(existingErrors);
    }

    @Override
    public void preloadSchema() {
        this.innerSchema.initializeValidators();
    }
}

