/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.schema.keyword;

import com.networknt.schema.ExecutionContext;
import com.networknt.schema.MessageSourceError;
import com.networknt.schema.Schema;
import com.networknt.schema.SchemaContext;
import com.networknt.schema.SchemaLocation;
import com.networknt.schema.SchemaRef;
import com.networknt.schema.annotation.Annotation;
import com.networknt.schema.keyword.BaseKeywordValidator;
import com.networknt.schema.keyword.KeywordType;
import com.networknt.schema.path.NodePath;
import com.networknt.schema.utils.SchemaRefs;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import tools.jackson.databind.JsonNode;
import tools.jackson.databind.node.ArrayNode;

public class ItemsLegacyValidator
extends BaseKeywordValidator {
    private static final String PROPERTY_ADDITIONAL_ITEMS = "additionalItems";
    private final Schema schema;
    private final List<Schema> tupleSchema;
    private final Boolean additionalItems;
    private final Schema additionalSchema;
    private final SchemaLocation additionalItemsSchemaLocation;
    private final JsonNode additionalItemsSchemaNode;

    public ItemsLegacyValidator(SchemaLocation schemaLocation, JsonNode schemaNode, Schema parentSchema, SchemaContext schemaContext) {
        super(KeywordType.ITEMS_LEGACY, schemaNode, schemaLocation, parentSchema, schemaContext);
        Boolean additionalItems = null;
        Schema foundSchema = null;
        Schema foundAdditionalSchema = null;
        JsonNode additionalItemsSchemaNode = null;
        if (schemaNode.isObject() || schemaNode.isBoolean()) {
            foundSchema = schemaContext.newSchema(schemaLocation, schemaNode, parentSchema);
            this.tupleSchema = Collections.emptyList();
        } else {
            int i = 0;
            this.tupleSchema = new ArrayList<Schema>(schemaNode.size());
            for (JsonNode s : schemaNode) {
                this.tupleSchema.add(schemaContext.newSchema(schemaLocation.append(i), s, parentSchema));
                ++i;
            }
            JsonNode addItemNode = this.getParentSchema().getSchemaNode().get(PROPERTY_ADDITIONAL_ITEMS);
            if (addItemNode != null) {
                additionalItemsSchemaNode = addItemNode;
                if (addItemNode.isBoolean()) {
                    additionalItems = addItemNode.asBoolean();
                } else if (addItemNode.isObject()) {
                    foundAdditionalSchema = schemaContext.newSchema(parentSchema.getSchemaLocation().append(PROPERTY_ADDITIONAL_ITEMS), addItemNode, parentSchema);
                }
            }
        }
        this.additionalItems = additionalItems;
        this.schema = foundSchema;
        this.additionalSchema = foundAdditionalSchema;
        this.additionalItemsSchemaLocation = parentSchema.getSchemaLocation().append(PROPERTY_ADDITIONAL_ITEMS);
        this.additionalItemsSchemaNode = additionalItemsSchemaNode;
    }

    @Override
    public void validate(ExecutionContext executionContext, JsonNode node, JsonNode rootNode, NodePath instanceLocation) {
        if (!node.isArray() && !this.schemaContext.getSchemaRegistryConfig().isTypeLoose()) {
            return;
        }
        boolean collectAnnotations = this.hasUnevaluatedItemsInEvaluationPath(executionContext);
        if (collectAnnotations || this.collectAnnotations(executionContext)) {
            if (this.schema != null) {
                executionContext.getAnnotations().put(Annotation.builder().instanceLocation(instanceLocation).evaluationPath(executionContext.getEvaluationPath()).schemaLocation(this.schemaLocation).keyword(this.getKeyword()).value(true).build());
            } else if (this.tupleSchema != null) {
                int schemas;
                int items = node.isArray() ? node.size() : 1;
                if (items > (schemas = this.tupleSchema.size())) {
                    executionContext.getAnnotations().put(Annotation.builder().instanceLocation(instanceLocation).evaluationPath(executionContext.getEvaluationPath()).schemaLocation(this.schemaLocation).keyword(this.getKeyword()).value(schemas).build());
                } else {
                    executionContext.getAnnotations().put(Annotation.builder().instanceLocation(instanceLocation).evaluationPath(executionContext.getEvaluationPath()).schemaLocation(this.schemaLocation).keyword(this.getKeyword()).value(true).build());
                }
            }
        }
        boolean hasAdditionalItem = false;
        if (node.isArray()) {
            int i = 0;
            for (JsonNode n : node) {
                if (this.doValidate(executionContext, i, n, rootNode, instanceLocation)) {
                    hasAdditionalItem = true;
                }
                ++i;
            }
        } else if (this.doValidate(executionContext, 0, node, rootNode, instanceLocation)) {
            hasAdditionalItem = true;
        }
        if (hasAdditionalItem && (collectAnnotations || this.collectAnnotations(executionContext, PROPERTY_ADDITIONAL_ITEMS))) {
            executionContext.evaluationPathAddLast(PROPERTY_ADDITIONAL_ITEMS);
            executionContext.getAnnotations().put(Annotation.builder().instanceLocation(instanceLocation).evaluationPath(executionContext.getEvaluationPath()).schemaLocation(this.additionalItemsSchemaLocation).keyword(PROPERTY_ADDITIONAL_ITEMS).value(true).build());
            executionContext.evaluationPathRemoveLast();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean doValidate(ExecutionContext executionContext, int i, JsonNode node, JsonNode rootNode, NodePath instanceLocation) {
        boolean isAdditionalItem = false;
        NodePath path = instanceLocation.append(i);
        if (this.schema != null) {
            this.schema.validate(executionContext, node, rootNode, path);
        } else if (this.tupleSchema != null) {
            if (i < this.tupleSchema.size()) {
                executionContext.evaluationPathAddLast(i);
                try {
                    this.tupleSchema.get(i).validate(executionContext, node, rootNode, path);
                }
                finally {
                    executionContext.evaluationPathRemoveLast();
                }
            }
            if (this.additionalItems != null && this.additionalItems.booleanValue() || this.additionalSchema != null) {
                isAdditionalItem = true;
            }
            if (this.additionalSchema != null) {
                executionContext.evaluationPathRemoveLast();
                executionContext.evaluationPathAddLast(PROPERTY_ADDITIONAL_ITEMS);
                try {
                    this.additionalSchema.validate(executionContext, node, rootNode, path);
                }
                finally {
                    executionContext.evaluationPathRemoveLast();
                    executionContext.evaluationPathAddLast("items");
                }
            }
            if (this.additionalItems != null && !this.additionalItems.booleanValue()) {
                executionContext.evaluationPathRemoveLast();
                executionContext.evaluationPathAddLast(PROPERTY_ADDITIONAL_ITEMS);
                try {
                    executionContext.addError(((MessageSourceError.Builder)((MessageSourceError.Builder)((MessageSourceError.Builder)((MessageSourceError.Builder)((MessageSourceError.Builder)((MessageSourceError.Builder)((MessageSourceError.Builder)((MessageSourceError.Builder)((MessageSourceError.Builder)((MessageSourceError.Builder)this.error().instanceNode(rootNode)).instanceLocation(instanceLocation)).keyword(PROPERTY_ADDITIONAL_ITEMS)).messageKey(PROPERTY_ADDITIONAL_ITEMS)).evaluationPath(executionContext.getEvaluationPath())).schemaLocation(this.additionalItemsSchemaLocation)).schemaNode(this.additionalItemsSchemaNode)).locale(executionContext.getExecutionConfig().getLocale())).index(i)).arguments(i)).build());
                }
                finally {
                    executionContext.evaluationPathRemoveLast();
                    executionContext.evaluationPathAddLast("items");
                }
            }
        }
        return isAdditionalItem;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void walk(ExecutionContext executionContext, JsonNode node, JsonNode rootNode, NodePath instanceLocation, boolean shouldValidateSchema) {
        boolean collectAnnotations = this.hasUnevaluatedItemsInEvaluationPath(executionContext);
        if (collectAnnotations || this.collectAnnotations(executionContext)) {
            if (this.schema != null) {
                executionContext.getAnnotations().put(Annotation.builder().instanceLocation(instanceLocation).evaluationPath(executionContext.getEvaluationPath()).schemaLocation(this.schemaLocation).keyword(this.getKeyword()).value(true).build());
            } else if (this.tupleSchema != null) {
                int schemas;
                int items = node.isArray() ? node.size() : 1;
                if (items > (schemas = this.tupleSchema.size())) {
                    executionContext.getAnnotations().put(Annotation.builder().instanceLocation(instanceLocation).evaluationPath(executionContext.getEvaluationPath()).schemaLocation(this.schemaLocation).keyword(this.getKeyword()).value(schemas).build());
                } else {
                    executionContext.getAnnotations().put(Annotation.builder().instanceLocation(instanceLocation).evaluationPath(executionContext.getEvaluationPath()).schemaLocation(this.schemaLocation).keyword(this.getKeyword()).value(true).build());
                }
            }
        }
        if (this.schema != null) {
            if (node instanceof ArrayNode) {
                int count = Math.max(1, node.size());
                ArrayNode arrayNode = (ArrayNode)node;
                JsonNode defaultNode = null;
                if (executionContext.getWalkConfig().getApplyDefaultsStrategy().shouldApplyArrayDefaults()) {
                    defaultNode = ItemsLegacyValidator.getDefaultNode(this.schema, executionContext);
                }
                for (int i = 0; i < count; ++i) {
                    JsonNode n = arrayNode.get(i);
                    if (n != null && n.isNull() && defaultNode != null) {
                        arrayNode.set(i, defaultNode);
                        n = defaultNode;
                    }
                    this.walkSchema(executionContext, this.schema, n, rootNode, instanceLocation.append(i), shouldValidateSchema, KeywordType.ITEMS_LEGACY.getValue());
                }
            } else {
                this.walkSchema(executionContext, this.schema, null, rootNode, instanceLocation.append(0), shouldValidateSchema, KeywordType.ITEMS_LEGACY.getValue());
            }
        } else if (this.tupleSchema != null) {
            int prefixItems = this.tupleSchema.size();
            for (int i = 0; i < prefixItems; ++i) {
                if (node instanceof ArrayNode) {
                    ArrayNode arrayNode = (ArrayNode)node;
                    JsonNode defaultNode = null;
                    JsonNode n = arrayNode.get(i);
                    if (executionContext.getWalkConfig().getApplyDefaultsStrategy().shouldApplyArrayDefaults()) {
                        defaultNode = ItemsLegacyValidator.getDefaultNode(this.tupleSchema.get(i), executionContext);
                    }
                    if (n != null && n.isNull() && defaultNode != null) {
                        arrayNode.set(i, defaultNode);
                        n = defaultNode;
                    }
                    executionContext.evaluationPathAddLast(i);
                    try {
                        this.walkSchema(executionContext, this.tupleSchema.get(i), n, rootNode, instanceLocation.append(i), shouldValidateSchema, KeywordType.ITEMS_LEGACY.getValue());
                        continue;
                    }
                    finally {
                        executionContext.evaluationPathRemoveLast();
                    }
                }
                executionContext.evaluationPathAddLast(i);
                try {
                    this.walkSchema(executionContext, this.tupleSchema.get(i), null, rootNode, instanceLocation.append(i), shouldValidateSchema, KeywordType.ITEMS_LEGACY.getValue());
                    continue;
                }
                finally {
                    executionContext.evaluationPathRemoveLast();
                }
            }
            if (this.additionalSchema != null) {
                boolean hasAdditionalItem = false;
                int additionalItems = Math.max(1, (node != null ? node.size() : 0) - prefixItems);
                for (int x = 0; x < additionalItems; ++x) {
                    int i = x + prefixItems;
                    if (node instanceof ArrayNode) {
                        ArrayNode arrayNode = (ArrayNode)node;
                        JsonNode defaultNode = null;
                        JsonNode n = arrayNode.get(i);
                        if (executionContext.getWalkConfig().getApplyDefaultsStrategy().shouldApplyArrayDefaults()) {
                            defaultNode = ItemsLegacyValidator.getDefaultNode(this.additionalSchema, executionContext);
                        }
                        if (n != null && n.isNull() && defaultNode != null) {
                            arrayNode.set(i, defaultNode);
                            n = defaultNode;
                        }
                        this.walkSchema(executionContext, this.additionalSchema, n, rootNode, instanceLocation.append(i), shouldValidateSchema, PROPERTY_ADDITIONAL_ITEMS);
                        if (n == null) continue;
                        hasAdditionalItem = true;
                        continue;
                    }
                    this.walkSchema(executionContext, this.additionalSchema, null, rootNode, instanceLocation.append(i), shouldValidateSchema, PROPERTY_ADDITIONAL_ITEMS);
                }
                if (hasAdditionalItem && (collectAnnotations || this.collectAnnotations(executionContext, PROPERTY_ADDITIONAL_ITEMS))) {
                    executionContext.evaluationPathAddLast(PROPERTY_ADDITIONAL_ITEMS);
                    executionContext.getAnnotations().put(Annotation.builder().instanceLocation(instanceLocation).evaluationPath(executionContext.getEvaluationPath()).schemaLocation(this.additionalItemsSchemaLocation).keyword(PROPERTY_ADDITIONAL_ITEMS).value(true).build());
                    executionContext.evaluationPathRemoveLast();
                }
            }
        }
    }

    private static JsonNode getDefaultNode(Schema schema, ExecutionContext executionContext) {
        SchemaRef schemaRef;
        JsonNode result = schema.getSchemaNode().get("default");
        if (result == null && (schemaRef = SchemaRefs.from(schema, executionContext)) != null) {
            result = ItemsLegacyValidator.getDefaultNode(schemaRef.getSchema(), executionContext);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void walkSchema(ExecutionContext executionContext, Schema walkSchema, JsonNode node, JsonNode rootNode, NodePath instanceLocation, boolean shouldValidateSchema, String keyword) {
        boolean additionalItems = PROPERTY_ADDITIONAL_ITEMS.equals(keyword);
        if (additionalItems) {
            executionContext.evaluationPathRemoveLast();
            executionContext.evaluationPathAddLast(keyword);
        }
        try {
            boolean executeWalk = executionContext.getWalkConfig().getItemWalkHandler().preWalk(executionContext, keyword, node, rootNode, instanceLocation, walkSchema, this);
            int currentErrors = executionContext.getErrors().size();
            if (executeWalk) {
                walkSchema.walk(executionContext, node, rootNode, instanceLocation, shouldValidateSchema);
            }
            executionContext.getWalkConfig().getItemWalkHandler().postWalk(executionContext, keyword, node, rootNode, instanceLocation, walkSchema, this, executionContext.getErrors().subList(currentErrors, executionContext.getErrors().size()));
        }
        finally {
            if (additionalItems) {
                executionContext.evaluationPathRemoveLast();
                executionContext.evaluationPathAddLast("items");
            }
        }
    }

    public List<Schema> getTupleSchema() {
        return this.tupleSchema;
    }

    public Schema getSchema() {
        return this.schema;
    }

    @Override
    public void preloadSchema() {
        if (null != this.schema) {
            this.schema.initializeValidators();
        }
        this.preloadSchemas(this.tupleSchema);
        if (null != this.additionalSchema) {
            this.additionalSchema.initializeValidators();
        }
    }
}

