/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.schema.keyword;

import com.networknt.schema.ExecutionContext;
import com.networknt.schema.MessageSourceError;
import com.networknt.schema.Schema;
import com.networknt.schema.SchemaContext;
import com.networknt.schema.SchemaLocation;
import com.networknt.schema.format.BaseFormatValidator;
import com.networknt.schema.format.Format;
import com.networknt.schema.keyword.Keyword;
import com.networknt.schema.keyword.KeywordValidator;
import com.networknt.schema.path.NodePath;
import java.util.regex.PatternSyntaxException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tools.jackson.databind.JsonNode;

public class FormatValidator
extends BaseFormatValidator
implements KeywordValidator {
    private static final Logger logger = LoggerFactory.getLogger(FormatValidator.class);
    private final Format format;

    public FormatValidator(SchemaLocation schemaLocation, JsonNode schemaNode, Schema parentSchema, SchemaContext schemaContext, Format format, Keyword keyword) {
        super(schemaLocation, schemaNode, parentSchema, keyword, schemaContext);
        this.format = format;
    }

    protected Object getAnnotationValue() {
        if (this.format != null) {
            return this.format.getName();
        }
        return this.schemaNode.isString() ? this.schemaNode.asString() : null;
    }

    @Override
    public void validate(ExecutionContext executionContext, JsonNode node, JsonNode rootNode, NodePath instanceLocation) {
        Object annotationValue;
        if (this.collectAnnotations(executionContext) && (annotationValue = this.getAnnotationValue()) != null) {
            this.putAnnotation(executionContext, annotation -> annotation.instanceLocation(instanceLocation).value(annotationValue));
        }
        boolean assertionsEnabled = this.isAssertionsEnabled(executionContext);
        if (this.format != null) {
            try {
                this.format.validate(executionContext, this.schemaContext, node, rootNode, instanceLocation, assertionsEnabled, () -> (MessageSourceError.Builder)((MessageSourceError.Builder)((MessageSourceError.Builder)((MessageSourceError.Builder)((MessageSourceError.Builder)this.error().instanceNode(node)).instanceLocation(instanceLocation)).evaluationPath(executionContext.getEvaluationPath())).messageKey(this.format.getMessageKey())).locale(executionContext.getExecutionConfig().getLocale()), this);
            }
            catch (PatternSyntaxException pse) {
                logger.error("Failed to apply pattern on {}: Invalid RE syntax [{}]", new Object[]{instanceLocation, this.format.getName(), pse});
            }
        } else {
            this.validateUnknownFormat(executionContext, node, rootNode, instanceLocation);
        }
    }

    protected void validateUnknownFormat(ExecutionContext executionContext, JsonNode node, JsonNode rootNode, NodePath instanceLocation) {
        if (this.createUnknownFormatAssertions(executionContext) && this.schemaNode.isString()) {
            executionContext.addError(((MessageSourceError.Builder)((MessageSourceError.Builder)((MessageSourceError.Builder)((MessageSourceError.Builder)((MessageSourceError.Builder)this.error().instanceLocation(instanceLocation)).instanceNode(node)).evaluationPath(executionContext.getEvaluationPath())).messageKey("format.unknown")).arguments(this.schemaNode.asString())).build());
        }
    }

    protected boolean createUnknownFormatAssertions(ExecutionContext executionContext) {
        return this.isAssertionsEnabled(executionContext) && this.isStrict(executionContext) || this.isFormatAssertionVocabularyEnabled();
    }

    protected boolean isStrict(ExecutionContext executionContext) {
        return this.schemaContext.getSchemaRegistryConfig().isStrict(this.getKeyword(), Boolean.FALSE);
    }
}

