/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.schema.dialect;

import com.networknt.schema.Error;
import com.networknt.schema.InvalidSchemaException;
import com.networknt.schema.Schema;
import com.networknt.schema.SchemaLocation;
import com.networknt.schema.SchemaRegistry;
import com.networknt.schema.SpecificationVersion;
import com.networknt.schema.dialect.Dialect;
import com.networknt.schema.dialect.DialectRegistry;
import java.util.Map;
import tools.jackson.databind.JsonNode;

public abstract class AbstractDialectRegistry
implements DialectRegistry {
    protected Dialect loadDialect(String iri, SchemaRegistry schemaFactory) {
        try {
            Dialect result = this.loadDialectBuilder(iri, schemaFactory).build();
            return result;
        }
        catch (InvalidSchemaException e) {
            throw e;
        }
        catch (Exception e) {
            Error error = ((Error.Builder)((Error.Builder)Error.builder().message("Failed to load dialect ''{0}''")).arguments(iri)).build();
            throw new InvalidSchemaException(error, e);
        }
    }

    protected Dialect.Builder loadDialectBuilder(String iri, SchemaRegistry schemaFactory) {
        JsonNode vocabulary;
        Schema schema = schemaFactory.getSchema(SchemaLocation.of(iri));
        Dialect.Builder builder = Dialect.builder(iri, schema.getSchemaContext().getDialect());
        SpecificationVersion specification = schema.getSchemaContext().getDialect().getSpecificationVersion();
        if (specification != null && specification.getOrder() >= SpecificationVersion.DRAFT_2019_09.getOrder() && (vocabulary = schema.getSchemaNode().get("$vocabulary")) != null) {
            builder.vocabularies(Map::clear);
            for (Map.Entry vocabs : vocabulary.properties()) {
                builder.vocabulary((String)vocabs.getKey(), ((JsonNode)vocabs.getValue()).booleanValue());
            }
        }
        return builder;
    }
}

