/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.schema.annotation;

import com.networknt.schema.annotation.Annotation;
import com.networknt.schema.path.NodePath;
import com.networknt.schema.serialization.JsonMapperFactory;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import tools.jackson.core.JacksonException;

public class Annotations {
    private final Map<NodePath, List<Annotation>> values = new LinkedHashMap<NodePath, List<Annotation>>();

    public Map<NodePath, List<Annotation>> asMap() {
        return this.values;
    }

    public void put(Annotation annotation) {
        this.values.computeIfAbsent(annotation.getInstanceLocation(), k -> new ArrayList()).add(annotation);
    }

    public String toString() {
        return Formatter.format(this.values);
    }

    public static class Formatter {
        public static String format(Map<NodePath, List<Annotation>> annotations) {
            LinkedHashMap<String, Map> results = new LinkedHashMap<String, Map>();
            for (List<Annotation> list : annotations.values()) {
                for (Annotation annotation : list) {
                    String keyword = annotation.getKeyword();
                    String instancePath = annotation.getInstanceLocation().toString();
                    String evaluationPath = annotation.getEvaluationPath().toString();
                    Map values = results.computeIfAbsent(instancePath, key -> new LinkedHashMap()).computeIfAbsent(keyword, key -> new LinkedHashMap());
                    values.put(evaluationPath, annotation.getValue());
                }
            }
            try {
                return JsonMapperFactory.getInstance().writerWithDefaultPrettyPrinter().writeValueAsString(results);
            }
            catch (JacksonException e) {
                return "";
            }
        }
    }
}

