/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.schema;

import com.networknt.schema.utils.Strings;
import java.util.Objects;

public class AbsoluteIri {
    private final String value;

    public AbsoluteIri(String value) {
        this.value = value;
    }

    public static AbsoluteIri of(String iri) {
        return new AbsoluteIri(iri);
    }

    public AbsoluteIri resolve(String iri) {
        return new AbsoluteIri(AbsoluteIri.resolve(this.value, iri));
    }

    public String getScheme() {
        return AbsoluteIri.getScheme(this.value);
    }

    protected String getSchemeAuthority() {
        return AbsoluteIri.getSchemeAuthority(this.value);
    }

    private static boolean isAbsoluteIri(String iri) {
        int length = iri.length();
        for (int x = 0; x < length; ++x) {
            char ch = iri.charAt(x);
            if (ch == ':') {
                return true;
            }
            if (ch != '/' && ch != '?' && ch != '#') continue;
            return false;
        }
        return false;
    }

    public static String resolve(String parent, String iri) {
        if (AbsoluteIri.isAbsoluteIri(iri)) {
            return iri;
        }
        if (parent == null) {
            return iri;
        }
        if (iri.startsWith("/")) {
            return AbsoluteIri.getSchemeAuthority(parent) + iri;
        }
        Object base = parent;
        int scheme = parent.indexOf("://");
        if (scheme == -1) {
            scheme = parent.indexOf(58);
            if (scheme == -1) {
                scheme = 0;
            }
        } else {
            scheme += 3;
        }
        base = AbsoluteIri.parent((String)base, scheme);
        String[] iriParts = Strings.split(iri, '/');
        for (int x = 0; x < iriParts.length; ++x) {
            if ("..".equals(iriParts[x])) {
                base = AbsoluteIri.parent((String)base, scheme);
                continue;
            }
            if (".".equals(iriParts[x])) continue;
            if (((String)base).endsWith(":")) {
                if (parent.length() > ((String)base).length() && parent.charAt(((String)base).length()) == '/') {
                    base = (String)base + "/" + iriParts[x];
                    continue;
                }
                base = (String)base + iriParts[x];
                continue;
            }
            base = (String)base + "/" + iriParts[x];
        }
        return base;
    }

    protected static String parent(String iri, int scheme) {
        int slash = iri.lastIndexOf(47);
        if (slash == -1 && (slash = iri.lastIndexOf(58)) != -1) {
            ++slash;
        }
        if (slash != -1 && slash > scheme) {
            return iri.substring(0, slash);
        }
        return iri;
    }

    protected static String getSchemeAuthority(String iri) {
        if (iri == null) {
            return "";
        }
        int start = iri.indexOf("://");
        start = start == -1 ? 0 : (start += 3);
        int end = iri.indexOf(47, start);
        return end != -1 ? iri.substring(0, end) : iri;
    }

    public static String getScheme(String iri) {
        if (iri == null) {
            return "";
        }
        int start = iri.indexOf(58);
        if (start == -1) {
            return "";
        }
        return iri.substring(0, start);
    }

    public String toString() {
        return this.value;
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AbsoluteIri other = (AbsoluteIri)obj;
        return Objects.equals(this.value, other.value);
    }
}

