/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.schema;

import com.fasterxml.jackson.databind.JsonNode;
import com.networknt.schema.CustomErrorMessageType;
import com.networknt.schema.ErrorMessageType;
import com.networknt.schema.FailFastAssertionException;
import com.networknt.schema.JsonNodePath;
import com.networknt.schema.JsonSchema;
import com.networknt.schema.Keyword;
import com.networknt.schema.MessageSourceValidationMessage;
import com.networknt.schema.SchemaLocation;
import com.networknt.schema.ValidationMessage;
import com.networknt.schema.i18n.MessageSource;
import com.networknt.schema.utils.StringUtils;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;

public abstract class ValidationMessageHandler {
    protected final ErrorMessageType errorMessageType;
    protected final String errorMessageKeyword;
    protected final MessageSource messageSource;
    protected final Keyword keyword;
    protected final JsonSchema parentSchema;
    protected final SchemaLocation schemaLocation;
    protected final JsonNodePath evaluationPath;
    protected final JsonSchema evaluationParentSchema;
    protected final Map<String, String> errorMessage;

    protected ValidationMessageHandler(ErrorMessageType errorMessageType, String errorMessageKeyword, MessageSource messageSource, Keyword keyword, JsonSchema parentSchema, SchemaLocation schemaLocation, JsonNodePath evaluationPath) {
        ErrorMessageType currentErrorMessageType = errorMessageType;
        this.messageSource = messageSource;
        this.schemaLocation = Objects.requireNonNull(schemaLocation);
        this.evaluationPath = Objects.requireNonNull(evaluationPath);
        this.parentSchema = parentSchema;
        this.evaluationParentSchema = null;
        this.errorMessageKeyword = errorMessageKeyword;
        this.keyword = keyword;
        Map<String, String> currentErrorMessage = null;
        if (this.keyword != null) {
            String errorCodeText;
            JsonNode errorCodeNode;
            String errorCodeKey;
            if (this.errorMessageKeyword != null && keyword != null && parentSchema != null) {
                currentErrorMessage = this.getErrorMessage(this.errorMessageKeyword, parentSchema.getSchemaNode(), keyword.getValue());
            }
            if ((errorCodeKey = this.getErrorCodeKey(keyword.getValue())) != null && this.parentSchema != null && (errorCodeNode = this.parentSchema.getSchemaNode().get(errorCodeKey)) != null && errorCodeNode.isTextual() && StringUtils.isNotBlank(errorCodeText = errorCodeNode.asText())) {
                currentErrorMessageType = CustomErrorMessageType.of(errorCodeText);
            }
        }
        this.errorMessageType = currentErrorMessageType;
        this.errorMessage = currentErrorMessage;
    }

    protected ValidationMessageHandler(ErrorMessageType errorMessageType, String errorMessageKeyword, MessageSource messageSource, Keyword keyword, JsonSchema parentSchema, SchemaLocation schemaLocation, JsonNodePath evaluationPath, JsonSchema evaluationParentSchema, Map<String, String> errorMessage) {
        this.errorMessageType = errorMessageType;
        this.errorMessageKeyword = errorMessageKeyword;
        this.messageSource = messageSource;
        this.keyword = keyword;
        this.parentSchema = parentSchema;
        this.schemaLocation = schemaLocation;
        this.evaluationPath = evaluationPath;
        this.evaluationParentSchema = evaluationParentSchema;
        this.errorMessage = errorMessage;
    }

    protected MessageSourceValidationMessage.Builder message() {
        return (MessageSourceValidationMessage.Builder)((MessageSourceValidationMessage.Builder)((MessageSourceValidationMessage.Builder)((MessageSourceValidationMessage.Builder)((MessageSourceValidationMessage.Builder)MessageSourceValidationMessage.builder(this.messageSource, this.errorMessage, (message, failFast) -> {
            if (failFast.booleanValue()) {
                throw new FailFastAssertionException((ValidationMessage)message);
            }
        }).code(this.getErrorMessageType().getErrorCode())).schemaLocation(this.schemaLocation)).evaluationPath(this.evaluationPath)).type(this.keyword != null ? this.keyword.getValue() : null)).messageKey(this.getErrorMessageType().getErrorCodeValue());
    }

    protected ErrorMessageType getErrorMessageType() {
        return this.errorMessageType;
    }

    protected Map<String, String> getErrorMessage(String errorMessageKeyword, JsonNode schemaNode, String keyword) {
        JsonNode messageNode;
        JsonSchema parentSchema = this.parentSchema;
        JsonNode message = this.getMessageNode(errorMessageKeyword, schemaNode, parentSchema, keyword);
        if (message != null && (messageNode = message.get(keyword)) != null) {
            if (messageNode.isTextual()) {
                return Collections.singletonMap("", messageNode.asText());
            }
            if (messageNode.isObject()) {
                LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
                messageNode.fields().forEachRemaining(entry -> result.put((String)entry.getKey(), ((JsonNode)entry.getValue()).textValue()));
                if (!result.isEmpty()) {
                    return result;
                }
            }
        }
        return Collections.emptyMap();
    }

    protected JsonNode getMessageNode(String errorMessageKeyword, JsonNode schemaNode, JsonSchema parentSchema, String pname) {
        if (schemaNode.get(errorMessageKeyword) != null && schemaNode.get(errorMessageKeyword).get(pname) != null) {
            return schemaNode.get(errorMessageKeyword);
        }
        JsonNode messageNode = schemaNode.get(errorMessageKeyword);
        if (messageNode == null && parentSchema != null && (messageNode = parentSchema.schemaNode.get(errorMessageKeyword)) == null) {
            return this.getMessageNode(errorMessageKeyword, parentSchema.schemaNode, parentSchema.getParentSchema(), pname);
        }
        return messageNode;
    }

    protected String getErrorCodeKey(String keyword) {
        if (keyword != null) {
            return keyword + "ErrorCode";
        }
        return null;
    }
}

