/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.schema.format;

import com.ethlo.time.ITU;
import com.ethlo.time.LeapSecondException;
import com.fasterxml.jackson.databind.JsonNode;
import com.networknt.schema.ExecutionContext;
import com.networknt.schema.JsonNodePath;
import com.networknt.schema.JsonSchema;
import com.networknt.schema.JsonType;
import com.networknt.schema.MessageSourceValidationMessage;
import com.networknt.schema.SchemaLocation;
import com.networknt.schema.TypeFactory;
import com.networknt.schema.ValidationContext;
import com.networknt.schema.ValidationMessage;
import com.networknt.schema.ValidatorTypeCode;
import com.networknt.schema.format.BaseFormatJsonValidator;
import java.util.Collections;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DateTimeValidator
extends BaseFormatJsonValidator {
    private static final Logger logger = LoggerFactory.getLogger(DateTimeValidator.class);
    private static final String DATETIME = "date-time";

    public DateTimeValidator(SchemaLocation schemaLocation, JsonNodePath evaluationPath, JsonNode schemaNode, JsonSchema parentSchema, ValidationContext validationContext, ValidatorTypeCode type) {
        super(schemaLocation, evaluationPath, schemaNode, parentSchema, type, validationContext);
    }

    @Override
    public Set<ValidationMessage> validate(ExecutionContext executionContext, JsonNode node, JsonNode rootNode, JsonNodePath instanceLocation) {
        JsonType nodeType;
        DateTimeValidator.debug(logger, node, rootNode, instanceLocation);
        if (this.collectAnnotations(executionContext, "format")) {
            this.putAnnotation(executionContext, annotation -> annotation.instanceLocation(instanceLocation).keyword("format").value(DATETIME));
        }
        if ((nodeType = TypeFactory.getValueNodeType(node, this.validationContext.getConfig())) != JsonType.STRING) {
            return Collections.emptySet();
        }
        boolean assertionsEnabled = this.isAssertionsEnabled(executionContext);
        if (!DateTimeValidator.isLegalDateTime(node.textValue()) && assertionsEnabled) {
            return Collections.singleton(((MessageSourceValidationMessage.Builder)((MessageSourceValidationMessage.Builder)((MessageSourceValidationMessage.Builder)((MessageSourceValidationMessage.Builder)((MessageSourceValidationMessage.Builder)((MessageSourceValidationMessage.Builder)this.message().instanceNode(node)).instanceLocation(instanceLocation)).type("format")).locale(executionContext.getExecutionConfig().getLocale())).failFast(executionContext.getExecutionConfig().isFailFast())).arguments(node.textValue(), DATETIME)).build());
        }
        return Collections.emptySet();
    }

    private static boolean isLegalDateTime(String string) {
        try {
            block4: {
                try {
                    ITU.parseDateTime((String)string);
                }
                catch (LeapSecondException ex) {
                    if (ex.isVerifiedValidLeapYearMonth()) break block4;
                    return false;
                }
            }
            return true;
        }
        catch (Exception ex) {
            logger.debug("Invalid {}: {}", (Object)DATETIME, (Object)ex.getMessage());
            return false;
        }
    }
}

