/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.schema;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.DecimalNode;
import com.fasterxml.jackson.databind.node.NullNode;
import com.networknt.schema.BaseJsonValidator;
import com.networknt.schema.ExecutionContext;
import com.networknt.schema.JsonNodePath;
import com.networknt.schema.JsonSchema;
import com.networknt.schema.JsonType;
import com.networknt.schema.JsonValidator;
import com.networknt.schema.MessageSourceValidationMessage;
import com.networknt.schema.SchemaLocation;
import com.networknt.schema.TypeFactory;
import com.networknt.schema.ValidationContext;
import com.networknt.schema.ValidationMessage;
import com.networknt.schema.ValidatorTypeCode;
import java.math.BigDecimal;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EnumValidator
extends BaseJsonValidator
implements JsonValidator {
    private static final Logger logger = LoggerFactory.getLogger(EnumValidator.class);
    private final Set<JsonNode> nodes;
    private final String error;

    public EnumValidator(SchemaLocation schemaLocation, JsonNodePath evaluationPath, JsonNode schemaNode, JsonSchema parentSchema, ValidationContext validationContext) {
        super(schemaLocation, evaluationPath, schemaNode, parentSchema, ValidatorTypeCode.ENUM, validationContext);
        if (schemaNode != null && schemaNode.isArray()) {
            JsonNode nullable;
            this.nodes = new HashSet<JsonNode>();
            StringBuilder sb = new StringBuilder();
            sb.append('[');
            String separator = "";
            for (JsonNode n : schemaNode) {
                if (n.isNumber()) {
                    this.nodes.add(this.processNumberNode(n));
                } else if (n.isArray()) {
                    ArrayNode a = this.processArrayNode((ArrayNode)n);
                    this.nodes.add((JsonNode)a);
                } else {
                    this.nodes.add(n);
                }
                sb.append(separator);
                sb.append(n.asText());
                separator = ", ";
            }
            if (validationContext.getConfig().isHandleNullableField() && (nullable = parentSchema.getSchemaNode().get("nullable")) != null && nullable.asBoolean()) {
                this.nodes.add((JsonNode)NullNode.getInstance());
                separator = ", ";
                sb.append(separator);
                sb.append("null");
            }
            sb.append(']');
            this.error = sb.toString();
        } else {
            this.nodes = Collections.emptySet();
            this.error = "[none]";
        }
    }

    @Override
    public Set<ValidationMessage> validate(ExecutionContext executionContext, JsonNode node, JsonNode rootNode, JsonNodePath instanceLocation) {
        EnumValidator.debug(logger, node, rootNode, instanceLocation);
        if (node.isNumber()) {
            node = this.processNumberNode(node);
        } else if (node.isArray()) {
            node = this.processArrayNode((ArrayNode)node);
        }
        if (!(this.nodes.contains(node) || this.validationContext.getConfig().isTypeLoose() && this.isTypeLooseContainsInEnum(node))) {
            return Collections.singleton(((MessageSourceValidationMessage.Builder)((MessageSourceValidationMessage.Builder)((MessageSourceValidationMessage.Builder)((MessageSourceValidationMessage.Builder)((MessageSourceValidationMessage.Builder)this.message().instanceNode(node)).instanceLocation(instanceLocation)).locale(executionContext.getExecutionConfig().getLocale())).failFast(executionContext.getExecutionConfig().isFailFast())).arguments(this.error)).build());
        }
        return Collections.emptySet();
    }

    private boolean isTypeLooseContainsInEnum(JsonNode node) {
        if (TypeFactory.getValueNodeType(node, this.validationContext.getConfig()) == JsonType.STRING) {
            String nodeText = node.textValue();
            for (JsonNode n : this.nodes) {
                String value = n.asText();
                if (value == null || !value.equals(nodeText)) continue;
                return true;
            }
        }
        return false;
    }

    protected JsonNode processNumberNode(JsonNode n) {
        return DecimalNode.valueOf((BigDecimal)new BigDecimal(n.decimalValue().toPlainString()));
    }

    protected ArrayNode processArrayNode(ArrayNode node) {
        if (!this.hasNumber(node)) {
            return node;
        }
        ArrayNode a = node.deepCopy();
        for (int x = 0; x < a.size(); ++x) {
            JsonNode v = a.get(x);
            if (!v.isNumber()) continue;
            v = this.processNumberNode(v);
            a.set(x, v);
        }
        return a;
    }

    protected boolean hasNumber(ArrayNode node) {
        for (int x = 0; x < node.size(); ++x) {
            JsonNode v = node.get(x);
            if (!v.isNumber()) continue;
            return true;
        }
        return false;
    }
}

