/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.schema;

import java.util.Objects;

public class AbsoluteIri {
    private final String value;

    public AbsoluteIri(String value) {
        this.value = value;
    }

    public static AbsoluteIri of(String iri) {
        return new AbsoluteIri(iri);
    }

    public AbsoluteIri resolve(String iri) {
        return new AbsoluteIri(AbsoluteIri.resolve(this.value, iri));
    }

    public String getScheme() {
        return AbsoluteIri.getScheme(this.value);
    }

    protected String getSchemeAuthority() {
        return AbsoluteIri.getSchemeAuthority(this.value);
    }

    public static String resolve(String parent, String iri) {
        if (iri.contains(":")) {
            return iri;
        }
        if (parent == null) {
            return iri;
        }
        if (iri.startsWith("/")) {
            return AbsoluteIri.getSchemeAuthority(parent) + iri;
        }
        String base = parent;
        int scheme = parent.indexOf("://");
        scheme = scheme == -1 ? 0 : (scheme += 3);
        base = AbsoluteIri.parent(base, scheme);
        while (iri.startsWith("../")) {
            base = AbsoluteIri.parent(base, scheme);
            iri = iri.substring(3);
        }
        return base + "/" + iri;
    }

    protected static String parent(String iri, int scheme) {
        int slash = iri.lastIndexOf(47);
        if (slash != -1 && slash > scheme) {
            return iri.substring(0, slash);
        }
        return iri;
    }

    protected static String getSchemeAuthority(String iri) {
        if (iri == null) {
            return "";
        }
        int start = iri.indexOf("://");
        start = start == -1 ? 0 : (start += 3);
        int end = iri.indexOf(47, start);
        return end != -1 ? iri.substring(0, end) : iri;
    }

    public static String getScheme(String iri) {
        if (iri == null) {
            return "";
        }
        int start = iri.indexOf(":");
        if (start == -1) {
            return "";
        }
        return iri.substring(0, start);
    }

    public String toString() {
        return this.value;
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AbsoluteIri other = (AbsoluteIri)obj;
        return Objects.equals(this.value, other.value);
    }
}

