/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.schema;

import com.networknt.schema.JsonNodePath;
import com.networknt.schema.SchemaLocation;
import com.networknt.schema.i18n.MessageFormatter;
import com.networknt.schema.utils.CachingSupplier;
import com.networknt.schema.utils.StringUtils;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Map;
import java.util.function.Supplier;

public class ValidationMessage {
    private final String type;
    private final String code;
    private final JsonNodePath evaluationPath;
    private final SchemaLocation schemaLocation;
    private final JsonNodePath instanceLocation;
    private final String property;
    private final Object[] arguments;
    private final Map<String, Object> details;
    private final String messageKey;
    private final Supplier<String> messageSupplier;

    ValidationMessage(String type, String code, JsonNodePath evaluationPath, SchemaLocation schemaLocation, JsonNodePath instanceLocation, String property, Object[] arguments, Map<String, Object> details, String messageKey, Supplier<String> messageSupplier) {
        this.type = type;
        this.code = code;
        this.instanceLocation = instanceLocation;
        this.schemaLocation = schemaLocation;
        this.evaluationPath = evaluationPath;
        this.property = property;
        this.arguments = arguments;
        this.details = details;
        this.messageKey = messageKey;
        this.messageSupplier = messageSupplier;
    }

    public String getCode() {
        return this.code;
    }

    public JsonNodePath getInstanceLocation() {
        return this.instanceLocation;
    }

    public JsonNodePath getEvaluationPath() {
        return this.evaluationPath;
    }

    public SchemaLocation getSchemaLocation() {
        return this.schemaLocation;
    }

    public String getProperty() {
        return this.property;
    }

    public Object[] getArguments() {
        return this.arguments;
    }

    public Map<String, Object> getDetails() {
        return this.details;
    }

    public String getMessage() {
        return this.messageSupplier.get();
    }

    public String getMessageKey() {
        return this.messageKey;
    }

    public boolean isValid() {
        return this.messageSupplier != null;
    }

    public String toString() {
        return this.messageSupplier.get();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ValidationMessage that = (ValidationMessage)o;
        if (this.type != null ? !this.type.equals(that.type) : that.type != null) {
            return false;
        }
        if (this.code != null ? !this.code.equals(that.code) : that.code != null) {
            return false;
        }
        if (this.instanceLocation != null ? !this.instanceLocation.equals(that.instanceLocation) : that.instanceLocation != null) {
            return false;
        }
        if (this.evaluationPath != null ? !this.evaluationPath.equals(that.evaluationPath) : that.evaluationPath != null) {
            return false;
        }
        if (this.details != null ? !this.details.equals(that.details) : that.details != null) {
            return false;
        }
        if (this.messageKey != null ? !this.messageKey.equals(that.messageKey) : that.messageKey != null) {
            return false;
        }
        return Arrays.equals(this.arguments, that.arguments);
    }

    public int hashCode() {
        int result = this.type != null ? this.type.hashCode() : 0;
        result = 31 * result + (this.code != null ? this.code.hashCode() : 0);
        result = 31 * result + (this.instanceLocation != null ? this.instanceLocation.hashCode() : 0);
        result = 31 * result + (this.evaluationPath != null ? this.evaluationPath.hashCode() : 0);
        result = 31 * result + (this.details != null ? this.details.hashCode() : 0);
        result = 31 * result + (this.arguments != null ? Arrays.hashCode(this.arguments) : 0);
        result = 31 * result + (this.messageKey != null ? this.messageKey.hashCode() : 0);
        return result;
    }

    public String getType() {
        return this.type;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static abstract class BuilderSupport<S> {
        protected String type;
        protected String code;
        protected JsonNodePath evaluationPath;
        protected SchemaLocation schemaLocation;
        protected JsonNodePath instanceLocation;
        protected String property;
        protected Object[] arguments;
        protected Map<String, Object> details;
        protected MessageFormat format;
        protected String message;
        protected Supplier<String> messageSupplier;
        protected MessageFormatter messageFormatter;
        protected String messageKey;

        public abstract S self();

        public S type(String type) {
            this.type = type;
            return this.self();
        }

        public S code(String code) {
            this.code = code;
            return this.self();
        }

        public S instanceLocation(JsonNodePath instanceLocation) {
            this.instanceLocation = instanceLocation;
            return this.self();
        }

        public S schemaLocation(SchemaLocation schemaLocation) {
            this.schemaLocation = schemaLocation;
            return this.self();
        }

        public S evaluationPath(JsonNodePath evaluationPath) {
            this.evaluationPath = evaluationPath;
            return this.self();
        }

        public S property(String property) {
            this.property = property;
            return this.self();
        }

        public S arguments(Object ... arguments) {
            this.arguments = arguments;
            return this.self();
        }

        public S details(Map<String, Object> details) {
            this.details = details;
            return this.self();
        }

        public S format(MessageFormat format) {
            this.format = format;
            return this.self();
        }

        @Deprecated
        public S customMessage(String message) {
            return this.message(message);
        }

        public S message(String message) {
            this.message = message;
            return this.self();
        }

        public S messageSupplier(Supplier<String> messageSupplier) {
            this.messageSupplier = messageSupplier;
            return this.self();
        }

        public S messageFormatter(MessageFormatter messageFormatter) {
            this.messageFormatter = messageFormatter;
            return this.self();
        }

        public S messageKey(String messageKey) {
            this.messageKey = messageKey;
            return this.self();
        }

        public ValidationMessage build() {
            Supplier<String> messageSupplier = this.messageSupplier;
            String messageKey = this.messageKey;
            if (StringUtils.isNotBlank(this.message)) {
                messageKey = this.message;
                if (this.message.contains("{")) {
                    Object[] objs = this.getMessageArguments();
                    MessageFormat format = new MessageFormat(this.message);
                    messageSupplier = new CachingSupplier<String>(() -> format.format(objs));
                } else {
                    messageSupplier = this.message::toString;
                }
            } else if (messageSupplier == null) {
                Object[] objs = this.getMessageArguments();
                MessageFormatter formatter = this.messageFormatter != null ? this.messageFormatter : this.format::format;
                messageSupplier = new CachingSupplier<String>(() -> formatter.format(objs));
            }
            return new ValidationMessage(this.type, this.code, this.evaluationPath, this.schemaLocation, this.instanceLocation, this.property, this.arguments, this.details, messageKey, messageSupplier);
        }

        protected Object[] getMessageArguments() {
            Object[] objs = new Object[(this.arguments == null ? 0 : this.arguments.length) + 1];
            objs[0] = this.instanceLocation;
            if (this.arguments != null) {
                for (int i = 1; i < objs.length; ++i) {
                    objs[i] = this.arguments[i - 1];
                }
            }
            return objs;
        }

        protected String getType() {
            return this.type;
        }

        protected String getCode() {
            return this.code;
        }

        protected JsonNodePath getEvaluationPath() {
            return this.evaluationPath;
        }

        protected SchemaLocation getSchemaLocation() {
            return this.schemaLocation;
        }

        protected JsonNodePath getInstanceLocation() {
            return this.instanceLocation;
        }

        protected String getProperty() {
            return this.property;
        }

        protected Object[] getArguments() {
            return this.arguments;
        }

        protected Map<String, Object> getDetails() {
            return this.details;
        }

        protected MessageFormat getFormat() {
            return this.format;
        }

        protected String getMessage() {
            return this.message;
        }

        protected Supplier<String> getMessageSupplier() {
            return this.messageSupplier;
        }

        protected MessageFormatter getMessageFormatter() {
            return this.messageFormatter;
        }

        protected String getMessageKey() {
            return this.messageKey;
        }
    }

    public static class Builder
    extends BuilderSupport<Builder> {
        @Override
        public Builder self() {
            return this;
        }
    }
}

