/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.schema;

import com.fasterxml.jackson.databind.JsonNode;
import com.networknt.schema.BaseJsonValidator;
import com.networknt.schema.CollectorContext;
import com.networknt.schema.ExecutionContext;
import com.networknt.schema.JsonNodePath;
import com.networknt.schema.JsonSchema;
import com.networknt.schema.MessageSourceValidationMessage;
import com.networknt.schema.SchemaLocation;
import com.networknt.schema.ValidationContext;
import com.networknt.schema.ValidationMessage;
import com.networknt.schema.ValidatorTypeCode;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NotValidator
extends BaseJsonValidator {
    private static final Logger logger = LoggerFactory.getLogger(NotValidator.class);
    private final JsonSchema schema;

    public NotValidator(SchemaLocation schemaLocation, JsonNodePath evaluationPath, JsonNode schemaNode, JsonSchema parentSchema, ValidationContext validationContext) {
        super(schemaLocation, evaluationPath, schemaNode, parentSchema, ValidatorTypeCode.NOT, validationContext);
        this.schema = validationContext.newSchema(schemaLocation, evaluationPath, schemaNode, parentSchema);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<ValidationMessage> validate(ExecutionContext executionContext, JsonNode node, JsonNode rootNode, JsonNodePath instanceLocation) {
        CollectorContext collectorContext = executionContext.getCollectorContext();
        Set<Object> errors = new HashSet();
        CollectorContext.Scope parentScope = collectorContext.enterDynamicScope();
        try {
            NotValidator.debug(logger, node, rootNode, instanceLocation);
            errors = this.schema.validate(executionContext, node, rootNode, instanceLocation);
            if (errors.isEmpty()) {
                Set<ValidationMessage> set = Collections.singleton(((MessageSourceValidationMessage.Builder)((MessageSourceValidationMessage.Builder)((MessageSourceValidationMessage.Builder)this.message().instanceLocation(instanceLocation)).locale(executionContext.getExecutionConfig().getLocale())).arguments(this.schema.toString())).build());
                return set;
            }
            Set<ValidationMessage> set = Collections.emptySet();
            return set;
        }
        finally {
            CollectorContext.Scope scope = collectorContext.exitDynamicScope();
            if (errors.isEmpty()) {
                parentScope.mergeWith(scope);
            }
        }
    }

    @Override
    public Set<ValidationMessage> walk(ExecutionContext executionContext, JsonNode node, JsonNode rootNode, JsonNodePath instanceLocation, boolean shouldValidateSchema) {
        if (shouldValidateSchema) {
            return this.validate(executionContext, node, rootNode, instanceLocation);
        }
        Set<ValidationMessage> errors = this.schema.walk(executionContext, node, rootNode, instanceLocation, shouldValidateSchema);
        if (errors.isEmpty()) {
            return Collections.singleton(((MessageSourceValidationMessage.Builder)((MessageSourceValidationMessage.Builder)((MessageSourceValidationMessage.Builder)this.message().instanceLocation(instanceLocation)).locale(executionContext.getExecutionConfig().getLocale())).arguments(this.schema.toString())).build());
        }
        return Collections.emptySet();
    }

    @Override
    public void preloadJsonSchema() {
        if (null != this.schema) {
            this.schema.initializeValidators();
        }
    }
}

