/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.schema;

import com.networknt.schema.AbsoluteIri;
import com.networknt.schema.JsonNodePath;
import com.networknt.schema.PathType;
import java.util.Objects;

public class SchemaLocation {
    private static final JsonNodePath JSON_POINTER = new JsonNodePath(PathType.JSON_POINTER);
    private static final JsonNodePath ANCHOR = new JsonNodePath(PathType.URI_REFERENCE);
    public static final SchemaLocation DOCUMENT = new SchemaLocation(null, JSON_POINTER);
    private final AbsoluteIri absoluteIri;
    private final JsonNodePath fragment;
    private volatile String value = null;

    public SchemaLocation(AbsoluteIri absoluteIri, JsonNodePath fragment) {
        this.absoluteIri = absoluteIri;
        this.fragment = fragment;
    }

    public SchemaLocation(AbsoluteIri absoluteIri) {
        this(absoluteIri, JSON_POINTER);
    }

    public AbsoluteIri getAbsoluteIri() {
        return this.absoluteIri;
    }

    public JsonNodePath getFragment() {
        return this.fragment;
    }

    public SchemaLocation append(String token) {
        return new SchemaLocation(this.absoluteIri, this.fragment.append(token));
    }

    public SchemaLocation append(int index) {
        return new SchemaLocation(this.absoluteIri, this.fragment.append(index));
    }

    public static SchemaLocation of(String iri) {
        if (iri == null) {
            return null;
        }
        if ("#".equals(iri)) {
            return DOCUMENT;
        }
        String[] iriParts = iri.split("#");
        AbsoluteIri absoluteIri = null;
        JsonNodePath fragment = JSON_POINTER;
        if (iriParts.length > 0) {
            absoluteIri = AbsoluteIri.of(iriParts[0]);
        }
        if (iriParts.length > 1) {
            fragment = Fragment.of(iriParts[1]);
        }
        return new SchemaLocation(absoluteIri, fragment);
    }

    public SchemaLocation resolve(String absoluteIriReferenceOrFragment) {
        if ("#".equals(absoluteIriReferenceOrFragment)) {
            return new SchemaLocation(this.getAbsoluteIri(), JSON_POINTER);
        }
        JsonNodePath fragment = JSON_POINTER;
        String[] parts = absoluteIriReferenceOrFragment.split("#");
        AbsoluteIri absoluteIri = this.getAbsoluteIri();
        if (absoluteIri != null) {
            if (!parts[0].isEmpty()) {
                absoluteIri = absoluteIri.resolve(parts[0]);
            }
        } else {
            absoluteIri = AbsoluteIri.of(parts[0]);
        }
        if (parts.length > 1 && !parts[1].isEmpty()) {
            fragment = Fragment.of(parts[1]);
        }
        return new SchemaLocation(absoluteIri, fragment);
    }

    public static String resolve(SchemaLocation schemaLocation, String absoluteIriReferenceOrFragment) {
        if ("#".equals(absoluteIriReferenceOrFragment)) {
            return schemaLocation.getAbsoluteIri().toString() + "#";
        }
        String[] parts = absoluteIriReferenceOrFragment.split("#");
        AbsoluteIri absoluteIri = schemaLocation.getAbsoluteIri();
        String resolved = parts[0];
        if (absoluteIri != null) {
            resolved = !parts[0].isEmpty() ? absoluteIri.resolve(parts[0]).toString() : absoluteIri.toString();
        }
        resolved = parts.length > 1 && !parts[1].isEmpty() ? resolved + "#" + parts[1] : resolved + "#";
        return resolved;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        if (this.value == null) {
            if (this.absoluteIri != null && this.fragment == null) {
                this.value = this.absoluteIri.toString();
            } else {
                StringBuilder result = new StringBuilder();
                if (this.absoluteIri != null) {
                    result.append(this.absoluteIri.toString());
                }
                result.append("#");
                if (this.fragment != null) {
                    result.append(this.fragment.toString());
                }
                this.value = result.toString();
            }
        }
        return this.value;
    }

    public int hashCode() {
        return Objects.hash(this.fragment, this.absoluteIri);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SchemaLocation other = (SchemaLocation)obj;
        return Objects.equals(this.fragment, other.fragment) && Objects.equals(this.absoluteIri, other.absoluteIri);
    }

    public static class Builder {
        private AbsoluteIri absoluteIri;
        private JsonNodePath fragment = SchemaLocation.access$000();

        protected Builder absoluteIri(AbsoluteIri absoluteIri) {
            this.absoluteIri = absoluteIri;
            return this;
        }

        protected Builder absoluteIri(String absoluteIri) {
            return this.absoluteIri(AbsoluteIri.of(absoluteIri));
        }

        protected Builder fragment(JsonNodePath fragment) {
            this.fragment = fragment;
            return this;
        }

        protected Builder fragment(String fragment) {
            return this.fragment(Fragment.of(fragment));
        }

        public SchemaLocation build() {
            return new SchemaLocation(this.absoluteIri, this.fragment);
        }
    }

    public static class Fragment {
        public static JsonNodePath of(String fragmentString) {
            if (fragmentString.startsWith("#")) {
                fragmentString = fragmentString.substring(1);
            }
            JsonNodePath fragment = JSON_POINTER;
            String[] fragmentParts = fragmentString.split("/");
            boolean jsonPointer = false;
            if (fragmentString.startsWith("/")) {
                jsonPointer = true;
            } else {
                fragment = ANCHOR;
            }
            int index = -1;
            for (int fragmentPartIndex = 0; fragmentPartIndex < fragmentParts.length; ++fragmentPartIndex) {
                if (fragmentPartIndex == 0 && jsonPointer) continue;
                String fragmentPart = fragmentParts[fragmentPartIndex];
                for (int x = 0; x < fragmentPart.length(); ++x) {
                    char ch = fragmentPart.charAt(x);
                    if (ch >= '0' && ch <= '9') {
                        index = x == 0 ? 0 : (index *= 10);
                        index += ch - 48;
                        continue;
                    }
                    index = -1;
                    break;
                }
                fragment = index != -1 ? fragment.append(index) : fragment.append(fragmentPart.toString());
            }
            return fragment;
        }

        public static boolean isFragment(String fragmentString) {
            return fragmentString.startsWith("#");
        }

        public static boolean isJsonPointerFragment(String fragmentString) {
            return fragmentString.startsWith("#/");
        }

        public static boolean isAnchorFragment(String fragmentString) {
            return Fragment.isFragment(fragmentString) && !Fragment.isDocumentFragment(fragmentString) && !Fragment.isJsonPointerFragment(fragmentString);
        }

        public static boolean isDocumentFragment(String fragmentString) {
            return "#".equals(fragmentString);
        }
    }
}

