/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.schema;

import com.fasterxml.jackson.databind.JsonNode;
import com.networknt.schema.BaseJsonValidator;
import com.networknt.schema.ExecutionContext;
import com.networknt.schema.JsonNodePath;
import com.networknt.schema.JsonSchema;
import com.networknt.schema.MessageSourceValidationMessage;
import com.networknt.schema.SchemaLocation;
import com.networknt.schema.SpecVersion;
import com.networknt.schema.SpecVersionDetector;
import com.networknt.schema.ValidationContext;
import com.networknt.schema.ValidationMessage;
import com.networknt.schema.ValidatorTypeCode;
import com.networknt.schema.VersionCode;
import java.util.Collection;
import java.util.Collections;
import java.util.Locale;
import java.util.Optional;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContainsValidator
extends BaseJsonValidator {
    private static final Logger logger = LoggerFactory.getLogger(ContainsValidator.class);
    private static final String CONTAINS_MAX = "contains.max";
    private static final String CONTAINS_MIN = "contains.min";
    private static final SpecVersion.VersionFlag DEFAULT_VERSION = SpecVersion.VersionFlag.V6;
    private final JsonSchema schema;
    private final boolean isMinV201909;
    private int min = 1;
    private int max = Integer.MAX_VALUE;

    public ContainsValidator(SchemaLocation schemaLocation, JsonNodePath evaluationPath, JsonNode schemaNode, JsonSchema parentSchema, ValidationContext validationContext) {
        super(schemaLocation, evaluationPath, schemaNode, parentSchema, ValidatorTypeCode.CONTAINS, validationContext);
        this.isMinV201909 = VersionCode.MinV201909.getVersions().contains((Object)SpecVersionDetector.detectOptionalVersion(validationContext.getMetaSchema().getUri()).orElse(DEFAULT_VERSION));
        if (schemaNode.isObject() || schemaNode.isBoolean()) {
            this.schema = validationContext.newSchema(schemaLocation, evaluationPath, schemaNode, parentSchema);
            JsonNode parentSchemaNode = parentSchema.getSchemaNode();
            Optional.ofNullable(parentSchemaNode.get(ValidatorTypeCode.MAX_CONTAINS.getValue())).filter(JsonNode::canConvertToExactIntegral).ifPresent(node -> {
                this.max = node.intValue();
            });
            Optional.ofNullable(parentSchemaNode.get(ValidatorTypeCode.MIN_CONTAINS.getValue())).filter(JsonNode::canConvertToExactIntegral).ifPresent(node -> {
                this.min = node.intValue();
            });
        } else {
            this.schema = null;
        }
    }

    @Override
    public Set<ValidationMessage> validate(ExecutionContext executionContext, JsonNode node, JsonNode rootNode, JsonNodePath instanceLocation) {
        ContainsValidator.debug(logger, node, rootNode, instanceLocation);
        if (null != this.schema && node.isArray()) {
            Collection<JsonNodePath> evaluatedItems = executionContext.getCollectorContext().getEvaluatedItems();
            int actual = 0;
            int i = 0;
            for (JsonNode n : node) {
                JsonNodePath path;
                if (this.schema.validate(executionContext, n, rootNode, path = instanceLocation.append(i)).isEmpty()) {
                    ++actual;
                    if (executionContext.getExecutionConfig().getAnnotationAllowedPredicate().test(this.getKeyword())) {
                        evaluatedItems.add(path);
                    }
                }
                ++i;
            }
            if (actual < this.min) {
                if (this.isMinV201909) {
                    this.updateValidatorType(ValidatorTypeCode.MIN_CONTAINS);
                }
                return this.boundsViolated(this.isMinV201909 ? CONTAINS_MIN : ValidatorTypeCode.CONTAINS.getValue(), executionContext.getExecutionConfig().getLocale(), instanceLocation, this.min);
            }
            if (actual > this.max) {
                if (this.isMinV201909) {
                    this.updateValidatorType(ValidatorTypeCode.MAX_CONTAINS);
                }
                return this.boundsViolated(this.isMinV201909 ? CONTAINS_MAX : ValidatorTypeCode.CONTAINS.getValue(), executionContext.getExecutionConfig().getLocale(), instanceLocation, this.max);
            }
        }
        return Collections.emptySet();
    }

    @Override
    public void preloadJsonSchema() {
        Optional.ofNullable(this.schema).ifPresent(JsonSchema::initializeValidators);
    }

    private Set<ValidationMessage> boundsViolated(String messageKey, Locale locale, JsonNodePath instanceLocation, int bounds) {
        return Collections.singleton(((MessageSourceValidationMessage.Builder)((MessageSourceValidationMessage.Builder)((MessageSourceValidationMessage.Builder)((MessageSourceValidationMessage.Builder)this.message().instanceLocation(instanceLocation)).messageKey(messageKey)).locale(locale)).arguments(String.valueOf(bounds), this.schema.getSchemaNode().toString())).build());
    }
}

