/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.schema;

import com.fasterxml.jackson.databind.JsonNode;
import com.networknt.schema.BaseJsonValidator;
import com.networknt.schema.CollectorContext;
import com.networknt.schema.CustomErrorMessageType;
import com.networknt.schema.ExecutionContext;
import com.networknt.schema.JsonSchema;
import com.networknt.schema.JsonSchemaException;
import com.networknt.schema.JsonSchemaRef;
import com.networknt.schema.ValidationContext;
import com.networknt.schema.ValidationMessage;
import com.networknt.schema.ValidatorTypeCode;
import com.networknt.schema.uri.URIFactory;
import com.networknt.schema.urn.URNFactory;
import java.net.URI;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RefValidator
extends BaseJsonValidator {
    private static final Logger logger = LoggerFactory.getLogger(RefValidator.class);
    protected JsonSchemaRef schema;
    private JsonSchema parentSchema;
    private static final String REF_CURRENT = "#";
    private static final String URN_SCHEME = "urn";

    public RefValidator(String schemaPath, JsonNode schemaNode, JsonSchema parentSchema, ValidationContext validationContext) {
        super(schemaPath, schemaNode, parentSchema, ValidatorTypeCode.REF, validationContext);
        String refValue = schemaNode.asText();
        this.parentSchema = parentSchema;
        this.schema = RefValidator.getRefSchema(parentSchema, validationContext, refValue);
        if (this.schema == null) {
            throw new JsonSchemaException(ValidationMessage.of(ValidatorTypeCode.REF.getValue(), CustomErrorMessageType.of("internal.unresolvedRef"), new MessageFormat("{0}: Reference {1} cannot be resolved"), schemaPath, schemaPath, refValue));
        }
    }

    static JsonSchemaRef getRefSchema(JsonSchema parentSchema, ValidationContext validationContext, String refValue) {
        String refValueOriginal = refValue;
        JsonSchema parent = parentSchema;
        if (!refValue.startsWith(REF_CURRENT)) {
            JsonSchemaRef ref;
            int index = refValue.indexOf(REF_CURRENT);
            String refUri = index > 0 ? refValue.substring(0, index) : refValue;
            URI schemaUri = RefValidator.determineSchemaUri(validationContext.getURIFactory(), parent, refUri);
            if (schemaUri == null) {
                if (validationContext.getURNFactory() == null) {
                    return null;
                }
                schemaUri = RefValidator.determineSchemaUrn(validationContext.getURNFactory(), refUri);
                if (schemaUri == null) {
                    return null;
                }
            } else if (URN_SCHEME.equals(schemaUri.getScheme()) && (ref = RefValidator.getJsonSchemaRef(parent, validationContext, schemaUri.toString(), refValueOriginal)) != null) {
                return ref;
            }
            parent = validationContext.getJsonSchemaFactory().getSchema(schemaUri, validationContext.getConfig());
            if (index < 0) {
                return new JsonSchemaRef(parent.findAncestor());
            }
            refValue = refValue.substring(index);
        }
        if (refValue.equals(REF_CURRENT)) {
            return new JsonSchemaRef(parent.findAncestor());
        }
        return RefValidator.getJsonSchemaRef(parent, validationContext, refValue, refValueOriginal);
    }

    private static JsonSchemaRef getJsonSchemaRef(JsonSchema parent, ValidationContext validationContext, String refValue, String refValueOriginal) {
        JsonNode node = parent.getRefSchemaNode(refValue);
        if (node != null) {
            JsonSchemaRef ref = validationContext.getReferenceParsingInProgress(refValueOriginal);
            if (ref == null) {
                JsonSchema schema = validationContext.newSchema(refValue, node, parent);
                ref = new JsonSchemaRef(schema);
                validationContext.setReferenceParsingInProgress(refValueOriginal, ref);
            }
            return ref;
        }
        return null;
    }

    private static URI determineSchemaUri(URIFactory uriFactory, JsonSchema parentSchema, String refUri) {
        URI schemaUri;
        URI currentUri = parentSchema.getCurrentUri();
        try {
            schemaUri = currentUri == null ? uriFactory.create(refUri) : uriFactory.create(currentUri, refUri);
        }
        catch (IllegalArgumentException e) {
            schemaUri = null;
        }
        return schemaUri;
    }

    private static URI determineSchemaUrn(URNFactory urnFactory, String refUri) {
        URI schemaUrn;
        try {
            schemaUrn = urnFactory.create(refUri);
        }
        catch (IllegalArgumentException e) {
            schemaUrn = null;
        }
        return schemaUrn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<ValidationMessage> validate(ExecutionContext executionContext, JsonNode node, JsonNode rootNode, String at) {
        CollectorContext collectorContext = executionContext.getCollectorContext();
        Set<Object> errors = new HashSet();
        CollectorContext.Scope parentScope = collectorContext.enterDynamicScope();
        try {
            RefValidator.debug(logger, node, rootNode, at);
            this.schema.getSchema().getValidationContext().setConfig(this.parentSchema.getValidationContext().getConfig());
            errors = this.schema != null ? this.schema.validate(executionContext, node, rootNode, at) : Collections.emptySet();
        }
        finally {
            CollectorContext.Scope scope = collectorContext.exitDynamicScope();
            if (errors.isEmpty()) {
                parentScope.mergeWith(scope);
            }
        }
        return errors;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<ValidationMessage> walk(ExecutionContext executionContext, JsonNode node, JsonNode rootNode, String at, boolean shouldValidateSchema) {
        CollectorContext collectorContext = executionContext.getCollectorContext();
        Set<ValidationMessage> errors = new HashSet<ValidationMessage>();
        CollectorContext.Scope parentScope = collectorContext.enterDynamicScope();
        try {
            RefValidator.debug(logger, node, rootNode, at);
            this.schema.getSchema().getValidationContext().setConfig(this.parentSchema.getValidationContext().getConfig());
            if (this.schema != null) {
                errors = this.schema.walk(executionContext, node, rootNode, at, shouldValidateSchema);
            }
            HashSet<ValidationMessage> hashSet = errors;
            return hashSet;
        }
        finally {
            CollectorContext.Scope scope = collectorContext.exitDynamicScope();
            if (shouldValidateSchema && errors.isEmpty()) {
                parentScope.mergeWith(scope);
            }
        }
    }

    public JsonSchemaRef getSchemaRef() {
        return this.schema;
    }

    @Override
    public void preloadJsonSchema() {
        this.schema.getSchema().initializeValidators();
    }
}

